/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.AbstractRawDataContainer;
import com.tiani.base.data.Histogram;
import com.tiani.base.data.IImageRegionProperties;
import com.tiani.base.data.ImagePointProperties;
import com.tiani.base.data.ImageRegion;
import com.tiani.base.data.ImageRegionProperties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class RawDataContainer16CT
extends AbstractRawDataContainer {
    private static final ALogger log = ALogger.getLogger(RawDataContainer16CT.class);

    public RawDataContainer16CT(IPixelDataFrame<?> iPixelDataFrame) {
        super(iPixelDataFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Histogram getHistogram() {
        if (this.histogram == null) {
            RawDataContainer16CT rawDataContainer16CT = this;
            synchronized (rawDataContainer16CT) {
                if (this.histogram == null) {
                    IPixelAccessor<?> iPixelAccessor = this.getAccessor();
                    short[] sArray = (short[])iPixelAccessor.getData();
                    int n = this.pixelDataFrame.getHighBit();
                    this.histogram = new Histogram(sArray, 0, this.pixelDataFrame.getNumPixels(), 2 << n, this.pixelDataFrame.isSigned() ? 1 << n : 0);
                    iPixelAccessor.release();
                    this.notify();
                }
            }
        }
        return this.histogram;
    }

    @Override
    public IImageRegionProperties getImageRegionProperties(ImageRegion imageRegion, int n, int n2, IValueMapping iValueMapping, Integer n3, Integer n4) {
        IImageRegionProperties iImageRegionProperties;
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        short[] sArray = (short[])iPixelAccessor.getData();
        int n5 = this.pixelDataFrame.getWidth();
        int n6 = this.pixelDataFrame.getHeight();
        int n7 = this.pixelDataFrame.getHighBit();
        if (imageRegion.clip == null) {
            if (imageRegion.x >= 0 && imageRegion.x < n5 && imageRegion.y >= 0 && imageRegion.y < n6) {
                int n8 = this.pixelDataFrame.isSigned() ? sArray[imageRegion.x + imageRegion.y * n5] : sArray[imageRegion.x + imageRegion.y * n5] & 0xFFFF;
                iImageRegionProperties = new ImagePointProperties(n8, iValueMapping);
            } else {
                iImageRegionProperties = IImageRegionProperties.INVALID;
            }
        } else {
            Histogram histogram = new Histogram(sArray, 2 << n7, n5, n6, imageRegion.clip, iValueMapping, n3, n4, this.pixelDataFrame.isSigned() ? 1 << n7 : 0);
            iImageRegionProperties = new ImageRegionProperties(histogram);
        }
        iPixelAccessor.release();
        return iImageRegionProperties;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void fastSubsampling(Object var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int var14_14) {
        var15_15 = this.getAccessor();
        var16_16 = (short[])var15_15.getData();
        var17_17 = this.pixelDataFrame.getWidth();
        var18_18 = (short[])var1_1;
        var19_19 = (var12_12 - 256 << 2) / (var2_2 - 1);
        var20_20 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var21_21 = var10_10 << 2;
        var22_22 = var11_11 << 2;
        while (var21_21 >= 1024) {
            var21_21 -= 1024;
        }
        while (var22_22 >= 1024) {
            var22_22 -= 1024;
        }
        var23_23 = var21_21;
        var24_24 = var6_6 + var7_7 * var17_17;
        var25_25 = var4_4;
        var26_26 = var24_24;
        var27_27 = 0;
        ** GOTO lbl43
        {
            var22_22 -= 1024;
            var24_24 += var17_17;
            do {
                if (var22_22 >= 512) continue block2;
                var26_26 = var24_24;
                var28_28 = var25_25;
                var22_22 += var20_20;
                var21_21 = var23_23;
                var29_29 = 0;
                while (var29_29 < var2_2) {
                    if (var21_21 >= 512) {
                        while (var21_21 >= 512) {
                            var21_21 -= 1024;
                            ++var26_26;
                        }
                    }
                    var18_18[var28_28] = var29_29 == var2_2 - 1 && var27_27 == var3_3 - 1 ? (short)(var14_14 + var16_16[var26_26] & 65535) : (var27_27 == var3_3 - 1 ? (short)((var14_14 + var16_16[var26_26] & 65535) + (var14_14 + var16_16[var26_26 + 1] & 65535) >> 1) : (var29_29 == var2_2 - 1 ? (short)((var14_14 + var16_16[var26_26] & 65535) + (var14_14 + var16_16[var26_26 + var17_17] & 65535) >> 1) : (short)((var14_14 + var16_16[var26_26] & 65535) + (var14_14 + var16_16[var26_26 + 1] & 65535) + (var14_14 + var16_16[var26_26 + var17_17] & 65535) + (var14_14 + var16_16[var26_26 + var17_17 + 1] & 65535) >> 2)));
                    var21_21 += var19_19;
                    ++var28_28;
                    ++var29_29;
                }
                var25_25 += var5_5;
                ++var27_27;
lbl43:
                // 2 sources

            } while (var27_27 < var3_3);
        }
        var15_15.release();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void fastSubsampling(Object var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12, int var13_13, int[] var14_14, int var15_15) {
        var16_16 = this.getAccessor();
        var17_17 = var16_16.getMask();
        var18_18 = (short[])var16_16.getData();
        var19_19 = this.pixelDataFrame.getWidth();
        var20_20 = (int[])var1_1;
        var21_21 = (var12_12 - 256 << 2) / (var2_2 - 1);
        var22_22 = (var13_13 - 256 << 2) / (var3_3 - 1);
        var23_23 = var10_10 << 2;
        var24_24 = var11_11 << 2;
        while (var23_23 >= 1024) {
            var23_23 -= 1024;
        }
        while (var24_24 >= 1024) {
            var24_24 -= 1024;
        }
        var25_25 = var23_23;
        var26_26 = var6_6 + var7_7 * var19_19;
        var27_27 = var4_4;
        var28_28 = var26_26;
        var29_29 = 0;
        ** GOTO lbl44
        {
            var24_24 -= 1024;
            var26_26 += var19_19;
            do {
                if (var24_24 >= 512) continue block2;
                var28_28 = var26_26;
                var30_30 = var27_27;
                var24_24 += var22_22;
                var23_23 = var25_25;
                var31_31 = 0;
                while (var31_31 < var2_2) {
                    if (var23_23 >= 512) {
                        while (var23_23 >= 512) {
                            var23_23 -= 1024;
                            ++var28_28;
                        }
                    }
                    var20_20[var30_30] = var31_31 == var2_2 - 1 && var29_29 == var3_3 - 1 ? var14_14[var15_15 + var18_18[var28_28] & var17_17] : (var29_29 == var3_3 - 1 ? var14_14[(var15_15 + var18_18[var28_28] & var17_17) + (var15_15 + var18_18[var28_28 + 1] & var17_17) >> 1] : (var31_31 == var2_2 - 1 ? var14_14[(var15_15 + var18_18[var28_28] & var17_17) + (var15_15 + var18_18[var28_28 + var19_19] & var17_17) >> 1] : var14_14[(var15_15 + var18_18[var28_28] & var17_17) + (var15_15 + var18_18[var28_28 + 1] & var17_17) + (var15_15 + var18_18[var28_28 + var19_19] & var17_17) + (var15_15 + var18_18[var28_28 + var19_19 + 1] & var17_17) >> 2]));
                    var23_23 += var21_21;
                    ++var30_30;
                    ++var31_31;
                }
                var27_27 += var5_5;
                ++var29_29;
lbl44:
                // 2 sources

            } while (var29_29 < var3_3);
        }
        var16_16.release();
    }

    @Override
    protected void copyFull(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        short[] sArray = (short[])iPixelAccessor.getData();
        int n8 = this.pixelDataFrame.getWidth();
        if (n2 == this.pixelDataFrame.getHeight() && n == n8 && n7 == 0 && n5 == 0 && n6 == 0 && n4 == n) {
            System.arraycopy(sArray, 0, object, n3, n * n2);
        } else {
            short[] sArray2 = (short[])object;
            int n9 = n3;
            int n10 = n5 + n6 * n8;
            int n11 = 0;
            while (n11 < n2) {
                int n12 = 0;
                while (n12 < n) {
                    sArray2[n9 + n12] = (short)(n7 + sArray[n10 + n12]);
                    ++n12;
                }
                n9 += n4;
                n10 += n8;
                ++n11;
            }
        }
        iPixelAccessor.release();
    }

    @Override
    protected void copyFull(Object object, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n8 = iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        int n9 = this.pixelDataFrame.getWidth();
        int[] nArray2 = (int[])object;
        int n10 = n3;
        int n11 = n5 + n6 * n9;
        int n12 = 0;
        while (n12 < n2) {
            int n13 = 0;
            while (n13 < n) {
                nArray2[n10 + n13] = nArray[n7 + sArray[n11 + n13] & n8];
                ++n13;
            }
            n10 += n4;
            n11 += n9;
            ++n12;
        }
        iPixelAccessor.release();
    }

    @Override
    protected void enlarge(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        short[] sArray = (short[])iPixelAccessor.getData();
        int n14 = this.pixelDataFrame.getWidth();
        short[] sArray2 = (short[])object;
        int n15 = (n11 - 256 << 8) / n;
        int n16 = (n12 - 256 << 8) / n2;
        int n17 = 0;
        int n18 = 0;
        if (n15 < 65535 && n16 < 65535) {
            int n19 = n10 << 8;
            int n20 = 0;
            while (n20 < n2) {
                int n21 = n9 << 8;
                int n22 = (n19 >> 16) * n14;
                int n23 = n22 + n14;
                int n24 = n19 >> 4 & 0xFFF;
                int n25 = 4096 - n24;
                int n26 = n3 + n20 * n4;
                int n27 = 1048575;
                int n28 = 0;
                while (n28 < n) {
                    int n29 = n21 >> 16;
                    int n30 = n21 >> 4 & 0xFFF;
                    n21 += n15;
                    if (n30 <= n27) {
                        n17 = (n13 + sArray[n22 + n29] & 0xFFFF) * n25 + (n13 + sArray[n23 + n29] & 0xFFFF) * n24 >> 12;
                        n18 = (n13 + sArray[n22 + n29 + 1] & 0xFFFF) * n25 + (n13 + sArray[n23 + n29 + 1] & 0xFFFF) * n24 >> 12;
                    }
                    n27 = n30;
                    sArray2[n26 + n28] = (short)(n17 * (4096 - n30) + n18 * n30 >> 12);
                    ++n28;
                }
                n19 += n16;
                ++n20;
            }
        } else {
            int n31 = n10 << 8;
            int n32 = 0;
            while (n32 < n2) {
                int n33 = n9 << 8;
                int n34 = (n31 >> 16) * n14;
                int n35 = n34 + n14;
                int n36 = n31 >> 4 & 0xFFF;
                int n37 = 4096 - n36;
                int n38 = n3 + n32 * n4;
                int n39 = 0;
                while (n39 < n) {
                    int n40 = n33 >> 16;
                    int n41 = n33 >> 4 & 0xFFF;
                    n33 += n15;
                    n17 = (n13 + sArray[n34 + n40] & 0xFFFF) * n37 + (n13 + sArray[n35 + n40] & 0xFFFF) * n36 >> 12;
                    n18 = (n13 + sArray[n34 + n40 + 1] & 0xFFFF) * n37 + (n13 + sArray[n35 + n40 + 1] & 0xFFFF) * n36 >> 12;
                    sArray2[n38 + n39] = (short)(n17 * (4096 - n41) + n18 * n41 >> 12);
                    ++n39;
                }
                n31 += n16;
                ++n32;
            }
        }
        iPixelAccessor.release();
    }

    @Override
    protected void enlarge(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray, int n13) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n14 = iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        int n15 = this.pixelDataFrame.getWidth();
        int[] nArray2 = (int[])object;
        int n16 = (n11 - 256 << 8) / n;
        int n17 = (n12 - 256 << 8) / n2;
        int n18 = 0;
        int n19 = 0;
        if (n16 < 65535 && n17 < 65535) {
            int n20 = n10 << 8;
            int n21 = 0;
            while (n21 < n2) {
                int n22 = n9 << 8;
                int n23 = (n20 >> 16) * n15;
                int n24 = n23 + n15;
                int n25 = n20 >> 4 & 0xFFF;
                int n26 = 4096 - n25;
                int n27 = n3 + n21 * n4;
                int n28 = 1048575;
                int n29 = 0;
                while (n29 < n) {
                    int n30 = n22 >> 16;
                    int n31 = n22 >> 4 & 0xFFF;
                    n22 += n16;
                    if (n31 <= n28) {
                        n18 = (n13 + sArray[n23 + n30] & 0xFFFF) * n26 + (n13 + sArray[n24 + n30] & 0xFFFF) * n25 >> 12;
                        n19 = (n13 + sArray[n23 + n30 + 1] & 0xFFFF) * n26 + (n13 + sArray[n24 + n30 + 1] & 0xFFFF) * n25 >> 12;
                    }
                    n28 = n31;
                    nArray2[n27 + n29] = nArray[n18 * (4096 - n31) + n19 * n31 >> 12 & n14];
                    ++n29;
                }
                n20 += n17;
                ++n21;
            }
        } else {
            int n32 = n10 << 8;
            int n33 = 0;
            while (n33 < n2) {
                int n34 = n9 << 8;
                int n35 = (n32 >> 16) * n15;
                int n36 = n35 + n15;
                int n37 = n32 >> 4 & 0xFFF;
                int n38 = 4096 - n37;
                int n39 = n3 + n33 * n4;
                int n40 = 0;
                while (n40 < n) {
                    int n41 = n34 >> 16;
                    int n42 = n34 >> 4 & 0xFFF;
                    n34 += n16;
                    n18 = (n13 + sArray[n35 + n41] & 0xFFFF) * n38 + (n13 + sArray[n36 + n41] & 0xFFFF) * n37 >> 12;
                    n19 = (n13 + sArray[n35 + n41 + 1] & 0xFFFF) * n38 + (n13 + sArray[n36 + n41 + 1] & 0xFFFF) * n37 >> 12;
                    nArray2[n39 + n40] = nArray[n18 * (4096 - n42) + n19 * n42 >> 12 & n14];
                    ++n40;
                }
                n32 += n17;
                ++n33;
            }
        }
        iPixelAccessor.release();
    }

    @Override
    protected void extractBilinear(int n, int n2, int n3, int n4, Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        short[] sArray = (short[])iPixelAccessor.getData();
        short[] sArray2 = (short[])object;
        int n12 = n9 * 128;
        int n13 = n10 * 128;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n14 = 0;
        int n15 = 0;
        if (n12 < 0) {
            n14 = -1;
        }
        if (n13 < 0) {
            n15 = -1;
        }
        int n16 = 0;
        while (n16 < n) {
            nArray[n16] = n5 * (n8 + n9 * n16 / n);
            nArray2[n16] = n12 * n16 / n + n14 & 0x7F;
            ++n16;
        }
        n16 = n3;
        int n17 = 0;
        while (n17 < n2) {
            int n18 = n6 * (n7 + n10 * n17 / n2);
            int n19 = n13 * n17 / n2 + n15 & 0x7F;
            int n20 = 0;
            while (n20 < n) {
                int n21 = nArray[n20] + n18;
                sArray2[n16 + n20] = (short)(((n11 + sArray[n21] & 0xFFFF) * (128 - nArray2[n20]) + (n11 + sArray[n21 + n5] & 0xFFFF) * nArray2[n20]) * (128 - n19) + ((n11 + sArray[n21 + n6] & 0xFFFF) * (128 - nArray2[n20]) + (n11 + sArray[n21 + n6 + n5] & 0xFFFF) * nArray2[n20]) * n19 >> 14);
                ++n20;
            }
            n16 += n4;
            ++n17;
        }
        iPixelAccessor.release();
    }

    @Override
    protected void extractBilinear(int n, int n2, int n3, int n4, Object object, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray, int n11) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n12 = iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        int[] nArray2 = (int[])object;
        int n13 = n9 * 128;
        int n14 = n10 * 128;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n15 = 0;
        int n16 = 0;
        if (n13 < 0) {
            n15 = -1;
        }
        if (n14 < 0) {
            n16 = -1;
        }
        int n17 = 0;
        while (n17 < n) {
            nArray3[n17] = n5 * (n8 + n9 * n17 / n);
            nArray4[n17] = n13 * n17 / n + n15 & 0x7F;
            ++n17;
        }
        n17 = n3;
        int n18 = 0;
        while (n18 < n2) {
            int n19 = n6 * (n7 + n10 * n18 / n2);
            int n20 = n14 * n18 / n2 + n16 & 0x7F;
            int n21 = 0;
            while (n21 < n) {
                int n22 = nArray3[n21] + n19;
                nArray2[n17 + n21] = nArray[((n11 + sArray[n22] & n12) * (128 - nArray4[n21]) + (n11 + sArray[n22 + n5] & n12) * nArray4[n21]) * (128 - n20) + ((n11 + sArray[n22 + n6] & n12) * (128 - nArray4[n21]) + (n11 + sArray[n22 + n6 + n5] & n12) * nArray4[n21]) * n20 >> 14];
                ++n21;
            }
            n17 += n4;
            ++n18;
        }
        iPixelAccessor.release();
    }

    @Override
    protected void extractNearestNeighbor(int n, int n2, int n3, int n4, Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        short[] sArray = (short[])iPixelAccessor.getData();
        short[] sArray2 = (short[])object;
        int n12 = n3;
        int[] nArray = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray[n13] = n5 * (n8 + n9 * n13 / n);
            ++n13;
        }
        n13 = 0;
        while (n13 < n2) {
            int n14 = n6 * (n7 + n10 * n13 / n2);
            int n15 = 0;
            while (n15 < n) {
                sArray2[n12 + n15] = (short)(n11 + sArray[nArray[n15] + n14]);
                ++n15;
            }
            n12 += n4;
            ++n13;
        }
        iPixelAccessor.release();
    }

    @Override
    protected void extractNearestNeighbor(int n, int n2, int n3, int n4, Object object, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray, int n11) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n12 = iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        int[] nArray2 = (int[])object;
        int n13 = n3;
        int[] nArray3 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray3[n14] = n5 * (n8 + n9 * n14 / n);
            ++n14;
        }
        n14 = 0;
        while (n14 < n2) {
            int n15 = n6 * (n7 + n10 * n14 / n2);
            int n16 = 0;
            while (n16 < n) {
                nArray2[n13 + n16] = nArray[n11 + sArray[nArray3[n16] + n15] & n12];
                ++n16;
            }
            n13 += n4;
            ++n14;
        }
        iPixelAccessor.release();
    }

    @Override
    protected void extractSummedSubsampling(int n, int n2, int n3, int n4, Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n14 = this.pixelDataFrame.isSigned() ? -1 : iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        short[] sArray2 = (short[])object;
        int n15 = n3 - 1;
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        nArray[0] = n5 * (n8 + n11 * 0 / n);
        int n16 = 1;
        while (n16 <= n) {
            nArray[n16] = n5 * (n8 + n11 * n16 / n);
            nArray2[n16] = (nArray[n16] - nArray[n16 - 1]) / n5;
            ++n16;
        }
        n16 = n6 * (n7 + n12 * 0 / n2);
        int n17 = n5 * n10;
        int n18 = n6 * n9;
        int n19 = n9 * n10;
        int n20 = 1;
        while (n20 <= n2) {
            int n21 = n6 * (n7 + n12 * n20 / n2);
            int n22 = (n21 - n16) / n6 * n19;
            int n23 = 1;
            while (n23 <= n) {
                int n24 = nArray2[n23] * n22;
                if (n24 <= 1) {
                    sArray2[n15 + n23] = (short)(n13 + sArray[nArray[n23 - 1] + n16] & n14);
                } else {
                    int n25 = 0;
                    int n26 = n16;
                    while (n26 != n21) {
                        int n27 = nArray[n23 - 1];
                        while (n27 != nArray[n23]) {
                            n25 += n13 + sArray[n27 + n26] & n14;
                            n27 += n17;
                        }
                        n26 += n18;
                    }
                    sArray2[n15 + n23] = (short)(n25 / n24);
                }
                ++n23;
            }
            n16 = n21;
            n15 += n4;
            ++n20;
        }
        iPixelAccessor.release();
    }

    @Override
    protected void extractSummedSubsampling(int n, int n2, int n3, int n4, Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int[] nArray, int n13) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n14 = iPixelAccessor.getMask();
        short[] sArray = (short[])iPixelAccessor.getData();
        int[] nArray2 = (int[])object;
        int n15 = n3 - 1;
        int[] nArray3 = new int[n + 1];
        int[] nArray4 = new int[n + 1];
        nArray3[0] = n5 * (n8 + n11 * 0 / n);
        int n16 = 1;
        while (n16 <= n) {
            nArray3[n16] = n5 * (n8 + n11 * n16 / n);
            nArray4[n16] = (nArray3[n16] - nArray3[n16 - 1]) / n5;
            ++n16;
        }
        n16 = n6 * (n7 + n12 * 0 / n2);
        int n17 = n5 * n10;
        int n18 = n6 * n9;
        int n19 = n9 * n10;
        int n20 = 1;
        while (n20 <= n2) {
            int n21 = n6 * (n7 + n12 * n20 / n2);
            int n22 = (n21 - n16) / n6 * n19;
            int n23 = 1;
            while (n23 <= n) {
                int n24 = nArray4[n23] * n22;
                if (n24 <= 1) {
                    nArray2[n15 + n23] = nArray[n13 + sArray[nArray3[n23 - 1] + n16] & n14];
                } else {
                    int n25 = 0;
                    int n26 = n16;
                    while (n26 != n21) {
                        int n27 = nArray3[n23 - 1];
                        while (n27 != nArray3[n23]) {
                            n25 += n13 + sArray[n27 + n26] & n14;
                            n27 += n17;
                        }
                        n26 += n18;
                    }
                    nArray2[n15 + n23] = nArray[n25 / n24 & n14];
                }
                ++n23;
            }
            n16 = n21;
            n15 += n4;
            ++n20;
        }
        iPixelAccessor.release();
    }

    @Override
    public void storeToDicom(Attributes attributes) {
        IPixelAccessor<?> iPixelAccessor = this.getAccessor();
        int n = this.getRows() * this.getColumns();
        try {
            try {
                Object object = iPixelAccessor.getData();
                short[] sArray = (short[])object;
                byte[] byArray = DataCacheProviderFactory.getCache().allocBytes((long)(n * 2));
                int n2 = 0;
                while (n2 < n) {
                    byArray[n2 << 1] = (byte)(sArray[n2] & 0xFFFF);
                    byArray[(n2 << 1) + 1] = (byte)(sArray[n2] >> 8 & 0xFFFF);
                    ++n2;
                }
                attributes.setBytes(2145386512, VR.OB, byArray);
                attributes.setInt(2621456, VR.US, new int[]{this.getRows()});
                attributes.setInt(2621457, VR.US, new int[]{this.getColumns()});
            }
            catch (Exception exception) {
                log.error("Error adding pixel data to dicomobject.", (Throwable)exception);
                iPixelAccessor.release();
            }
        }
        finally {
            iPixelAccessor.release();
        }
    }
}

