/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.tiani.base.data.ImageInformation2;
import javax.vecmath.Vector3d;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ImageInformationNM
extends ImageInformation2 {
    private final int frameNumber;
    private double[] imagePosition;
    private double[] imageOrientation;

    public ImageInformationNM(Attributes attributes, int n) {
        super(attributes, false);
        this.frameNumber = n;
    }

    @Override
    public void reinit(Attributes attributes) {
        super.reinit(attributes);
        this.imageOrientation = this.getImageOrientationImpl();
        this.imagePosition = this.getImagePositionImpl();
        if (this.imagePosition == null) {
            this.imageOrientation = null;
        }
    }

    @Override
    public double[] getImagePosition() {
        return this.imagePosition;
    }

    @Override
    public double[] getImageOrientation() {
        return this.imageOrientation;
    }

    public Integer getNMVectorInt(int n) {
        int[] nArray;
        if (this.isNMVectorTag(n) && (nArray = this.getTagValues(this.dcm, n)) != null) {
            return nArray[this.frameNumber];
        }
        return null;
    }

    private int[] getTagValues(Attributes attributes, int n) {
        int[] nArray;
        if (attributes.contains(n) && (nArray = attributes.getInts(n)) != null && this.frameNumber < nArray.length) {
            return nArray;
        }
        return null;
    }

    private boolean isNMVectorTag(int n) {
        return n == 5505040 || n == 5505056 || n == 5505072 || n == 5505280 || n == 0x540050 || n == 5505120 || n == 5505136 || n == 5505168;
    }

    private double[] getImagePositionImpl() {
        Sequence sequence = this.dcm.getSequence(5505058);
        if (sequence != null && sequence.size() == 1) {
            double[] dArray = ((Attributes)sequence.get(0)).getDoubles(0x200032);
            double d = this.dcm.getDouble(0x180088, Double.NaN);
            Vector3d vector3d = this.getPlaneNormalUV();
            if (dArray != null && dArray.length == 3 && !Double.isNaN(d) && vector3d != null && vector3d.length() > 0.0) {
                double d2 = d * (double)this.frameNumber;
                return new double[]{dArray[0] + vector3d.x * d2, dArray[1] + vector3d.y * d2, dArray[2] + vector3d.z * d2};
            }
        }
        return null;
    }

    private double[] getImageOrientationImpl() {
        double[] dArray;
        Integer n;
        int n2;
        Sequence sequence = this.dcm.getSequence(5505058);
        if (sequence != null && (n2 = (n = this.getNMVectorInt(5505056)) == null && sequence.size() == 1 ? 0 : (n != null ? n - 1 : -1)) >= 0 && n2 < sequence.size() && (dArray = ((Attributes)sequence.get(n2)).getDoubles(2097207)) != null && dArray.length == 6) {
            return dArray;
        }
        return null;
    }
}

