/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.base.data;

import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.dicom.Laterality;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.valuemapping.RealWorldValueMapping;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.tiani.base.data.EnhancedMapping;
import com.tiani.base.data.ImageInformation2;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;

public class ImageInformationEnhanced
extends ImageInformation2 {
    private static final int FrameNumberTag = PrivateTagDictionary.frameNumber.getNumber();
    public static final char DELIMITER = '_';
    private static final PrivateTagDictionary PRIVATE_TAG_DICTIONARY = TagDictionary.getInstance().getPrivateTagDictionary();
    private Attributes frameDcm;
    private Map<Integer, Attributes> sequenceMap = new HashMap<Integer, Attributes>();
    private String key;
    private int temporalPosition = -1;
    private int frameNumber;

    public ImageInformationEnhanced(Attributes attributes, Attributes attributes2, int n) {
        super(attributes, false);
        this.frameDcm = attributes2 == null ? attributes : attributes2;
        this.key = this.sopInstanceUID + '_' + n;
        this.frameNumber = n;
        this.frameInit();
    }

    public void reinit(Attributes attributes, Attributes attributes2) {
        super.reinit(attributes);
        this.frameDcm = attributes2;
        this.sequenceMap.clear();
        this.frameInit();
    }

    @Override
    public void reinit(Attributes attributes) {
        throw new UnsupportedOperationException();
    }

    private void frameInit() {
        Attributes attributes;
        this.vLUT = VOILUT.create((Attributes)this.getDicomSequence(2658610));
        this.pLUT = null;
        this.mLUT = ModalityLUT.create((Attributes)this.getDicomSequence(2658629));
        if (PaletteColorLUTModule.hasLookupTable((Attributes)this.dcm)) {
            int[] nArray;
            this.properties.add(ImageInformation2.ImageProperties.HasColorLUT);
            attributes = PhotometricInterpretation.get((String)this.dcm.getString(2621444));
            if (attributes == PhotometricInterpretation.IndexedColor && (nArray = this.dcm.getInts(2625793)) != null && nArray.length == 3) {
                int n = nArray[0];
                if (n == 0) {
                    n = 65536;
                }
                this.vLUT = VOILUT.create((double)((n - 1 + nArray[1]) / 2), (double)(n - 1));
            }
        }
        if (this.vLUT == null) {
            this.vLUT = ImageInformationEnhanced.createMissingWindow(this);
        }
        if ((attributes = this.getDatasetPerFrame().getNestedDataset(2134289)) != null) {
            this.temporalPosition = attributes.getInt(2134312, -1);
        }
    }

    @Override
    protected boolean initLUTs() {
        return false;
    }

    @Override
    public Date getAcquisitionDateTime() {
        Attributes attributes = this.getDicomElement(524330);
        if (attributes == null) {
            return null;
        }
        return attributes.getDate(2251945843097650L);
    }

    @Override
    public Integer getAcquisitionNumber() {
        Attributes attributes = this.getDicomElement(0x200012);
        if (attributes == null) {
            return null;
        }
        return attributes.getInt(0x200012, 0);
    }

    @Override
    public Laterality getImageLaterality() {
        return Laterality.get((String)this.resolveString(2134130));
    }

    @Override
    public double[] getImageOrientation() {
        return this.getDoubles(2097207);
    }

    @Override
    public String[] getPatientOrientation() {
        Attributes attributes = this.getDicomElement(0x200020);
        if (attributes == null) {
            return null;
        }
        return attributes.getStrings(0x200020);
    }

    @Override
    public double[] getImagePosition() {
        return this.getDoubles(0x200032);
    }

    @Override
    public int getTemporalPosition() {
        return this.temporalPosition;
    }

    @Override
    public double[] getPixelSpacing() {
        if (this.hasImageRegionSpacing()) {
            return null;
        }
        return this.getDoubles(2621488);
    }

    @Override
    public Double getSliceLocation() {
        return this.getDouble(2101313);
    }

    @Override
    public Double getSliceThickness() {
        return this.getDouble(1572944);
    }

    @Override
    protected List<RealWorldValueMapping> createRealWorldValueMappings() {
        ArrayList<RealWorldValueMapping> arrayList = new ArrayList<RealWorldValueMapping>(1);
        arrayList.addAll(RealWorldValueMapping.create((Attributes)this.frameDcm));
        arrayList.addAll(RealWorldValueMapping.create((Attributes)this.dcm.getNestedDataset(1375769129)));
        return arrayList;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public Attributes getDatasetPerFrame() {
        return this.frameDcm;
    }

    @Override
    public String resolveString(int n) {
        int n2 = PRIVATE_TAG_DICTIONARY.convertToPublicTag(n);
        Attributes attributes = this.getDicomElement(n2);
        if (attributes == null) {
            return null;
        }
        return attributes.getString(n2);
    }

    @Override
    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        if (nArray == null) {
            return this.getDicomElement(PRIVATE_TAG_DICTIONARY.convertToPublicTag(n));
        }
        return DicomUtils.getNestedDataset((int[])nArray, (Attributes)this.getDataset(), (boolean)false);
    }

    @Override
    public String[] resolveStrings(int n) {
        if (n == FrameNumberTag) {
            return new String[]{Integer.toString(this.frameNumber)};
        }
        int n2 = PRIVATE_TAG_DICTIONARY.convertToPublicTag(n);
        Attributes attributes = this.getDicomElement(n2);
        if (attributes == null) {
            return null;
        }
        return attributes.getStrings(n2);
    }

    private Attributes remapTags(Attributes attributes, int n, int n2) {
        Attributes attributes2 = new Attributes(2);
        VR vR = ElementDictionary.vrOf((int)n, null);
        if (vR == VR.DS) {
            attributes2.setDouble(n, vR, attributes.getDoubles(n2));
        } else {
            attributes2.setString(n, vR, attributes.getString(n2));
        }
        return attributes2;
    }

    private Attributes getDicomElement(int n) {
        Attributes attributes;
        int n2 = EnhancedMapping.mapDicomTagToEquals(n);
        int n3 = EnhancedMapping.getSequenceForTag(n2);
        if (n3 == -1) {
            if (n2 != n) {
                return this.remapTags(this.dcm, n, n2);
            }
            return this.dcm;
        }
        if (!this.sequenceMap.containsKey(n3)) {
            this.sequenceMap.put(n3, EnhancedMapping.findSequence(n3, this.dcm, this.frameDcm));
        }
        if ((attributes = this.sequenceMap.get(n3)) != null) {
            if (n2 != n) {
                return this.remapTags(attributes, n, n2);
            }
            return attributes;
        }
        return null;
    }

    private double[] getDoubles(int n) {
        Attributes attributes = this.getDicomElement(n);
        if (attributes == null) {
            return null;
        }
        return attributes.getDoubles(n);
    }

    private Double getDouble(int n) {
        Attributes attributes = this.getDicomElement(n);
        if (attributes == null) {
            return null;
        }
        return attributes.getDouble(n, 0.0);
    }

    private Attributes getDicomSequence(int n) {
        Attributes attributes;
        if (!this.sequenceMap.containsKey(n)) {
            this.sequenceMap.put(n, EnhancedMapping.findSequence(n, this.dcm, this.frameDcm));
        }
        if ((attributes = this.sequenceMap.get(n)) != null) {
            return attributes;
        }
        return new Attributes();
    }

    @Override
    public Double getTriggerTime() {
        return null;
    }

    @Override
    public Double getDiffusionBValue() {
        double[] dArray = this.getDoubles(1609863);
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        return dArray[0];
    }

    @Override
    public Double getRepetitionTime() {
        return this.getDouble(0x180080);
    }

    @Override
    public Double getInversionTime() {
        return this.getDouble(1572994);
    }

    @Override
    public Double getEchoTime() {
        return this.getDouble(0x180081);
    }
}

