/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.windowingtree;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.windowingtree.WindowingTree;
import com.agfa.pacs.listtext.swingx.layout.RowLayout;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowHandlerBase;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.windowing.WindowingValue;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.expressions.EvaluableUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class WindowingTreeDlg
extends StandardDialog {
    private JPanel panelApplyOptions = null;
    private JRadioButton radioSingle = null;
    private JRadioButton radioSelected = null;
    private JRadioButton radioAll = null;
    private JScrollPane scrollPane = null;
    private WindowingTree tree = null;
    private VisDisplay2 listener = null;
    private JSpinner centerSpinner;
    private JSpinner widthSpinner;
    private String iconPath = "/icons/";
    private ImageIcon iconCenter = new TIcon(String.valueOf(this.iconPath) + "windowingcenter.gif");
    private ImageIcon iconWidth = new TIcon(String.valueOf(this.iconPath) + "windowingwidth.gif");

    public WindowingTreeDlg(VisDisplay2 visDisplay2) {
        super((Frame)JVision2.getMainFrame(), Messages.getString("FRAMETITLE_WINDOWINGTREE"));
        this.addOKButton(new OKAction());
        this.addCancelButton(new CancelAction());
        this.listener = visDisplay2;
        this.tree = new WindowingTree(this);
        this.tree.setOpaque(false);
        this.setContent(this.createMainPanel());
        this.initValues(visDisplay2);
        this.pack();
        this.initLocation();
    }

    private void initValues(VisDisplay2 visDisplay2) {
        VisData visData = visDisplay2.getData().getFirstSelectedVis();
        if (visData == null) {
            this.radioSelected.setEnabled(false);
            return;
        }
        View view = visData.getView();
        if (view instanceof ImgView2) {
            WindowHandlerBase windowHandlerBase = ((ImgView2)view).getWindowHandler();
            if (windowHandlerBase != null) {
                double d = WindowingTreeDlg.roundSelectively(windowHandlerBase.getWindow().getWidth());
                if (d < 0.0) {
                    d = -d;
                }
                this.centerSpinner.setValue(WindowingTreeDlg.roundSelectively(windowHandlerBase.getWindow().getCenter()));
                this.widthSpinner.setValue(d);
            }
        } else {
            Renderer renderer = view.getRenderer().getLeaf();
            Object object = renderer.resolveString("WINDOW_WIDTH");
            try {
                if (object != null) {
                    this.widthSpinner.setValue((Double)object);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            object = renderer.resolveString("WINDOW_CENTER");
            try {
                if (object != null) {
                    this.centerSpinner.setValue(EvaluableUtils.toDouble(object));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static double roundSelectively(double d) {
        if (-10.0 < d && d < 10.0) {
            return d;
        }
        return Math.round(d);
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout((LayoutManager)new RowLayout(10));
        this.panelApplyOptions = new JPanel();
        this.panelApplyOptions.setLayout(new GridLayout(1, 3, 4, 0));
        this.radioSingle = ComponentFactory.instance.createRadioButton(Messages.getString("WINDOWING_TREE_RADIO_SINGLE"));
        this.radioSelected = ComponentFactory.instance.createRadioButton(Messages.getString("WINDOWING_TREE_RADIO_SELECTED"));
        this.radioAll = ComponentFactory.instance.createRadioButton(Messages.getString("WINDOWING_TREE_RADIO_ALL"));
        this.radioSingle.setHorizontalAlignment(0);
        this.radioSelected.setHorizontalAlignment(0);
        this.radioAll.setHorizontalAlignment(0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioSingle);
        buttonGroup.add(this.radioSelected);
        buttonGroup.add(this.radioAll);
        this.panelApplyOptions.add(this.radioSingle);
        this.panelApplyOptions.add(this.radioSelected);
        this.panelApplyOptions.add(this.radioAll);
        this.panelApplyOptions.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("WindowingTreeDlg.ApplyTo")));
        this.scrollPane = ComponentFactory.instance.createScrollPane(this.tree, 20, 30, true, false);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.tree.getRowHeight());
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(this.tree.getRowHeight() * 10);
        this.scrollPane.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("WindowingTreeDlg.PredefinedValues")));
        JPanel jPanel2 = ComponentFactory.instance.createPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = ComponentFactory.instance.createPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(ComponentFactory.instance.createLabel(this.iconCenter));
        this.centerSpinner = ComponentFactory.instance.createSpinner(new SpinnerNumberModel((Number)1.0, null, null, (Number)1.0));
        jPanel3.add(this.centerSpinner);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = ComponentFactory.instance.createPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(ComponentFactory.instance.createLabel(this.iconWidth));
        this.widthSpinner = ComponentFactory.instance.createSpinner(new SpinnerNumberModel((Number)1.0, Double.valueOf(0.0), null, (Number)1.0));
        jPanel4.add(this.widthSpinner);
        jPanel2.add(jPanel4);
        jPanel2.setBorder(ComponentFactory.instance.createTitledBorder(Messages.getString("WindowingTreeDlg.CustomValue")));
        jPanel.add(this.scrollPane);
        jPanel.add(jPanel2);
        jPanel.add(this.panelApplyOptions);
        if (this.listener != null) {
            VisDisplay2 visDisplay2 = this.listener;
            if (visDisplay2.areAllVisSelected()) {
                this.radioSelected.setSelected(true);
            } else {
                this.radioAll.setSelected(true);
            }
        }
        return jPanel;
    }

    public void setValue(WindowingValue windowingValue) {
        int n = windowingValue.getWidth();
        if (n < 0) {
            n = -n;
        }
        this.centerSpinner.setValue(windowingValue.getCenter());
        this.widthSpinner.setValue(n);
    }

    public void apply(int n) {
        if (this.listener != null) {
            this.listener.onWindowingValueChange(new WindowValue((Double)this.centerSpinner.getValue(), (Double)this.widthSpinner.getValue()), n);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", Messages.getString("CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WindowingTreeDlg.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("ShortDescription", Messages.getString("APPLY"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TEventDispatch.SELECTED_VISUALS;
            if (WindowingTreeDlg.this.radioSingle.isSelected()) {
                n = TEventDispatch.LASTMODIFIED_VISUAL;
            }
            if (WindowingTreeDlg.this.radioSelected.isSelected()) {
                n = TEventDispatch.SELECTED_VISUALS;
            }
            if (WindowingTreeDlg.this.radioAll.isSelected()) {
                n = TEventDispatch.ALL_VISUALS;
            }
            WindowingTreeDlg.this.apply(n);
            WindowingTreeDlg.this.setVisible(false);
        }
    }
}

