/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vistoolbar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VisDisplayToolbarLayout
implements LayoutManager {
    private int gap;
    private Orientation orientation;

    public VisDisplayToolbarLayout(Orientation orientation, int n) {
        if (orientation == null) {
            throw new IllegalArgumentException("argument must not be null!");
        }
        this.orientation = orientation;
        this.gap = n < 0 ? 0 : n;
    }

    public int getVerticalGap() {
        return this.gap;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setGap(int n) {
        this.gap = Math.max(0, n);
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("argument must not be null!");
        }
        this.orientation = orientation;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (container.getComponentCount() > 0) {
            if (Orientation.Horizontal.equals((Object)this.orientation)) {
                int n3 = 0;
                Component[] componentArray = container.getComponents();
                int n4 = componentArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Component component = componentArray[n5];
                    Dimension dimension = component.getMinimumSize();
                    if (n3 < dimension.height) {
                        n3 = dimension.height;
                    }
                    n += dimension.width;
                    ++n5;
                }
                n2 += n3;
                n += (container.getComponentCount() - 1) * this.gap;
            } else if (Orientation.Vertical.equals((Object)this.orientation)) {
                int n6 = 0;
                Component[] componentArray = container.getComponents();
                int n7 = componentArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    Component component = componentArray[n8];
                    Dimension dimension = component.getMinimumSize();
                    if (n6 < dimension.width) {
                        n6 = dimension.width;
                    }
                    n2 += dimension.height;
                    ++n8;
                }
                n += n6;
                n2 += (container.getComponentCount() - 1) * this.gap;
            }
        }
        return new Dimension(n, n2);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (container.getComponentCount() > 0) {
            if (Orientation.Horizontal.equals((Object)this.orientation)) {
                int n3 = 0;
                Component[] componentArray = container.getComponents();
                int n4 = componentArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Component component = componentArray[n5];
                    Dimension dimension = component.getPreferredSize();
                    if (n3 < dimension.height) {
                        n3 = dimension.height;
                    }
                    n += dimension.width;
                    ++n5;
                }
                n2 += n3;
                n += (container.getComponentCount() - 1) * this.gap;
            } else if (Orientation.Vertical.equals((Object)this.orientation)) {
                int n6 = 0;
                Component[] componentArray = container.getComponents();
                int n7 = componentArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    Component component = componentArray[n8];
                    Dimension dimension = component.getPreferredSize();
                    if (n6 < dimension.width) {
                        n6 = dimension.width;
                    }
                    n2 += dimension.height;
                    ++n8;
                }
                n += n6;
                n2 += (container.getComponentCount() - 1) * this.gap;
            }
        }
        return new Dimension(n, n2);
    }

    @Override
    public void layoutContainer(Container container) {
        block8: {
            boolean bl;
            int n;
            block9: {
                boolean bl2;
                n = container.getComponentCount();
                if (n <= 0) break block8;
                if (!Orientation.Horizontal.equals((Object)this.orientation)) break block9;
                Insets insets = container.getInsets();
                int n2 = insets.top;
                int n3 = insets.left;
                int n4 = container.getWidth() - insets.left - insets.right;
                int n5 = container.getHeight() - insets.top - insets.bottom;
                boolean bl3 = bl2 = this.preferredLayoutSize((Container)container).width <= container.getWidth();
                if (bl2) {
                    int n6 = n4 / n;
                    int n7 = 0;
                    while (n7 < n) {
                        Component component = container.getComponent(n7);
                        int n8 = component.getPreferredSize().width;
                        component.setBounds(n3 + (n7 + 1) * n6 - n6 / 2 - n8 / 2, n2, n8, n5);
                        ++n7;
                    }
                } else {
                    int n9 = (n4 - (n - 1) * this.gap) / n;
                    int n10 = 0;
                    while (n10 < n) {
                        Component component = container.getComponent(n10);
                        component.setBounds(n3, n2, n9, n5);
                        n3 += n9 + (n10 < n - 1 ? this.gap : 0);
                        ++n10;
                    }
                }
                break block8;
            }
            if (!Orientation.Vertical.equals((Object)this.orientation)) break block8;
            Insets insets = container.getInsets();
            int n11 = insets.top;
            int n12 = insets.left;
            int n13 = container.getWidth() - insets.left - insets.right;
            int n14 = container.getHeight() - insets.top - insets.bottom;
            boolean bl4 = bl = this.preferredLayoutSize((Container)container).height <= container.getHeight();
            if (bl) {
                int n15 = n14 / n;
                int n16 = 0;
                while (n16 < n) {
                    Component component = container.getComponent(n16);
                    int n17 = component.getPreferredSize().height;
                    component.setBounds(n12, n11 + (n16 + 1) * n15 - n15 / 2 - n17 / 2, n13, n17);
                    ++n16;
                }
            } else {
                int n18 = (n14 - (n - 1) * this.gap) / n;
                int n19 = 0;
                while (n19 < n) {
                    Component component = container.getComponent(n19);
                    component.setBounds(n12, n11, n13, n18);
                    n11 += n18 + (n19 < n - 1 ? this.gap : 0);
                    ++n19;
                }
            }
        }
    }

    public static enum Orientation {
        Vertical,
        Horizontal;

    }
}

