/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.vismenu.AbstractVisMenuModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuConcreteAction;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.vis.Vis2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

class VisMenuSubmenuAction
extends VisMenuAction {
    static final String CAPTION_XML_ATTR_NAME = "caption";
    private static final String SUB_ACTION_REF_XML_ELEMENT_NAME = "sub-action-ref";
    static final String ACTION_ID = "VIS_MENU_SUBMENU";
    private static final ALogger log = ALogger.getLogger(VisMenuSubmenuAction.class);
    private String caption;
    private List<VisMenuAction> actions;
    private SubActionListener l;

    VisMenuSubmenuAction(int n, String string, List<VisMenuAction> list) {
        super(VisMenuSubmenuAction.wrapActionId(ACTION_ID), n);
        this.caption = string != null ? StringEscapeUtils.unescapeXml((String)string) : "";
        this.l = new SubActionListener();
        if (list != null) {
            this.actions = new ArrayList<VisMenuAction>(list);
            for (VisMenuAction visMenuAction : list) {
                visMenuAction.addActionListener(this.l);
            }
        }
    }

    public VisMenuSubmenuAction(int n, VisMenuSubmenuConcreteAction visMenuSubmenuConcreteAction) {
        super(visMenuSubmenuConcreteAction.getID(), n);
        this.caption = visMenuSubmenuConcreteAction.getCaption();
        this.l = new SubActionListener();
        PAction[] pActionArray = visMenuSubmenuConcreteAction.getSubactions();
        if (pActionArray != null && pActionArray.length > 0) {
            int n2 = 0;
            this.actions = new ArrayList<VisMenuAction>();
            PAction[] pActionArray2 = pActionArray;
            int n3 = pActionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                PAction object = pActionArray2[n4];
                if (object instanceof VisMenuSubmenuConcreteAction) {
                    this.actions.add(new VisMenuSubmenuAction(n2++, (VisMenuSubmenuConcreteAction)object));
                } else {
                    this.actions.add(new VisMenuAction(object.getID(), n2++));
                }
                ++n4;
            }
            for (VisMenuAction visMenuAction : this.actions) {
                visMenuAction.addActionListener(this.l);
            }
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) {
        if (!StringUtils.equals((CharSequence)this.caption, (CharSequence)string)) {
            this.caption = string;
            this.fireActionChanged();
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public VisMenuAction copy() {
        return new VisMenuSubmenuAction(this.getPosition(), this.caption, this.actions);
    }

    public List<VisMenuAction> getSubActions() {
        if (this.actions != null) {
            return Collections.unmodifiableList(this.actions);
        }
        return Collections.emptyList();
    }

    public Map<VisMenuAction, PAction> getSubActionMap(Vis2 vis2) {
        return this.createActionMap(this.actions, vis2);
    }

    public boolean insertActionAt(VisMenuAction visMenuAction, int n) {
        if (this.actions == null) {
            this.actions = new ArrayList<VisMenuAction>();
        }
        if (!this.actions.contains(visMenuAction)) {
            this.actions.add(n < 0 ? this.actions.size() : n, visMenuAction);
            this.updatePositionToIndex(this.actions);
            visMenuAction.addActionListener(this.l);
            this.fireActionChanged();
            return true;
        }
        return false;
    }

    public boolean removeAction(VisMenuAction visMenuAction) {
        if (this.actions != null) {
            boolean bl;
            boolean bl2 = visMenuAction.getActionId().equals("SEPARATOR") ? this.actions.remove(this.indexOfSeparatorAction(visMenuAction)) != null : (bl = this.actions.remove(visMenuAction));
            if (bl) {
                if (this.actions.isEmpty()) {
                    this.actions = null;
                }
                visMenuAction.removeActionListener(this.l);
                this.fireActionChanged();
                return true;
            }
        }
        return false;
    }

    public void removeAllActions() {
        if (this.actions != null && !this.actions.isEmpty()) {
            for (VisMenuAction visMenuAction : this.actions) {
                visMenuAction.removeActionListener(this.l);
            }
            this.actions.clear();
            this.fireActionChanged();
        }
    }

    public VisMenuSubmenuConcreteAction createAction(Vis2 vis2) {
        ArrayList<PAction> arrayList = null;
        if (this.actions != null && !this.actions.isEmpty()) {
            Map<VisMenuAction, PAction> map = this.createActionMap(this.actions, vis2);
            arrayList = new ArrayList<PAction>(map.size());
            for (PAction pAction : map.values()) {
                arrayList.add(pAction);
            }
        }
        return new VisMenuSubmenuConcreteAction(this.getActionId(), this.getCaption(), arrayList);
    }

    public static String createConcreteActionId() {
        return VisMenuSubmenuAction.wrapActionId(ACTION_ID);
    }

    private Map<VisMenuAction, PAction> createActionMap(List<VisMenuAction> list, Vis2 vis2) {
        if (list != null && !list.isEmpty()) {
            LinkedHashMap<VisMenuAction, PAction> linkedHashMap = new LinkedHashMap<VisMenuAction, PAction>(list.size());
            for (VisMenuAction visMenuAction : list) {
                try {
                    PAction pAction = AbstractVisMenuModel.resolveAction(visMenuAction, vis2);
                    if (pAction == null) continue;
                    linkedHashMap.put(visMenuAction, pAction);
                }
                catch (ActionNotFoundException actionNotFoundException) {
                    log.warn("Resolving vis-menu sub-menu action '" + visMenuAction.getActionId() + " failed! Skipped");
                }
            }
            return linkedHashMap;
        }
        return Collections.emptyMap();
    }

    @Override
    protected String attrsToXML() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(super.attrsToXML());
        stringBuilder.append(" ");
        stringBuilder.append(CAPTION_XML_ATTR_NAME);
        stringBuilder.append("=\"");
        stringBuilder.append(StringEscapeUtils.escapeXml((String)this.caption));
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    @Override
    protected String bodyToXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.bodyToXML());
        if (this.actions != null && !this.actions.isEmpty()) {
            for (VisMenuAction visMenuAction : this.actions) {
                stringBuilder.append(visMenuAction.toXML(SUB_ACTION_REF_XML_ELEMENT_NAME));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getPersistableActionId() {
        return VisMenuSubmenuAction.unwrapActionId(this.getActionId());
    }

    private int indexOfSeparatorAction(VisMenuAction visMenuAction) {
        if (this.actions != null) {
            int n = 0;
            for (VisMenuAction visMenuAction2 : this.actions) {
                if (visMenuAction2 == visMenuAction) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private void updatePositionToIndex(List<VisMenuAction> list) {
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                list.get(n).setPosition(n);
                ++n;
            }
        }
    }

    private static String wrapActionId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('@');
        stringBuffer.append(Integer.toString(ThreadLocalRandom.current().nextInt()));
        return stringBuffer.toString();
    }

    private static String unwrapActionId(String string) {
        return StringUtils.substringBefore((String)string, (String)Character.toString('@'));
    }

    private class SubActionListener
    implements VisMenuAction.VisMenuActionListener {
        private SubActionListener() {
        }

        @Override
        public void actionChanged(VisMenuAction visMenuAction) {
            VisMenuSubmenuAction.this.fireActionChanged();
        }
    }
}

