/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigListModel;
import com.agfa.pacs.impaxee.vismenu.AbstractVisMenuModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuActionConfigItem;
import com.agfa.pacs.impaxee.vismenu.VisMenuButtonsModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;

public class VisMenuButtonsConfigModel {
    private AbstractVisMenuModel menuModel;
    private List<VisMenuActionConfigItem> items;
    private VisMenuActionHandler actionListener;
    private ItemsListModelAdapter itemsModelAdapter;
    private Collection<IVisMenuConfigModelListener> listeners;
    private boolean modified = false;

    private VisMenuButtonsConfigModel(AbstractVisMenuModel abstractVisMenuModel) {
        this.menuModel = abstractVisMenuModel;
        this.actionListener = new VisMenuActionHandler();
        this.items = new ArrayList<VisMenuActionConfigItem>();
        this.itemsModelAdapter = new ItemsListModelAdapter(this.items);
        this.init();
    }

    public static VisMenuButtonsConfigModel createRuntimeInstance() {
        return new VisMenuButtonsConfigModel(VisMenuButtonsModel.getRuntimeInstance());
    }

    public static VisMenuButtonsConfigModel createInstance(AbstractVisMenuModel abstractVisMenuModel) {
        return new VisMenuButtonsConfigModel(abstractVisMenuModel);
    }

    public AbstractVisMenuModel getMenuModel() {
        return this.menuModel;
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public Collection<VisMenuActionConfigItem> getItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    public boolean addItem(VisMenuActionConfigItem visMenuActionConfigItem) {
        return this.insertItemAt(visMenuActionConfigItem, this.items.size());
    }

    public boolean insertItemAt(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
        boolean bl = false;
        if (!this.items.contains(visMenuActionConfigItem)) {
            visMenuActionConfigItem.getVisMenuAction().addActionListener(this.actionListener);
            this.items.add(n, visMenuActionConfigItem);
            this.updatePositionToIndex(this.items);
            bl = true;
        }
        if (bl) {
            this.modified = true;
            this.fireItemAdded(visMenuActionConfigItem);
        }
        return bl;
    }

    public boolean removeItem(VisMenuActionConfigItem visMenuActionConfigItem) {
        boolean bl = false;
        visMenuActionConfigItem.getVisMenuAction().removeActionListener(this.actionListener);
        bl = this.items.remove(visMenuActionConfigItem);
        if (bl) {
            this.updatePositionToIndex(this.items);
        }
        if (bl) {
            this.modified = true;
            this.fireItemRemoved(visMenuActionConfigItem);
        }
        return bl;
    }

    public void removeAllItems() {
        if (this.getItemCount() > 0) {
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                visMenuActionConfigItem.getVisMenuAction().removeActionListener(this.actionListener);
            }
            this.items.clear();
            this.modified = true;
            this.fireAllItemsRemoved();
        }
    }

    public IActionConfigListModel<VisMenuActionConfigItem> getItemsListModel() {
        return this.itemsModelAdapter;
    }

    public Collection<PAction> getAvailableActions() {
        List<PAction> list = PActionRegistry.getAllUserConfigurableTextActions();
        Iterator<PAction> object2 = list.iterator();
        while (object2.hasNext()) {
            if (ActionUIUtilities.isIconButtonAction(object2.next())) continue;
            object2.remove();
        }
        for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
            list.remove(visMenuActionConfigItem.getAction());
        }
        Collections.sort(list, new Comparator<PAction>(){

            @Override
            public int compare(PAction pAction, PAction pAction2) {
                String string = ActionUIUtilities.getActionConfigText(pAction);
                String string2 = ActionUIUtilities.getActionConfigText(pAction2);
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                if (string != null) {
                    return -1;
                }
                if (string2 != null) {
                    return 1;
                }
                return -1;
            }
        });
        return list;
    }

    public void update() {
        this.init();
    }

    public void save() {
        if (this.modified) {
            this.menuModel.removeAllActions();
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                this.menuModel.addAction(visMenuActionConfigItem.getVisMenuAction());
            }
            this.menuModel.save();
        }
    }

    public void addModelListener(IVisMenuConfigModelListener iVisMenuConfigModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IVisMenuConfigModelListener>();
        }
        if (!this.listeners.contains(iVisMenuConfigModelListener)) {
            this.listeners.add(iVisMenuConfigModelListener);
        }
    }

    public void removeModelListener(IVisMenuConfigModelListener iVisMenuConfigModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(iVisMenuConfigModelListener);
        }
    }

    private void init() {
        this.removeAllItems();
        for (Map.Entry<VisMenuAction, PAction> entry : this.menuModel.getActions(null).entrySet()) {
            VisMenuAction visMenuAction = entry.getKey().copy();
            visMenuAction.addActionListener(this.actionListener);
            this.items.add(VisMenuActionConfigItem.create(visMenuAction, entry.getValue()));
        }
        this.updatePositionToIndex(this.items);
        this.itemsModelAdapter.notifyModelChange();
        this.modified = false;
    }

    private void updatePositionToIndex(Collection<VisMenuActionConfigItem> collection) {
        int n = 0;
        for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
            visMenuActionConfigItem.getVisMenuAction().removeActionListener(this.actionListener);
            visMenuActionConfigItem.getVisMenuAction().setPosition(n);
            visMenuActionConfigItem.getVisMenuAction().addActionListener(this.actionListener);
            ++n;
        }
    }

    private static VisMenuActionConfigItem findItem(Collection<VisMenuActionConfigItem> collection, VisMenuAction visMenuAction) {
        for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
            if (!visMenuActionConfigItem.getVisMenuAction().equals(visMenuAction)) continue;
            return visMenuActionConfigItem;
        }
        return null;
    }

    private static VisMenuActionConfigItem findItem(Collection<VisMenuActionConfigItem> collection, PAction pAction) {
        for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
            if (!visMenuActionConfigItem.getAction().equals(pAction)) continue;
            return visMenuActionConfigItem;
        }
        return null;
    }

    private void fireItemAdded(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemAdded(visMenuActionConfigItem);
            }
        }
    }

    private void fireItemRemoved(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemRemoved(visMenuActionConfigItem);
            }
        }
    }

    private void fireItemChanged(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.itemChanged(visMenuActionConfigItem);
            }
        }
    }

    private void fireAllItemsRemoved() {
        if (this.listeners != null) {
            for (IVisMenuConfigModelListener iVisMenuConfigModelListener : this.listeners) {
                iVisMenuConfigModelListener.allItemsRemoved();
            }
        }
    }

    private static interface IVisMenuConfigModelListener {
        public void itemAdded(VisMenuActionConfigItem var1);

        public void itemRemoved(VisMenuActionConfigItem var1);

        public void itemChanged(VisMenuActionConfigItem var1);

        public void allItemsRemoved();
    }

    private class ItemsListModelAdapter
    extends AbstractListModel<VisMenuActionConfigItem>
    implements IActionConfigListModel<VisMenuActionConfigItem> {
        private List<VisMenuActionConfigItem> items;

        public ItemsListModelAdapter(List<VisMenuActionConfigItem> list) {
            this.items = list;
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public boolean hasElement(VisMenuActionConfigItem visMenuActionConfigItem) {
            return this.items.contains(visMenuActionConfigItem);
        }

        @Override
        public boolean hasAction(PAction pAction) {
            return VisMenuButtonsConfigModel.findItem((Collection<VisMenuActionConfigItem>)this.items, pAction) != null;
        }

        @Override
        public VisMenuActionConfigItem createElement(PAction pAction) {
            return VisMenuActionConfigItem.create(new VisMenuAction(pAction.getID(), -1), pAction);
        }

        @Override
        public VisMenuActionConfigItem getElement(PAction pAction) {
            return VisMenuButtonsConfigModel.findItem((Collection<VisMenuActionConfigItem>)this.items, pAction);
        }

        @Override
        public VisMenuActionConfigItem getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public void setElements(Collection<VisMenuActionConfigItem> collection) {
            this.removeAllElements();
            if (collection != null && collection.size() > 0) {
                for (VisMenuActionConfigItem visMenuActionConfigItem : collection) {
                    VisMenuButtonsConfigModel.this.addItem(visMenuActionConfigItem);
                }
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        @Override
        public void insertElementAt(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
            if (VisMenuButtonsConfigModel.this.insertItemAt(visMenuActionConfigItem, n)) {
                this.fireIntervalAdded(this, n, n);
            }
        }

        @Override
        public void removeElement(VisMenuActionConfigItem visMenuActionConfigItem) {
            int n = this.items.indexOf(visMenuActionConfigItem);
            if (VisMenuButtonsConfigModel.this.removeItem(visMenuActionConfigItem)) {
                this.fireIntervalRemoved(this, n, n);
            }
        }

        @Override
        public void removeAllElements() {
            int n = this.getSize();
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.items) {
                visMenuActionConfigItem.getVisMenuAction().removeActionListener(VisMenuButtonsConfigModel.this.actionListener);
            }
            this.items.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }

        @Override
        public void moveElement(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
            int n2 = this.items.indexOf(visMenuActionConfigItem);
            this.removeElement(visMenuActionConfigItem);
            this.insertElementAt(visMenuActionConfigItem, n2 < n ? n - 1 : n);
        }

        protected void notifyModelChange() {
            this.fireContentsChanged(this, 0, VisMenuButtonsConfigModel.this.getItemCount());
        }
    }

    private class VisMenuActionHandler
    implements VisMenuAction.VisMenuActionListener {
        private VisMenuActionHandler() {
        }

        @Override
        public void actionChanged(VisMenuAction visMenuAction) {
            VisMenuActionConfigItem visMenuActionConfigItem = VisMenuButtonsConfigModel.findItem((Collection<VisMenuActionConfigItem>)VisMenuButtonsConfigModel.this.items, visMenuAction);
            if (visMenuActionConfigItem != null) {
                VisMenuButtonsConfigModel.this.items.remove(visMenuActionConfigItem);
                VisMenuButtonsConfigModel.this.items.add(visMenuActionConfigItem);
            }
            if (visMenuActionConfigItem != null) {
                VisMenuButtonsConfigModel.this.modified = true;
                VisMenuButtonsConfigModel.this.fireItemChanged(visMenuActionConfigItem);
            }
        }
    }
}

