/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.vismenu;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.ui.config.IActionConfigItem;
import com.agfa.pacs.impaxee.vismenu.VisMenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuAction;
import com.agfa.pacs.impaxee.vismenu.VisMenuSubmenuConcreteAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class VisMenuActionConfigItem
implements IActionConfigItem {
    private VisMenuAction menuAction;
    private PAction action;
    private List<VisMenuActionConfigItem> subItems;

    private VisMenuActionConfigItem(VisMenuAction visMenuAction, PAction pAction) {
        Map<VisMenuAction, PAction> map;
        this.menuAction = visMenuAction;
        this.action = pAction;
        if (visMenuAction instanceof VisMenuSubmenuAction && (map = ((VisMenuSubmenuAction)visMenuAction).getSubActionMap(null)) != null && !map.isEmpty()) {
            this.subItems = new ArrayList<VisMenuActionConfigItem>(map.size());
            for (Map.Entry<VisMenuAction, PAction> entry : map.entrySet()) {
                this.subItems.add(new VisMenuActionConfigItem(entry.getKey(), entry.getValue()));
            }
            Collections.sort(this.subItems, new Comparator<VisMenuActionConfigItem>(){
                private VisMenuAction.VisMenuActionComparator c = new VisMenuAction.VisMenuActionComparator();

                @Override
                public int compare(VisMenuActionConfigItem visMenuActionConfigItem, VisMenuActionConfigItem visMenuActionConfigItem2) {
                    return this.c.compare(visMenuActionConfigItem.getVisMenuAction(), visMenuActionConfigItem2.getVisMenuAction());
                }
            });
        }
    }

    public static VisMenuActionConfigItem create(VisMenuAction visMenuAction, PAction pAction) {
        return new VisMenuActionConfigItem(visMenuAction, pAction);
    }

    public static VisMenuActionConfigItem create(PAction pAction) {
        VisMenuAction visMenuAction = null;
        visMenuAction = pAction instanceof VisMenuSubmenuConcreteAction ? new VisMenuSubmenuAction(-1, (VisMenuSubmenuConcreteAction)pAction) : new VisMenuAction(pAction.getID(), -1);
        return new VisMenuActionConfigItem(visMenuAction, pAction);
    }

    public VisMenuAction getVisMenuAction() {
        return this.menuAction;
    }

    public List<VisMenuActionConfigItem> getSubItems() {
        if (this.subItems != null) {
            return Collections.unmodifiableList(this.subItems);
        }
        return Collections.emptyList();
    }

    public int getLeafItemCount() {
        int n = 0;
        if (this.subItems == null || this.subItems.isEmpty()) {
            if (!(this.menuAction instanceof VisMenuSubmenuAction)) {
                n = 1;
            }
        } else {
            for (VisMenuActionConfigItem visMenuActionConfigItem : this.subItems) {
                n += visMenuActionConfigItem.getLeafItemCount();
            }
        }
        return n;
    }

    public boolean insertSubItemAt(VisMenuActionConfigItem visMenuActionConfigItem, int n) {
        if (this.menuAction instanceof VisMenuSubmenuAction && ((VisMenuSubmenuAction)this.menuAction).insertActionAt(visMenuActionConfigItem.getVisMenuAction(), n)) {
            if (this.subItems == null) {
                this.subItems = new ArrayList<VisMenuActionConfigItem>();
            }
            this.subItems.add(n < 0 ? this.subItems.size() : n, visMenuActionConfigItem);
            return true;
        }
        return false;
    }

    public boolean removeSubItem(VisMenuActionConfigItem visMenuActionConfigItem) {
        if (this.menuAction instanceof VisMenuSubmenuAction && ((VisMenuSubmenuAction)this.menuAction).removeAction(visMenuActionConfigItem.getVisMenuAction())) {
            return this.subItems != null && this.subItems.remove(visMenuActionConfigItem);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof VisMenuActionConfigItem && !"SEPARATOR".equals(this.action.getID())) {
            return this.menuAction.equals(((VisMenuActionConfigItem)object).getVisMenuAction());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.menuAction.hashCode();
    }

    @Override
    public PAction getAction() {
        return this.action;
    }
}

