/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.utils;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.utils.ImageTransferHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;

public class TSVCreator {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private final Clipboard clipboard = Product.isHeadless() ? null : Toolkit.getDefaultToolkit().getSystemClipboard();
    private StringBuilder data;
    private JComponent component;
    private ImageTransferHandler handler = new ImageTransferHandler();

    public TSVCreator() {
    }

    public TSVCreator(JComponent jComponent) {
        this.component = jComponent;
        this.data = new StringBuilder();
    }

    public TSVCreator(List<?> list, List<List<String>> list2, JComponent jComponent) {
        this.component = jComponent;
        this.data = new StringBuilder();
        this.addData(list);
        this.addRows(list2);
    }

    public void copyToClipboard() {
        if (this.data.length() > 0) {
            this.handler.setText(this.data.toString());
        }
        this.handler.exportToClipboard(this.component, this.clipboard, 1);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.handler.setImage(bufferedImage);
    }

    private void addData(List<?> list) {
        int n = 0;
        while (n < list.size()) {
            this.data.append(list.get(n).toString());
            if (n == list.size() - 1) {
                this.data.append(NEWLINE);
                return;
            }
            this.data.append(TAB);
            ++n;
        }
    }

    public void addRow(List<?> list) {
        this.addData(list);
    }

    public void addRows(List<List<String>> list) {
        for (List<String> list2 : list) {
            this.addData(list2);
        }
    }
}

