/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.utils;

import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.tiani.jvision.main.JVision2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RequestQueueWatcher
extends JDialog {
    private JTextArea ta;
    Map<Byte, String> priorityMeanings;
    private Thread updater;
    private JTextField intervalTextField;

    public RequestQueueWatcher() {
        super(JVision2.getMainFrame(), "RequestQueueWatcher", false);
        this.setAlwaysOnTop(true);
        this.setSize(800, 600);
        this.buildUI();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RequestQueueWatcher.this.updater.interrupt();
                RequestQueueWatcher.this.updater = null;
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.toFront();
        this.priorityMeanings = new HashMap<Byte, String>();
        this.priorityMeanings.put((byte)7, "Background");
        this.priorityMeanings.put((byte)6, "NextPatient");
        this.priorityMeanings.put((byte)5, "CurrentPatient");
        this.priorityMeanings.put((byte)4, "InDisplay");
        this.priorityMeanings.put((byte)2, "ActualSerieInDisplay");
        this.priorityMeanings.put((byte)1, "ActualSerieInDisplayFirstImages");
        this.priorityMeanings.put((byte)3, "InDisplayFirstImages");
        this.priorityMeanings.put((byte)0, "Visible");
        this.updater = new Thread((Runnable)new GUIUpdater(), "RequestQueueWatcherThread");
        this.updater.start();
    }

    private void buildUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.ta = new JTextArea();
        this.getContentPane().add((Component)this.ta, "Center");
        this.ta.setFont(new Font("Monospaced", 0, 12));
        this.ta.setText("TestText");
        JPanel jPanel = new JPanel();
        this.intervalTextField = new JTextField("1000", 5);
        jPanel.add(this.intervalTextField);
        jPanel.add(new JLabel(" ms update interval"));
        this.getContentPane().add((Component)jPanel, "South");
    }

    private void updateUI() {
        if (this.ta != null) {
            long l = System.currentTimeMillis();
            int[] nArray = DicomDataRequester.getInstance().getRequestQueueState();
            l = System.currentTimeMillis() - l;
            int n = 0;
            DecimalFormat decimalFormat = new DecimalFormat("00");
            DecimalFormat decimalFormat2 = new DecimalFormat("00000");
            this.ta.setText("");
            byte by = 0;
            while (by < nArray.length) {
                String string = String.format("%1$#40s", this.priorityMeanings.get(by));
                this.ta.append(string);
                this.ta.append(" " + decimalFormat.format(by) + ": " + decimalFormat2.format(nArray[by]) + "  ");
                int n2 = 0;
                while (n2 < nArray[by]) {
                    this.ta.append("=");
                    n2 += 50;
                }
                this.ta.append("\n");
                n += nArray[by];
                by = (byte)(by + 1);
            }
            this.ta.append(String.valueOf(String.format("%1$#44s", "TOTAL:")) + " " + decimalFormat2.format(n));
            this.ta.append("\n" + new Date());
            this.ta.append("\nCounting RequestQueue took " + l + " ms.");
        }
    }

    class GUIUpdater
    implements Runnable {
        GUIUpdater() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int n = 1000;
                    try {
                        n = Math.max(Integer.parseInt(RequestQueueWatcher.this.intervalTextField.getText()), 5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 1000;
                    }
                    Thread.sleep(n);
                    RequestQueueWatcher.this.updateUI();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

