/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toptoolbar;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.toolbar.Toolbar;
import com.agfa.pacs.impaxee.toolbar.ToolbarContainer;
import com.agfa.pacs.impaxee.toolbar.ToolbarModel;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarPaneModel;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.util.panel.flexible.FlexibleMouseKnockPanel;
import com.tiani.gui.util.panel.flexible.behaviourcontrol.PopupMenuBehaviourControl;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorMenuItem;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;

public class TopToolbarPane
extends FlexibleMouseKnockPanel {
    private static final ALogger log = ALogger.getLogger(TopToolbarPane.class);
    private List<ToolbarContainer> toolbarContainers;
    private TopToolbarPaneModel model = TopToolbarPaneModel.getRuntimeInstance();
    private boolean editing = false;

    public TopToolbarPane(JComponent jComponent) {
        super(jComponent, "North", jComponent, false, true, TopToolbarPane.getInitialBehaviour());
        this.model.addModelListener(new ModelHandler());
        this.setBorder(BorderFactory.createEmptyBorder(GUI.getScaledDiagnosticInt((int)2), GUI.getScaledDiagnosticInt((int)2), GUI.getScaledDiagnosticInt((int)5), GUI.getScaledDiagnosticInt((int)2)));
        this.init();
    }

    public TopToolbarPaneModel getModel() {
        return this.model;
    }

    public Collection<Toolbar> getToolbars() {
        return this.toolbarContainers.get(0).getToolbars();
    }

    @Override
    protected ChangeListener newPopupMenuBehaviourControl(int n) {
        return new PopupMenuBehaviourControl(this, n){

            @Override
            public JPopupMenu createPopup() {
                MultiMonitorMenuItem multiMonitorMenuItem;
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenu jMenu = ComponentFactory.instance.createMenu(Messages.getString("TopToolbar.DockingStatus.Text"));
                int n = 0;
                while (n < this.orderedActions.length) {
                    if (this.orderedActions[n] != null) {
                        multiMonitorMenuItem = ComponentFactory.instance.createMultiMonitorMenuItem(this.orderedActions[n]);
                        jMenu.add(multiMonitorMenuItem);
                    }
                    ++n;
                }
                jPopupMenu.add(jMenu);
                if (ActionUIUtilities.ActionPermission.ConfigureTools.checkForCurrentUser()) {
                    MultiMonitorMenuItem multiMonitorMenuItem2 = ComponentFactory.instance.createMultiMonitorMenuItem(new ConfigureAction());
                    multiMonitorMenuItem = ComponentFactory.instance.createMultiMonitorMenuItem(null);
                    EditModeAction editModeAction = new EditModeAction(multiMonitorMenuItem, Arrays.asList(jMenu, multiMonitorMenuItem2));
                    multiMonitorMenuItem.setAction(editModeAction);
                    jPopupMenu.add(multiMonitorMenuItem);
                    jPopupMenu.add(multiMonitorMenuItem2);
                }
                return jPopupMenu;
            }
        };
    }

    private static int getInitialBehaviour() {
        int n = (int)Config.impaxee.jvision.STARTUP.TopToolbarMode.get();
        return n == 1 ? 1 : 2;
    }

    private void init() {
        if (this.toolbarContainers == null) {
            this.toolbarContainers = new ArrayList<ToolbarContainer>();
        } else {
            for (ToolbarContainer object2 : this.toolbarContainers) {
                for (Toolbar toolbar : object2.getToolbars()) {
                    toolbar.removeAll();
                }
                object2.removeAll();
            }
            this.toolbarContainers.clear();
            this.removeAll();
        }
        Collection<ToolbarModel> collection = this.model.getToolbars();
        if (this.model.isMultiScreenEnabled()) {
            this.initMultiScreen(collection);
        } else {
            this.initSingleScreen(collection);
        }
    }

    private void initMultiScreen(Collection<ToolbarModel> collection) {
        int n = LayoutConfig.getInstance().getScreenColumns();
        int n2 = 0;
        while (n2 < n) {
            Iterator<ToolbarModel> iterator = new ToolbarContainer();
            this.toolbarContainers.add((ToolbarContainer)((Object)iterator));
            ++n2;
        }
        this.setLayout(new GridLayout(1, this.toolbarContainers.size()));
        for (ToolbarContainer toolbarContainer : this.toolbarContainers) {
            this.add(toolbarContainer);
        }
        for (ToolbarModel toolbarModel : collection) {
            this.addToolbar(toolbarModel);
        }
    }

    private void initSingleScreen(Collection<ToolbarModel> collection) {
        ToolbarContainer toolbarContainer = new ToolbarContainer();
        this.toolbarContainers.add(toolbarContainer);
        this.setLayout(new GridLayout(1, 1));
        this.add(toolbarContainer);
        for (ToolbarModel toolbarModel : collection) {
            this.addToolbar(toolbarModel);
        }
    }

    private void addToolbar(ToolbarModel toolbarModel) {
        int n = 0;
        while (n < this.toolbarContainers.size()) {
            ToolbarContainer toolbarContainer = this.toolbarContainers.get(n);
            Toolbar toolbar = this.getToolbarForName(toolbarContainer, toolbarModel.getName());
            if (toolbar == null) {
                toolbar = new Toolbar(n, toolbarModel);
                toolbarContainer.add(toolbar);
                toolbarContainer.revalidate();
                toolbarContainer.repaint();
            }
            ++n;
        }
    }

    private void removeToolbar(ToolbarModel toolbarModel) {
        for (ToolbarContainer toolbarContainer : this.toolbarContainers) {
            Toolbar toolbar = this.getToolbarForName(toolbarContainer, toolbarModel.getName());
            if (toolbar == null) continue;
            toolbarContainer.remove(toolbar);
            toolbarContainer.revalidate();
            toolbarContainer.repaint();
        }
    }

    private Toolbar getToolbarForName(ToolbarContainer toolbarContainer, String string) {
        if (toolbarContainer.getComponentCount() > 0) {
            Component[] componentArray = toolbarContainer.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof Toolbar && string.equals(((Toolbar)component).getName())) {
                    return (Toolbar)component;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isEditing() {
        return this.editing;
    }

    private void setEditing(boolean bl) {
        if (this.editing != bl) {
            this.editing = bl;
            for (ToolbarContainer toolbarContainer : this.toolbarContainers) {
                toolbarContainer.setEditing(this.editing);
            }
            if (!bl) {
                try {
                    this.model.save(true);
                }
                catch (Exception exception) {
                    log.error("Saving toolbars failed!", (Throwable)exception);
                }
            }
        }
    }

    private static class ConfigureAction
    extends AbstractAction {
        public ConfigureAction() {
            super(Messages.getString("TopToolbar.ConfigureTools.Text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionUIUtilities.showActionConfigDialog(ActionUIScope.TopToolbar);
        }
    }

    private class EditModeAction
    extends AbstractAction {
        private JMenuItem menuItem;
        private Collection<JMenuItem> mutualExclusive;

        public EditModeAction(JMenuItem jMenuItem, Collection<JMenuItem> collection) {
            this.menuItem = jMenuItem;
            this.mutualExclusive = collection;
        }

        @Override
        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return TopToolbarPane.this.isEditing() ? Messages.getString("TopToolbar.FreezeTools.Text") : Messages.getString("TopToolbar.AdjustTools.Text");
            }
            return super.getValue(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopToolbarPane.this.setEditing(!TopToolbarPane.this.isEditing());
            this.menuItem.setText(this.getValue("Name").toString());
            if (this.mutualExclusive != null) {
                for (JMenuItem jMenuItem : this.mutualExclusive) {
                    jMenuItem.setEnabled(!TopToolbarPane.this.isEditing());
                }
            }
        }
    }

    private class ModelHandler
    implements TopToolbarPaneModel.ModelListener {
        private ModelHandler() {
        }

        @Override
        public void modelChanged() {
            TopToolbarPane.this.init();
        }

        @Override
        public void toolbarAdded(ToolbarModel toolbarModel) {
            TopToolbarPane.this.addToolbar(toolbarModel);
        }

        @Override
        public void toolbarRemoved(ToolbarModel toolbarModel) {
            TopToolbarPane.this.removeToolbar(toolbarModel);
        }

        @Override
        public void toolbarChanged(ToolbarModel toolbarModel) {
        }
    }
}

