/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.toolbar;

import com.agfa.pacs.impaxee.toolbar.ToolbarLayoutConstraint;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSeparator;

public class ToolbarLayout
implements LayoutManager2 {
    private static final int DEFAULT_HORZ_GAP = 2;
    private Map<Component, ToolbarLayoutConstraint> constraints = new HashMap<Component, ToolbarLayoutConstraint>();
    private int horzGap;
    private boolean resizeable;

    public ToolbarLayout() {
        this(false, 2);
    }

    public ToolbarLayout(boolean bl) {
        this(bl, 2);
    }

    public ToolbarLayout(boolean bl, int n) {
        this.resizeable = bl;
        this.horzGap = n;
    }

    public int getHorizontalGap() {
        return this.horzGap;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            this.constraints.put(component, new ToolbarLayoutConstraint());
        } else if (object instanceof ToolbarLayoutConstraint) {
            this.constraints.put(component, (ToolbarLayoutConstraint)object);
        } else {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a ToolbarLayoutConstraint");
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component != null) {
            this.constraints.remove(component);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = container.getInsets().left + container.getInsets().right;
        int n2 = container.getInsets().top + container.getInsets().bottom;
        if (container.getComponentCount() > 0) {
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < container.getComponentCount()) {
                Component component = container.getComponent(n6);
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    n4 += this.getPreferredWidth(container, component);
                    if (dimension.height > n3) {
                        n3 = dimension.height;
                    }
                    ++n5;
                }
                ++n6;
            }
            n += (n5 - 1) * this.horzGap;
            n += n4;
            n2 += n3;
        }
        return new Dimension(n, n2);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        if (this.isResizeable()) {
            int n = container.getInsets().left + container.getInsets().right;
            if (container.getComponentCount() > 0) {
                int n2 = 0;
                Component[] componentArray = container.getComponents();
                int n3 = componentArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Component component = componentArray[n4];
                    if (component.isVisible() && !this.isConcealable(component)) {
                        n += this.getPreferredWidth(container, component);
                        ++n2;
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    n += this.getPreferredWidth(container, container.getComponent(0));
                    n2 = 1;
                }
                n += n2 > 0 ? (n2 - 1) * this.horzGap : 0;
            }
            return new Dimension(n, dimension.height);
        }
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        block21: {
            int n = container.getComponentCount();
            if (n <= 0) break block21;
            Insets insets = container.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = container.getHeight() - insets.bottom - insets.top;
            if (!this.resizeable) {
                int n5 = 0;
                while (n5 < n) {
                    Component component = container.getComponent(n5);
                    if (component.isVisible()) {
                        int n6 = this.getPreferredWidth(container, component);
                        if (component instanceof JSeparator) {
                            Insets insets2 = ((JSeparator)component).getInsets();
                            component.setBounds(n2, n3 + insets2.top, n6, n4 - insets2.top - insets2.bottom);
                        } else {
                            component.setBounds(n2, n3, n6, n4);
                        }
                        n2 += n6 + this.horzGap;
                    }
                    ++n5;
                }
            } else {
                int n7 = container.getWidth() - insets.right;
                int n8 = 0;
                while (n8 < n) {
                    Component component = container.getComponent(n8);
                    if (component.isVisible()) {
                        int n9 = this.getPreferredWidth(container, component);
                        if (!this.isConcealable(component)) {
                            if (component instanceof JSeparator) {
                                Insets insets3 = ((JSeparator)component).getInsets();
                                component.setBounds(n2, n3 + insets3.top, n9, n4 - insets3.top - insets3.bottom);
                            } else {
                                component.setBounds(n2, n3, n9, n4);
                            }
                            n2 += n9 + this.horzGap;
                        } else {
                            Serializable serializable;
                            int n10 = this.getAssignedFollowUpWidth(container, n8 + 1);
                            if (n2 + n9 + n10 <= n7) {
                                if (n8 == n - 1 && component instanceof JSeparator) {
                                    component.setBounds(0, 0, 0, 0);
                                } else {
                                    if (component instanceof JSeparator) {
                                        serializable = ((JSeparator)component).getInsets();
                                        component.setBounds(n2, n3 + ((Insets)serializable).top, n9, n4 - ((Insets)serializable).top - ((Insets)serializable).bottom);
                                    } else {
                                        component.setBounds(n2, n3, n9, n4);
                                    }
                                    n2 += n9 + this.horzGap;
                                }
                            } else {
                                component.setBounds(0, 0, 0, 0);
                                if (n8 > 0 && (serializable = container.getComponent(n8 - 1)) instanceof JSeparator) {
                                    if (((Component)serializable).getLocation().x > 0 || ((Component)serializable).getLocation().y > 0) {
                                        ((Component)serializable).setLocation(0, 0);
                                    }
                                    if (((Component)serializable).getWidth() > 0 || ((Component)serializable).getHeight() > 0) {
                                        ((Component)serializable).setSize(0, 0);
                                    }
                                }
                            }
                        }
                    }
                    ++n8;
                }
            }
        }
    }

    public int getPreferredWidth(Container container, Component component) {
        double d = -1.0;
        ToolbarLayoutConstraint toolbarLayoutConstraint = this.getConstraint(component);
        if (toolbarLayoutConstraint != null) {
            d = toolbarLayoutConstraint.getPreferredWidth();
        }
        if (d < 0.0) {
            return component.getPreferredSize().width;
        }
        if (d >= 0.0 && d < 1.0) {
            return (int)(d * (double)this.getUnassignedAvailablePreferredWidth(container) + 0.5);
        }
        return (int)(d + 0.5);
    }

    public boolean isConcealable(Component component) {
        ToolbarLayoutConstraint toolbarLayoutConstraint = this.getConstraint(component);
        return toolbarLayoutConstraint != null ? toolbarLayoutConstraint.isConcealable() : true;
    }

    private ToolbarLayoutConstraint getConstraint(Component component) {
        return this.constraints.get(component);
    }

    private int getUnassignedAvailablePreferredWidth(Container container) {
        int n = 0;
        if (container.getComponentCount() > 0) {
            Component[] componentArray = container.getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Component component = componentArray[n3];
                if (component.isVisible()) {
                    double d = -1.0;
                    ToolbarLayoutConstraint toolbarLayoutConstraint = this.getConstraint(component);
                    if (toolbarLayoutConstraint != null) {
                        d = toolbarLayoutConstraint.getPreferredWidth();
                    }
                    if (d < 0.0) {
                        n += component.getPreferredSize().width;
                    } else if (d >= 1.0) {
                        n += (int)(d + 0.5);
                    }
                }
                ++n3;
            }
            n += (container.getComponentCount() - 1) * this.horzGap;
        }
        return Math.max(0, container.getWidth() - container.getInsets().left - container.getInsets().right - n);
    }

    private int getAssignedFollowUpWidth(Container container, int n) {
        int n2 = 0;
        if (container.getComponentCount() > n) {
            int n3 = 0;
            int n4 = n;
            while (n4 < container.getComponentCount()) {
                Component component = container.getComponent(n4);
                if (component.isVisible() && !this.isConcealable(component)) {
                    n2 += this.getPreferredWidth(container, component);
                    ++n3;
                }
                ++n4;
            }
            n2 += n3 > 0 ? (n3 - 1) * this.horzGap : 0;
        }
        return n2;
    }
}

