/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tagdictionary;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.hw.manager.InputStreamDicomDataReader;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Pair;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class PrivateTagMapper {
    private static ALogger LOGGER = ALogger.getLogger(PrivateTagMapper.class);
    private static final PrivateTagMapper INSTANCE = new PrivateTagMapper();
    private final Map<Integer, Map<String, Integer>> map = new HashMap<Integer, Map<String, Integer>>();

    private PrivateTagMapper() {
        this.initFromConfig();
    }

    public static PrivateTagMapper getInstance() {
        return INSTANCE;
    }

    private void initFromConfig() {
        IConfigurationList iConfigurationList = Config.impaxee.jvision.PrivateTags.Mappings.getList();
        ArrayList<String> arrayList = new ArrayList<String>(2);
        for (Map.Entry object : iConfigurationList.getChildrenItems().entrySet()) {
            try {
                this.initFromConfigEntry((IConfigurationProvider)object.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = (String)object.getKey();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Incomplete private tag mapping for order ID '");
                stringBuilder.append(string);
                stringBuilder.append("', deleting ...");
                LOGGER.warn(stringBuilder.toString(), (Throwable)illegalArgumentException);
                arrayList.add(string);
            }
        }
        for (String string : arrayList) {
            iConfigurationList.remove(string);
        }
    }

    private void initFromConfigEntry(IConfigurationProvider iConfigurationProvider) {
        String string = iConfigurationProvider.getString("manufacturer");
        int n = (int)iConfigurationProvider.getLong("privateTag");
        Integer n2 = (int)iConfigurationProvider.getLong("matchedTag");
        InputStreamDicomDataReader.addRequiredPrivateTag((int)n);
        Map<String, Integer> map = this.map.get(n2);
        if (map == null) {
            map = new HashMap<String, Integer>(2);
            this.map.put(n2, map);
        }
        map.put(string.toUpperCase(), n);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Private tag mapping for ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(TagUtils.toString((int)n));
            stringBuilder.append(" => ");
            stringBuilder.append(TagUtils.toString((int)n2));
            LOGGER.debug(stringBuilder.toString());
        }
    }

    public String getString(Attributes attributes, int n) {
        return this.getString(attributes, n, "*");
    }

    public String getString(Attributes attributes, int n, String string) {
        if (attributes.containsValue(n)) {
            return attributes.getString(n);
        }
        return this.getMatchingPrivateString(attributes, n, string);
    }

    public String[] getStrings(Attributes attributes, int n) {
        return this.getStrings(attributes, n, "*");
    }

    public String[] getStrings(Attributes attributes, int n, String string) {
        if (attributes.containsValue(n)) {
            return attributes.getStrings(n);
        }
        String string2 = this.getMatchingPrivateString(attributes, n, string);
        if (string2 == null) {
            return null;
        }
        return new String[]{string2};
    }

    public Double getDouble(Attributes attributes, int n) {
        if (attributes.containsValue(n)) {
            return attributes.getDouble(n, Double.NaN);
        }
        String string = this.getMatchingPrivateString(attributes, n, null);
        if (string != null) {
            try {
                return Double.valueOf(string);
            }
            catch (Exception exception) {
                LOGGER.warn("Parsing double value from private tag failed:" + n);
            }
        }
        return null;
    }

    public Pair<String, Integer> getOriginatingTag(Attributes attributes, int n) {
        if (attributes.containsValue(n)) {
            return null;
        }
        return this.getMatchingPrivateTag(attributes, n);
    }

    private String getMatchingPrivateString(Attributes attributes, int n, String string) {
        String string2;
        Pair<String, Integer> pair = this.getMatchingPrivateTag(attributes, n);
        if (pair == null) {
            return null;
        }
        int n2 = (Integer)pair.right;
        try {
            string2 = attributes.getVR(n2) == VR.UN ? new String(attributes.getBytes(n2)) : attributes.getString(n2);
        }
        catch (Exception exception) {
            LOGGER.warn("Parsing private tag failed:" + n2);
            string2 = null;
        }
        if (string2 != null && string != null) {
            string2 = String.valueOf(string2) + string;
        }
        return string2;
    }

    private Pair<String, Integer> getMatchingPrivateTag(Attributes attributes, int n) {
        Integer n2;
        String string;
        Map<String, Integer> map = this.map.get(n);
        if (map != null && (string = attributes.getString(524400)) != null && (n2 = map.get(string.toUpperCase())) != null) {
            return Pair.of((Object)string, (Object)n2);
        }
        return null;
    }
}

