/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.runtime;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.splitsort.CrossStudyDisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.DisplaySetComparator;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSetItem;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DisplaySetContainer {
    private IDisplaySetFilter filter;
    private List<IDisplaySet> displaySets;
    private Set<String> studies = new HashSet<String>();
    private final boolean trackable;
    private List<IDisplaySetContainerListener> listeners;
    private ISplitAndSortRuntime sasRuntime;

    private DisplaySetContainer(ISplitAndSortRuntime iSplitAndSortRuntime, IDisplaySetFilter iDisplaySetFilter, boolean bl) {
        this.trackable = bl;
        this.filter = iDisplaySetFilter;
        this.sasRuntime = iSplitAndSortRuntime;
    }

    public ChangeSet createNewChangeSet() {
        if (this.trackable) {
            return new ChangeSet(this.sasRuntime);
        }
        return null;
    }

    static DisplaySetContainer createRuntimeInstance(ISplitAndSortRuntime iSplitAndSortRuntime) {
        return new DisplaySetContainer(iSplitAndSortRuntime, new RuntimeDisplaySetFilter(), true);
    }

    static DisplaySetContainer createDefaultInstance(ISplitAndSortRuntime iSplitAndSortRuntime) {
        return new DisplaySetContainer(iSplitAndSortRuntime, new DefaultDisplaySetFilter(), false);
    }

    static DisplaySetContainer createKeyImageInstance(ISplitAndSortRuntime iSplitAndSortRuntime) {
        return new DisplaySetContainer(iSplitAndSortRuntime, new KeyImageDisplaySetFilter(), false);
    }

    public IDisplaySetFilter getFilter() {
        return this.filter;
    }

    public List<String> getStudyOrdering() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (IDisplaySet iDisplaySet : this.displaySets) {
            if (string.equals(iDisplaySet.getStudyUID())) continue;
            string = iDisplaySet.getStudyUID();
            arrayList.add(string);
        }
        return arrayList;
    }

    void addDisplaySets(List<IDisplaySet> list, ChangeSet changeSet) {
        this.addDisplaySets(list, null, changeSet);
    }

    void addDisplaySets(List<IDisplaySet> list, Map<String, DisplaySetComparator> map, ChangeSet changeSet) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(list.size());
        for (IDisplaySet iDisplaySet : list) {
            if (iDisplaySet == null) continue;
            IDisplaySet iDisplaySet2 = this.getDisplaySetForId(iDisplaySet.getID());
            if (iDisplaySet2 == null) {
                iDisplaySet2 = this.getRelatedDisplaySet(iDisplaySet);
            }
            if (iDisplaySet2 != null) {
                if (iDisplaySet2.getFrameCount() == iDisplaySet.getFrameCount() && iDisplaySet2.getOneObject() == iDisplaySet.getOneObject() && Arrays.equals(iDisplaySet2.getObjects(), iDisplaySet.getObjects())) continue;
                this.replaceDisplaySet(iDisplaySet2, iDisplaySet, changeSet);
                continue;
            }
            arrayList.add(iDisplaySet);
            if (changeSet == null || !this.trackable) continue;
            changeSet.addItem(SplitAndSortChangeSetItem.createAddInstance(iDisplaySet));
        }
        if (this.displaySets == null) {
            this.displaySets = new ArrayList<IDisplaySet>(32);
        }
        this.displaySets.addAll(arrayList);
        for (IDisplaySet iDisplaySet : arrayList) {
            this.studies.add(iDisplaySet.getStudyUID());
        }
        Collections.sort(this.displaySets, new CrossStudyDisplaySetComparator(map));
        this.fireDisplaySetsAdded(arrayList);
    }

    boolean replaceDisplaySet(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2, ChangeSet changeSet) {
        int n;
        if (iDisplaySet != null && iDisplaySet2 != null && iDisplaySet != iDisplaySet2 && (n = this.displaySets.indexOf(iDisplaySet)) >= 0) {
            this.displaySets.remove(n);
            this.fireDisplaySetRemoved(iDisplaySet);
            this.displaySets.add(n, iDisplaySet2);
            this.fireDisplaySetsAdded(Collections.singletonList(iDisplaySet2));
            if (changeSet != null && this.trackable) {
                changeSet.addItem(SplitAndSortChangeSetItem.createChangeInstance(iDisplaySet, iDisplaySet2));
            }
            return true;
        }
        return false;
    }

    boolean removeDisplaySet(IDisplaySet iDisplaySet, ChangeSet changeSet) {
        if (this.displaySets != null && this.displaySets.remove(iDisplaySet)) {
            if (changeSet != null && this.trackable) {
                changeSet.addItem(SplitAndSortChangeSetItem.createRemoveInstance(iDisplaySet));
            }
            this.fireDisplaySetRemoved(iDisplaySet);
            HashSet<String> hashSet = new HashSet<String>();
            for (IDisplaySet iDisplaySet2 : this.displaySets) {
                hashSet.add(iDisplaySet2.getStudyUID());
            }
            this.studies = hashSet;
            return true;
        }
        return false;
    }

    boolean containsDisplaySet(IDisplaySet iDisplaySet) {
        return this.displaySets != null ? this.displaySets.contains(iDisplaySet) : false;
    }

    boolean containsDisplaySetOfStudy(IStudyData iStudyData) {
        return this.studies.contains(iStudyData.getStudyInstanceUID());
    }

    List<IDisplaySet> getDisplaySetsOfStudy(IStudyData iStudyData) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        if (this.displaySets != null) {
            for (IDisplaySet iDisplaySet : this.displaySets) {
                if (!iStudyData.getKey().equals(iDisplaySet.getStudyUID())) continue;
                arrayList.add(iDisplaySet);
            }
        }
        return arrayList;
    }

    IDisplaySet getFirstDisplaySetOfStudy(IStudyData iStudyData) {
        String string = iStudyData.getStudyInstanceUID();
        if (!this.studies.contains(string)) {
            return null;
        }
        for (IDisplaySet iDisplaySet : this.displaySets) {
            if (!iDisplaySet.getStudyUID().equals(string)) continue;
            return iDisplaySet;
        }
        return null;
    }

    public List<IDisplaySet> getDisplaySets() {
        if (this.displaySets != null) {
            return Collections.unmodifiableList(this.displaySets);
        }
        return Collections.emptyList();
    }

    IDisplaySet getDisplaySetAt(int n) {
        return this.displaySets != null ? this.displaySets.get(n) : null;
    }

    int getIndexOfDisplaySet(IDisplaySet iDisplaySet) {
        return this.displaySets != null ? this.displaySets.indexOf(iDisplaySet) : -1;
    }

    public int getNumberOfDisplaySets() {
        return this.displaySets != null ? this.displaySets.size() : 0;
    }

    IDisplaySet getDisplaySetForId(int n) {
        if (this.displaySets != null) {
            for (IDisplaySet iDisplaySet : this.displaySets) {
                if (n != iDisplaySet.getID()) continue;
                return iDisplaySet;
            }
        }
        return null;
    }

    IDisplaySet getRelatedDisplaySet(IDisplaySet iDisplaySet) {
        if (this.displaySets != null) {
            for (IDisplaySet iDisplaySet2 : this.displaySets) {
                if (!DisplaySetContainer.relatesEachOther(iDisplaySet, iDisplaySet2)) continue;
                return iDisplaySet2;
            }
        }
        return null;
    }

    void addDisplaySetContainerListener(IDisplaySetContainerListener iDisplaySetContainerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IDisplaySetContainerListener>();
        }
        if (!this.listeners.contains(iDisplaySetContainerListener)) {
            this.listeners.add(iDisplaySetContainerListener);
        }
    }

    private void fireDisplaySetsAdded(List<IDisplaySet> list) {
        if (this.listeners != null) {
            for (IDisplaySetContainerListener iDisplaySetContainerListener : this.listeners) {
                iDisplaySetContainerListener.displaySetsAdded(list);
            }
        }
    }

    private void fireDisplaySetRemoved(IDisplaySet iDisplaySet) {
        if (this.listeners != null) {
            for (IDisplaySetContainerListener iDisplaySetContainerListener : this.listeners) {
                iDisplaySetContainerListener.displaySetRemoved(iDisplaySet);
            }
        }
    }

    private static boolean relatesEachOther(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2) {
        if (!CompareUtils.equals((Object)iDisplaySet.getFrameOfReferenceUID(), (Object)iDisplaySet2.getFrameOfReferenceUID())) {
            return false;
        }
        List<IFrameObjectData> list = Arrays.asList(iDisplaySet.getObjects());
        List<IFrameObjectData> list2 = Arrays.asList(iDisplaySet2.getObjects());
        if (list.size() == 1 && list2.contains(list.get(0))) {
            return true;
        }
        if (list.size() > 1 && list2.contains(list.get(0)) && list2.contains(list.get(list.size() - 1))) {
            return true;
        }
        if (list2.size() == 1 && list.contains(list2.get(0))) {
            return true;
        }
        return list2.size() > 1 && list.contains(list2.get(0)) && list.contains(list2.get(list2.size() - 1));
    }

    private static abstract class AbstractDisplaySetFilter
    implements IDisplaySetFilter {
        private AbstractDisplaySetFilter() {
        }

        @Override
        public boolean accept(IDisplaySet iDisplaySet) {
            return this.accept(iDisplaySet.getObjects());
        }
    }

    static class ChangeSet
    extends SplitAndSortChangeSet {
        private ChangeSet(ISplitAndSortRuntime iSplitAndSortRuntime) {
            super(iSplitAndSortRuntime, null);
        }

        private void addItem(SplitAndSortChangeSetItem splitAndSortChangeSetItem) {
            this.addItem(this.items != null ? this.items.size() : 0, splitAndSortChangeSetItem);
        }

        private void addItem(int n, SplitAndSortChangeSetItem splitAndSortChangeSetItem) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(n, splitAndSortChangeSetItem);
        }
    }

    private static class DefaultDisplaySetFilter
    extends AbstractDisplaySetFilter {
        private DefaultDisplaySetFilter() {
        }

        @Override
        public boolean accept(IFrameObjectData[] iFrameObjectDataArray) {
            if (iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0) {
                KeyImageManager keyImageManager = KeyImageManager.getInstance();
                IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
                int n = iFrameObjectDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
                    if (!keyImageManager.isMarked(iFrameObjectData)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    static interface IDisplaySetContainerListener {
        public void displaySetsAdded(List<IDisplaySet> var1);

        public void displaySetRemoved(IDisplaySet var1);
    }

    private static interface IDisplaySetFilter {
        public boolean accept(IFrameObjectData[] var1);

        public boolean accept(IDisplaySet var1);
    }

    private static class KeyImageDisplaySetFilter
    extends AbstractDisplaySetFilter {
        private KeyImageDisplaySetFilter() {
        }

        @Override
        public boolean accept(IFrameObjectData[] iFrameObjectDataArray) {
            if (iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0) {
                KeyImageManager keyImageManager = KeyImageManager.getInstance();
                IFrameObjectData[] iFrameObjectDataArray2 = iFrameObjectDataArray;
                int n = iFrameObjectDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray2[n2];
                    if (!keyImageManager.isMarked(iFrameObjectData)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
    }

    private static class RuntimeDisplaySetFilter
    extends AbstractDisplaySetFilter {
        private RuntimeDisplaySetFilter() {
        }

        @Override
        public boolean accept(IFrameObjectData[] iFrameObjectDataArray) {
            return iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0;
        }
    }
}

