/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort.registry;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.splitsort.model.xml.AbstractConditionalCriterion;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.utils.Checksumm;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import java.util.List;

public class SplitSortRegistry {
    private static final ALogger log = ALogger.getLogger(SplitSortRegistry.class);
    private static SplitSortRegistry instance;
    private SplitAndSort splitAndSort;
    private long checksumm = -1L;

    private SplitSortRegistry() {
        this.loadFromConfig();
    }

    public static SplitSortRegistry getInstance() {
        if (instance == null) {
            instance = new SplitSortRegistry();
        }
        return instance;
    }

    private void loadFromConfig() {
        String string = Config.impaxee.jvision.SORTSPLIT.splitAndSortDefinition.get();
        this.checksumm = Checksumm.getChecksumm(string);
        XmlLoader xmlLoader = new XmlLoader();
        try {
            this.splitAndSort = (SplitAndSort)((Object)xmlLoader.load(string, SplitAndSort.class));
            if (this.splitAndSort == null) {
                log.error("Cannot parse conditional decomposition: " + string);
            }
        }
        catch (MarshalException marshalException) {
            log.error("Cannot parse conditional decomposition: " + string, (Throwable)marshalException);
            this.splitAndSort = null;
        }
    }

    public void save() {
        if (!this.splitAndSort.couldBeEdited()) {
            return;
        }
        this.splitAndSort.resetEditedFlag();
        this.writeToConfig();
    }

    private void writeToConfig() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().isSupportingRoles() ? ConfigurationProviderFactory.getAdministrationFactory().getConfigForRole(RoleManagerFactory.getInstance().getEnterpriseRole().getFullPath()) : ConfigurationProviderFactory.getConfig();
        if (this.isEmptyOrDefault(this.splitAndSort.conditionalSortDisplaySetsCriteria()) && this.isEmptyOrDefault(this.splitAndSort.conditionalSortImagesCriteria()) && this.isEmptyOrDefault(this.splitAndSort.conditionalSplitCriteria())) {
            log.warn("As only empty or default values found, resetting to original state");
            iConfigurationProvider.exists("xyz");
            iConfigurationProvider.removeValue(Config.impaxee.jvision.SORTSPLIT.splitAndSortDefinition.getKey());
        } else {
            XmlSaver xmlSaver = new XmlSaver((XmlSaveable)this.splitAndSort);
            try {
                String string = xmlSaver.toXmlString();
                long l = Checksumm.getChecksumm(string);
                if (l != this.checksumm) {
                    log.info("Storing modified Split/Sort rules");
                    iConfigurationProvider.exists("xyz");
                    iConfigurationProvider.setText(Config.impaxee.jvision.SORTSPLIT.splitAndSortDefinition.getKey(), string);
                    this.checksumm = l;
                }
            }
            catch (Exception exception) {
                log.error("Cannot generate XML representation for conditional split&sort.", (Throwable)exception);
            }
        }
    }

    private boolean isEmptyOrDefault(List<? extends AbstractConditionalCriterion> list) {
        if (list.size() == 0) {
            return true;
        }
        if (list.size() == 1) {
            return list.get(0).getDescription() == null;
        }
        return false;
    }

    public SplitAndSort getSplitAndSort() {
        return this.splitAndSort;
    }
}

