/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.AbstractDescriptorsXmlLoader;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractReferencedDescriptorsContainer;
import com.agfa.pacs.impaxee.splitsort.SplitSortImportExport;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.impaxee.splitsort.registry.SplitSortRegistry;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class SplitSortXmlLoader
extends AbstractDescriptorsXmlLoader {
    public static final String FILE_EXTENSION = ".AGS";

    public SplitSortXmlLoader() {
        super(FILE_EXTENSION);
    }

    @Override
    protected Class<? extends XmlLoadable> getXmlLoadableClass() {
        return SplitSortImportExport.class;
    }

    private boolean confirmOverload(Component component) {
        int n = JOptionPane.showConfirmDialog(component, Messages.getString("SplitSortXmlLoader.ImportConfirmation.Message"), Messages.getString("SplitSortXmlLoader.ImportConfirmation.Title"), 1, 3);
        return n == 0;
    }

    @Override
    protected boolean importSelectedXmlData(Component component, XmlLoadable xmlLoadable, boolean bl) {
        SplitSortImportExport splitSortImportExport = (SplitSortImportExport)xmlLoadable;
        if ((!bl || this.confirmOverload(component)) && this.importReferencedDescriptors(splitSortImportExport, bl)) {
            SplitSortRegistry.getInstance().getSplitAndSort().overload(splitSortImportExport.getSplitAndSort());
        }
        return true;
    }

    private boolean importReferencedDescriptors(SplitSortImportExport splitSortImportExport, boolean bl) {
        ArrayList<Descriptor> arrayList = new ArrayList<Descriptor>();
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        if (!this.collectReferencedDescriptorsForImport(splitSortImportExport.descriptorsAsList(), arrayList, hashMap, bl)) {
            return false;
        }
        SplitAndSort splitAndSort = splitSortImportExport.getSplitAndSort();
        for (Descriptor object2 : arrayList) {
            long iterator = object2.getId();
            long l = DescriptorRegistry.getInstance().importDescriptor(object2);
            this.updateReferencedDescriptors(splitAndSort, iterator, l);
        }
        Set set = hashMap.keySet();
        for (Object l : set) {
            long l2 = (Long)hashMap.get(l);
            this.updateReferencedDescriptors(splitAndSort, ((Long)l).longValue(), l2);
        }
        return true;
    }

    private void updateReferencedDescriptors(SplitAndSort splitAndSort, long l, long l2) {
        this.updateReferencedDescriptors(splitAndSort.conditionalSplitCriteria(), l, l2);
        this.updateReferencedDescriptors(splitAndSort.conditionalSortDisplaySetsCriteria(), l, l2);
        this.updateReferencedDescriptors(splitAndSort.conditionalSortImagesCriteria(), l, l2);
    }

    private void updateReferencedDescriptors(List<? extends AbstractReferencedDescriptorsContainer> list, long l, long l2) {
        for (AbstractReferencedDescriptorsContainer abstractReferencedDescriptorsContainer : list) {
            abstractReferencedDescriptorsContainer.updateReferencedDescriptors(l, l2);
        }
    }

    @Override
    protected String getAbortOption() {
        return Messages.getString("SplitSortXmlLoader.DecriptorConflict.DontImport");
    }
}

