/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.splitsort;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSetItem;
import com.agfa.pacs.impaxee.splitsort.gui.AdvancedManualSplitAndSortDialog;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Collections;

public class ManualSortSplitProcessor {
    private static ManualSortSplitProcessor instance = new ManualSortSplitProcessor();

    public static ManualSortSplitProcessor getInstance() {
        return instance;
    }

    public void splitAndSortDialog(IDisplaySet iDisplaySet, ManualSplitAndSortPresetsType manualSplitAndSortPresetsType) {
        AdvancedManualSplitAndSortDialog advancedManualSplitAndSortDialog = new AdvancedManualSplitAndSortDialog((Frame)JVision2.getMainFrame(), iDisplaySet.getSplitAndSortRuntime(), manualSplitAndSortPresetsType);
        advancedManualSplitAndSortDialog.setVisible(true);
        SplitAndSort splitAndSort = advancedManualSplitAndSortDialog.getReturn();
        manualSplitAndSortPresetsType.applyManualSplitAndSort(iDisplaySet, splitAndSort);
    }

    public void applyManualSplitAndSort(IStudyData iStudyData, SplitAndSort splitAndSort) {
        if (splitAndSort != null) {
            IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
            IHanging iHanging = iPatientRepresentation.getActiveHanging();
            this.clearDisplays(iStudyData);
            iHanging.getSplitAndSortRuntime().splitAndSortSingleStudy(iStudyData, splitAndSort);
            iPatientRepresentation.setActiveHanging(null);
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging, true, true);
        }
    }

    private void clearDisplays(IStudyData iStudyData) {
        VisData.blockLastModifiedChange(true);
        try {
            for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getAllDisplays()) {
                if (!iStudyData.equals(this.getCurrentStudyForDisplay(visDisplay2))) continue;
                visDisplay2.clear(false, false);
            }
        }
        finally {
            VisData.blockLastModifiedChange(false);
        }
    }

    private IStudyData getCurrentStudyForDisplay(VisDisplay2 visDisplay2) {
        IDisplaySet iDisplaySet;
        if (visDisplay2.hasData() && (iDisplaySet = visDisplay2.getData().getDisplaySet()) != null && iDisplaySet.getOneObject() != null) {
            return iDisplaySet.getOneObject().getParent().getParent();
        }
        return null;
    }

    public void changeImageSort(IDisplaySet iDisplaySet, IFrameSorter iFrameSorter) {
        ISplitAndSortRuntime iSplitAndSortRuntime = DataSelectionManager.getInstance().getCurrentPatient().getDecompositionRuntime();
        IFrameObjectData[] iFrameObjectDataArray = Arrays.copyOf(iDisplaySet.getObjects(), iDisplaySet.getFrameCount());
        iFrameSorter.sort(iFrameObjectDataArray);
        IDisplaySet iDisplaySet2 = HangingFactory.getInstance().newDisplaySet(iFrameObjectDataArray, iSplitAndSortRuntime);
        iSplitAndSortRuntime.addDisplaySet(iDisplaySet2);
        SplitAndSortChangeSetItem splitAndSortChangeSetItem = SplitAndSortChangeSetItem.createChangeInstance(iDisplaySet, iDisplaySet2);
        SplitAndSortChangeSet splitAndSortChangeSet = new SplitAndSortChangeSet(iSplitAndSortRuntime, Collections.singletonList(splitAndSortChangeSetItem));
        DataManager.getInstance().applySplitAndSortChange(splitAndSortChangeSet);
    }

    public static interface IFrameSorter {
        public void sort(IFrameObjectData[] var1);
    }
}

