/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.setlive;

import java.util.List;
import javax.media.j3d.Transform3D;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SetLiveDicomWriter {
    private final Attributes dicomObject;

    public SetLiveDicomWriter(Attributes attributes) {
        this.dicomObject = attributes;
    }

    public void putInt(int n, int n2) {
        this.dicomObject.setInt("TIANI", n, VR.IS, new int[]{n2});
    }

    public void putDouble(int n, double d) {
        this.dicomObject.setDouble("TIANI", n, VR.FD, new double[]{d});
    }

    public void putString(int n, String string) {
        this.dicomObject.setString("TIANI", n, VR.SH, string);
    }

    public void putFloats(int n, float[] fArray) {
        this.dicomObject.setFloat("TIANI", n, VR.FL, fArray);
    }

    public void putDoubles(int n, double[] dArray) {
        this.dicomObject.setDouble("TIANI", n, VR.FD, dArray);
    }

    public void putBoolean(int n, boolean bl) {
        this.putString(n, Boolean.toString(bl));
    }

    public void putTransform(int n, Transform3D transform3D) {
        double[] dArray = new double[16];
        transform3D.get(dArray);
        this.putDoubles(n, dArray);
    }

    public void putSequence(int n, List<Attributes> list) {
        Sequence sequence = this.dicomObject.newSequence("TIANI", n, list.size());
        for (Attributes attributes : list) {
            sequence.add(attributes);
        }
    }
}

