/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.setaside;

import com.agfa.pacs.impaxee.setaside.SetAsideStudyState;
import com.agfa.pacs.listtext.setaside.SetAsideState;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetAsidePatientState {
    private String key;
    private String sessionRef;
    private String activeHangingId;
    private boolean isCurrentPatient;
    private Collection<SetAsideStudyState> studies;

    private SetAsidePatientState() {
        this.studies = new ArrayList<SetAsideStudyState>();
    }

    public SetAsidePatientState(String string, String string2) {
        this(string, string2, false);
    }

    public SetAsidePatientState(String string, String string2, boolean bl) {
        this.key = string;
        this.sessionRef = null;
        this.activeHangingId = string2;
        this.isCurrentPatient = bl;
        this.studies = new ArrayList<SetAsideStudyState>();
    }

    public static SetAsidePatientState createInstance(Node node) throws Exception {
        SetAsidePatientState setAsidePatientState = new SetAsidePatientState();
        setAsidePatientState.init(node);
        return setAsidePatientState;
    }

    public String getKey() {
        return this.key;
    }

    public String getActiveHangingId() {
        return this.activeHangingId;
    }

    public String getSessionRef() {
        return this.sessionRef;
    }

    void setSessionRef(String string) {
        this.sessionRef = string;
    }

    public boolean isCurrentPatient() {
        return this.isCurrentPatient;
    }

    public Collection<SetAsideStudyState> getStudies() {
        return this.studies;
    }

    public int getStudyCount() {
        return this.studies.size();
    }

    public void addStudy(SetAsideStudyState setAsideStudyState) {
        this.studies.add(setAsideStudyState);
    }

    public String toXML() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<patient");
        stringBuilder.append(" key=");
        stringBuilder.append("\"" + SetAsideState.escapeXMLCharacters((String)this.key) + "\"");
        stringBuilder.append(" current-patient=");
        stringBuilder.append("\"" + Boolean.toString(this.isCurrentPatient) + "\"");
        if (this.activeHangingId != null) {
            stringBuilder.append(" active-hanging=");
            stringBuilder.append("\"" + SetAsideState.escapeXMLCharacters((String)this.activeHangingId) + "\"");
        }
        stringBuilder.append(">");
        if (this.sessionRef != null) {
            stringBuilder.append(" sessionRef=");
            stringBuilder.append("\"" + this.sessionRef + "\"");
        }
        if (this.studies != null) {
            for (SetAsideStudyState setAsideStudyState : this.studies) {
                stringBuilder.append(setAsideStudyState.toXML());
            }
        }
        stringBuilder.append("</patient>");
        return stringBuilder.toString();
    }

    private void init(Node node) throws Exception {
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.key = namedNodeMap.getNamedItem("key").getTextContent();
        this.activeHangingId = namedNodeMap.getNamedItem("active-hanging") != null ? namedNodeMap.getNamedItem("active-hanging").getTextContent() : null;
        this.sessionRef = namedNodeMap.getNamedItem("sessionRef") != null ? namedNodeMap.getNamedItem("sessionRef").getTextContent() : null;
        this.isCurrentPatient = Boolean.parseBoolean(namedNodeMap.getNamedItem("current-patient").getTextContent());
        this.studies.clear();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                this.studies.add(SetAsideStudyState.createInstance(nodeList.item(n)));
                ++n;
            }
        }
    }
}

