/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.sessions.gui.ImageAreaWorklistChooserPanel;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.tiani.jvision.main.JVision2;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WorklistChooser
extends MessageDialog.AbstractOptionStateCallback {
    private String dialogResult = "CANCEL_OPTION";
    private ImageAreaWorklistChooserPanel chooserPanel;

    public WorklistChooser(Component component, List<IWorklistContext> list, IHangingSession iHangingSession) {
        this.chooserPanel = new ImageAreaWorklistChooserPanel(list, iHangingSession, Config.impaxee.jvision.DIALOGS.RememberLastUsedWorklist.get());
        this.chooserPanel.addWorklistSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WorklistChooser.this.notifyListener();
            }
        });
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)JVision2.getMainFrame(), (String)Messages.getString("WorklistChooserDlg.Title"), (Object)this.chooserPanel, (boolean)true, (int)3, (String)"OK_CANCEL_OPTION", (boolean)false, (IComponentFactory)ComponentFactory.instance);
        if (iHangingSession == null) {
            messageDialog.setOptionStateCallback((MessageDialog.IOptionStateCallback)this);
        }
        messageDialog.showCenteredInOwner();
        this.dialogResult = messageDialog.getSelectedOption();
    }

    public boolean saveData() {
        if (this.chooserPanel.isSaveable()) {
            return this.chooserPanel.save(false);
        }
        return false;
    }

    public Collection<IWorklistContext> getSelectedWorklistContexts() {
        return this.chooserPanel.getUpdatedWorklistContexts();
    }

    public String getDialogResult() {
        return this.dialogResult;
    }

    public boolean isOptionEnabled(String string) {
        if ("OK_OPTION".equals(string)) {
            Collection<IWorklistContext> collection = this.getSelectedWorklistContexts();
            return collection != null && !collection.isEmpty();
        }
        return true;
    }
}

