/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class SessionStorageData {
    private final Session session;
    private final String[] filteredStudyOrdering;
    private final List<SessionDisplaySet> filteredDisplaySets;
    private final List<SessionObject> filteredAdditionalObjects;

    SessionStorageData(Session session, String[] stringArray, List<SessionDisplaySet> list, List<SessionObject> list2) {
        this.session = session;
        this.filteredStudyOrdering = stringArray;
        this.filteredDisplaySets = Collections.unmodifiableList(list);
        this.filteredAdditionalObjects = Collections.unmodifiableList(list2);
    }

    IStudyData createStudyData() {
        return this.session.getPatient().getPatientData().createStudyData();
    }

    String getVisibleName() {
        return this.session.getVisibleName();
    }

    IStudyData getSessionBaseStudy() {
        return this.session.getSessionBaseStudy();
    }

    String[] getStudyOrdering() {
        if (this.filteredStudyOrdering == null) {
            return null;
        }
        return Arrays.copyOf(this.filteredStudyOrdering, this.filteredStudyOrdering.length);
    }

    List<String[]> getSpecialScreenLayouts() {
        return this.session.getSpecialScreenLayouts();
    }

    Iterable<SessionDisplaySet> getSessionDisplaySets() {
        return this.filteredDisplaySets;
    }

    Iterable<SessionObject> getAdditionalObjects() {
        return this.filteredAdditionalObjects;
    }

    SessionKeyObject createSessionKeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject, byte[] byArray) {
        IPatientData iPatientData = this.session.getPatient().getPatientData();
        String string = iPatientData.getKey();
        if (PatientMergeUtilities.getPatientMergeStatus((Attributes)iPatientData.getQueryObject().getAttributes()) == PatientMergeUtilities.PatientMergeStatus.NotMerged) {
            string = null;
        }
        return new SessionKeyObject(keyObjectSelectionDocumentInformationObject, byArray, string);
    }

    void setSessionKeyObject(SessionKeyObject sessionKeyObject, IKeyObjectData iKeyObjectData) {
        this.session.setSessionKeyObject(sessionKeyObject, iKeyObjectData);
    }

    SessionKeyObject getSessionKeyObject() {
        return this.session.getSessionKeyObject();
    }

    IKeyObjectData getKeyObjectData() {
        return this.session.getKeyObjectData();
    }
}

