/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.impl.ImpaxEESessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.util.UIDUtils;

public class SessionDisplaySet {
    public static ALogger log = ALogger.getLogger(SessionDisplaySet.class);
    private String sessionSeqUID = UIDUtils.createUID();
    private String seriesUID;
    private List<SessionObject> objs = new ArrayList<SessionObject>();
    private boolean isShowingAllSessionOjectsEnabled = false;
    private ISplitAndSortRuntime parent;
    transient IDisplaySet displaySet = null;

    public SessionDisplaySet(ISplitAndSortRuntime iSplitAndSortRuntime) {
        this.parent = iSplitAndSortRuntime;
    }

    public SessionDisplaySet(IDisplaySet iDisplaySet, ISplitAndSortRuntime iSplitAndSortRuntime) {
        this(iSplitAndSortRuntime);
        this.displaySet = iDisplaySet;
        this.capture(iDisplaySet);
    }

    public SessionDisplaySet(DataInputStream dataInputStream, ISplitAndSortRuntime iSplitAndSortRuntime) throws IOException {
        this(iSplitAndSortRuntime);
        this.read(dataInputStream);
    }

    private void capture(IDisplaySet iDisplaySet) {
        if (iDisplaySet.getFrameCount() > 0) {
            this.seriesUID = iDisplaySet.getOneObject().getParent().getSeriesInstanceUID();
        }
        this.objs.clear();
        LinkedHashSet<IImageObjectData> linkedHashSet = new LinkedHashSet<IImageObjectData>(iDisplaySet.getFrameCount());
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData iDataObject = iFrameObjectDataArray[n2];
            linkedHashSet.add(iDataObject.getMainFrame());
            ++n2;
        }
        for (IImageObjectData iImageObjectData : linkedHashSet) {
            this.objs.add(new SessionObject(iImageObjectData));
        }
    }

    void write(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeUTF(this.getSessionSeqUID());
        dataOutputStream.writeUTF(this.getSeriesUID());
        dataOutputStream.writeBoolean(this.isShowingAllSessionOjectsEnabled());
        dataOutputStream.writeInt(this.objs().size());
        for (SessionObject sessionObject : this.objs()) {
            sessionObject.write(dataOutputStream);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.sessionSeqUID = dataInputStream.readUTF();
        this.seriesUID = dataInputStream.readUTF();
        int n = this.seriesUID.lastIndexOf("_");
        this.seriesUID = this.seriesUID.substring(n + 1);
        this.isShowingAllSessionOjectsEnabled = dataInputStream.readBoolean();
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            this.objs.add(new SessionObject(dataInputStream));
            ++n3;
        }
        this.displaySet = new ImpaxEESessionDisplaySet(this.objs, this.parent);
    }

    public boolean isShowingAllSessionOjectsEnabled() {
        return this.isShowingAllSessionOjectsEnabled;
    }

    public List<SessionObject> objs() {
        return this.objs;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionDisplaySet)) {
            return false;
        }
        SessionDisplaySet sessionDisplaySet = (SessionDisplaySet)object;
        if (this.getDisplaySet() != sessionDisplaySet.getDisplaySet()) {
            return false;
        }
        if (!(this.seriesUID == null && sessionDisplaySet.seriesUID == null || this.seriesUID == null || this.seriesUID.equals(sessionDisplaySet.seriesUID))) {
            return false;
        }
        return Objects.equals(this.objs, sessionDisplaySet.objs);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String getSessionSeqUID() {
        return this.sessionSeqUID;
    }

    public String getSeriesUID() {
        return this.seriesUID;
    }

    public IDisplaySet getDisplaySet() {
        return this.displaySet;
    }

    public SessionDisplaySet cloneForSave() {
        SessionDisplaySet sessionDisplaySet = new SessionDisplaySet(this.parent);
        sessionDisplaySet.sessionSeqUID = this.sessionSeqUID;
        sessionDisplaySet.seriesUID = this.seriesUID;
        sessionDisplaySet.displaySet = this.displaySet;
        for (SessionObject sessionObject : this.objs) {
            sessionDisplaySet.objs.add(sessionObject.cloneForSave());
        }
        return sessionDisplaySet;
    }
}

