/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.dcm4che3.data.Attributes;

public class SessionBuilder
implements Runnable {
    private static ALogger log = ALogger.getLogger(SessionBuilder.class);
    private static DataManager dm = DataManager.getInstance();
    private static DataSelectionManager dsm = DataSelectionManager.getInstance();
    private Attributes dataset = null;
    private IKeyObjectData keyObjectData;
    private String datasetSourceName = null;
    private Session session = null;
    private CountDownLatch sessionLoaded = new CountDownLatch(1);
    private boolean isLoadedSuccessfully;
    private boolean fromMPI = false;

    public SessionBuilder(String string, Attributes attributes, IKeyObjectData iKeyObjectData, boolean bl) {
        if (attributes == null) {
            throw new IllegalArgumentException("constructing SessionBuilder failed");
        }
        this.dataset = attributes;
        this.datasetSourceName = string;
        this.keyObjectData = iKeyObjectData;
        this.fromMPI = bl;
    }

    public Attributes getDataset() {
        return this.dataset;
    }

    public String getPatientKey() {
        return PatientKeyUtils.generatePatientKey((Attributes)this.dataset);
    }

    @Override
    public void run() {
        try {
            this.buildSession();
        }
        finally {
            this.sessionLoaded.countDown();
        }
    }

    private void buildSession() {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        List list = null;
        KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject = KeyObjectSelectionDocumentInformationObject.createInstance((Attributes)this.dataset);
        SessionKeyObject sessionKeyObject = new SessionKeyObject(keyObjectSelectionDocumentInformationObject, null, this.dataset.getString("TIANI", 2687059));
        if (this.dataset.contains("TIANI", 2687060)) {
            sessionKeyObject.setStudyOrdering(this.dataset.getStrings("TIANI", 2687060));
        }
        if (this.dataset.contains("TIANI", 2687061)) {
            object4 = this.dataset.getSequence("TIANI", 2687061);
            object32 = new ArrayList(object4.size());
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (Attributes)object2.next();
                object32.add(object.getStrings("TIANI", 2687062));
            }
            sessionKeyObject.setSpecialScreenLayouts((List<String[]>)object32);
        }
        sessionKeyObject.setSessionData(this.dataset);
        list = sessionKeyObject.referencedImages();
        if (list == null) {
            return;
        }
        object4 = new ArrayList(list.size());
        for (Object object32 : list) {
            object4.add(object32.getSOPInstanceUID());
        }
        object32 = dm.getNotLoadedSOPInstanceUIDs((List<String>)object4, DataManager.getInstance().getPatientRepresentation(this.dataset));
        if (object32 != null && !object32.isEmpty()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Attempting to load/open " + object32.size() + " objects");
                }
                object = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getRetriever();
                object.retrieveObjects(this.datasetSourceName, (Collection<String>)object32);
                log.debug("Loading/Opening missing objects succeeded");
            }
            catch (Exception exception) {
                log.error("Loading/Opening missing objects failed!");
                return;
            }
        }
        try {
            Object object5;
            object = new ByteArrayInputStream(sessionKeyObject.getSessionData());
            object2 = new DataInputStream((InputStream)object);
            IPatientRepresentation iPatientRepresentation = dm.getPatientRepresentation(this.dataset);
            if (iPatientRepresentation == null) {
                iPatientRepresentation = dm.getPatientRepresentationWeakMatch(this.dataset);
            }
            if (iPatientRepresentation == null) {
                object5 = null;
                if (this.fromMPI) {
                    object5 = dm.getSimilarPatient(this.dataset, null);
                }
                if (object5 == null) {
                    object5 = dm.getMergedPatient(PatientKeyUtils.generatePatientKey((Attributes)this.dataset));
                }
                if (object5 != null) {
                    iPatientRepresentation = dm.getPatientRepresentation(object5.getKey());
                }
            }
            if (iPatientRepresentation == null) {
                log.error("Patient not recognized");
                return;
            }
            object5 = DateTimeUtils.getStudyDateTime((Attributes)this.dataset);
            this.session = new Session((DataInputStream)object2, iPatientRepresentation, (Date)object5, sessionKeyObject, this.keyObjectData);
            ((FilterInputStream)object2).close();
            iPatientRepresentation.addHanging(this.session);
            dm.notifyPatientRepresentationModified(iPatientRepresentation);
            this.isLoadedSuccessfully = true;
        }
        catch (Exception exception) {
            log.error("Could not read session content", (Throwable)exception);
        }
    }

    public void display() {
        try {
            this.sessionLoaded.await();
        }
        catch (InterruptedException interruptedException) {}
        if (this.isLoadedSuccessfully) {
            boolean bl = false;
            if (this.session.getKeyObjectData() != null) {
                bl = (Boolean)this.session.getKeyObjectData().getQueryObject().getTreeParent().getTreeParent().getAttributes().getProperty("SET_ASIDE_STATUS", (Object)false);
            }
            if (bl || Config.impaxee.jvision.HANGMAN.preferSessionsOverHangingProtocols.get()) {
                dsm.setActiveHanging(this.session.getPatient(), this.session, true, true);
            }
        }
        IPatientRepresentation iPatientRepresentation = null;
        if (this.session != null) {
            iPatientRepresentation = this.session.getPatient();
        }
        if (iPatientRepresentation == null) {
            try {
                iPatientRepresentation = dm.getPatientRepresentation(PatientKeyUtils.generatePatientKey((Attributes)this.dataset));
            }
            catch (Exception exception) {
                log.error("Could not find patient", (Throwable)exception);
            }
        }
        if (iPatientRepresentation != null) {
            dsm.setCurrentPatient(iPatientRepresentation);
            dm.refreshHangings(iPatientRepresentation, true, false);
        }
    }

    public Collection<IStudyData> getContainedStudies() {
        if (this.session == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, IStudyData> linkedHashMap = new LinkedHashMap<String, IStudyData>();
        for (IDisplaySet iDisplaySet : this.session.getDisplaySets()) {
            IStudyData iStudyData = iDisplaySet.getOneObject().getParent().getParent();
            if (linkedHashMap.containsKey(iStudyData.getKey())) continue;
            linkedHashMap.put(iStudyData.getKey(), iStudyData);
        }
        return linkedHashMap.values();
    }

    public Date getCreationDateTime() {
        return DateTimeUtils.getStudyDateTime((Attributes)this.dataset);
    }
}

