/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.sessions;

import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.integration.ObjectID;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.AbstractStudyContainer;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.hanging.impl.AbstractHangingSnapshotModel;
import com.agfa.pacs.impaxee.hanging.runtime.AbstractHangingRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.SnapshotUtil;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.impaxee.sessions.SessionDisplay;
import com.agfa.pacs.impaxee.sessions.SessionDisplaySet;
import com.agfa.pacs.impaxee.sessions.SessionKeyObject;
import com.agfa.pacs.impaxee.sessions.SessionObject;
import com.agfa.pacs.impaxee.sessions.SessionSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.SessionStorage;
import com.agfa.pacs.impaxee.sessions.SessionStorageData;
import com.agfa.pacs.impaxee.sessions.gui.ImageAreaWorklistChooserPanel;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.SessionSplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.util.SaveData;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.dcm4che3.util.UIDUtils;

public class Session
extends AbstractHangingRuntime
implements IHangingSession,
ISaveItem {
    private static final DataManager DATA_MANAGER = DataManager.getInstance();
    private static final Icon ICON = IAIconFactory.DEFAULT_FACTORY.loadIcon("session.svg");
    private static final ALogger log = ALogger.getLogger(Session.class);
    private static final String SERIALIZATION_TAG = "TIANISESSION";
    private static final boolean INCLUDE_ALL_STUDIES_ON_SAVE = !Config.impaxee.jvision.HANGMAN.filterSavedStudiesInSession.get();
    private String sessionUID = null;
    private IPatientRepresentation patientRepresentation;
    private List<SessionSnapshotRuntime> snaps;
    private boolean isSaved = false;
    private IHanging.SnapshotModel snapshotModel;
    private List<IStoreHandler> storeHandlers;
    private SessionStudyContainer myStudyContainer;
    private String[] studyOrdering;
    private SessionKeyObject sessionKeyObject;
    private IKeyObjectData keyObjectData;
    private Date dateTime;
    private SessionSplitAndSortRuntime splitAndSortRuntime;
    private final boolean isSetLiveEnabled;
    private final List<SessionObject> additionalObjects = new ArrayList<SessionObject>(2);

    private Session(IPatientRepresentation iPatientRepresentation, Date date, boolean bl) {
        super(null);
        if (iPatientRepresentation == null) {
            throw new IllegalArgumentException("creation of session object failed");
        }
        this.patientRepresentation = iPatientRepresentation;
        this.isSetLiveEnabled = bl;
        this.snaps = new ArrayList<SessionSnapshotRuntime>();
        this.sessionUID = UIDUtils.createUID();
        this.splitAndSortRuntime = new SessionSplitAndSortRuntime(iPatientRepresentation);
        this.myStudyContainer = new SessionStudyContainer();
        this.setDateTime(date);
    }

    public Session(DataInputStream dataInputStream, IPatientRepresentation iPatientRepresentation, Date date, SessionKeyObject sessionKeyObject, IKeyObjectData iKeyObjectData) throws IOException {
        this(iPatientRepresentation, date, true);
        this.sessionKeyObject = sessionKeyObject;
        this.keyObjectData = iKeyObjectData;
        this.studyOrdering = sessionKeyObject.getStudyOrdering();
        this.read(dataInputStream);
        if (iPatientRepresentation.getDecompositionRuntime() != null) {
            this.splitAndSortRuntime.addDisplaySets(iPatientRepresentation.getDecompositionRuntime().getDisplaySets());
            iPatientRepresentation.getDecompositionRuntime().addDisplaySetListener(this.splitAndSortRuntime);
        }
        this.myStudyContainer = new SessionStudyContainer();
        this.isSaved = true;
    }

    public Session(String string, IPatientRepresentation iPatientRepresentation, Date date) {
        this(string, iPatientRepresentation, date, true);
    }

    public Session(String string, IPatientRepresentation iPatientRepresentation, Date date, boolean bl) {
        this(iPatientRepresentation, date, bl);
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("creation of session object requires a name, got: >" + string + "<");
        }
        this.setVisibleName(string);
        this.initFromActiveHanging();
        this.myStudyContainer = new SessionStudyContainer();
        if (iPatientRepresentation.getDecompositionRuntime() != null) {
            iPatientRepresentation.getDecompositionRuntime().addDisplaySetListener(this.splitAndSortRuntime);
        }
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    public boolean isApplyable() {
        return true;
    }

    public List<SessionSnapshotRuntime> getSnapshots() {
        return this.snaps;
    }

    public String getSessionUID() {
        return this.sessionUID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getVisibleName());
        if (this.patientRepresentation != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.patientRepresentation.getPatientData().getDicomObject().getString(0x100010));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private Set<String> getUsedStudyInstanceUIDs() {
        if (INCLUDE_ALL_STUDIES_ON_SAVE) {
            return new HashSet<String>(this.splitAndSortRuntime.getStudyOrdering());
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getSessionBaseStudy().getStudyInstanceUID());
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                SessionDisplaySet sessionDisplaySet = sessionDisplay.getSessionDisplaySet();
                if (sessionDisplaySet == null) continue;
                hashSet.add(sessionDisplaySet.getDisplaySet().getStudyUID());
            }
        }
        return hashSet;
    }

    private List<SessionDisplaySet> getFilteredSessionDisplaySets(Set<String> set) {
        if (INCLUDE_ALL_STUDIES_ON_SAVE) {
            return new ArrayList<SessionDisplaySet>(this.splitAndSortRuntime.sessionDisplaySets);
        }
        ArrayList<SessionDisplaySet> arrayList = new ArrayList<SessionDisplaySet>();
        for (SessionDisplaySet sessionDisplaySet : this.splitAndSortRuntime.sessionDisplaySets) {
            if (!set.contains(sessionDisplaySet.getDisplaySet().getStudyUID())) continue;
            arrayList.add(sessionDisplaySet);
        }
        return arrayList;
    }

    private String[] getFilteredStudyOrdering(Set<String> set) {
        if (this.studyOrdering == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        String[] stringArray = this.studyOrdering;
        int n = this.studyOrdering.length;
        int n2 = 0;
        while (n2 < n) {
            String object = stringArray[n2];
            if (set.remove(object)) {
                arrayList.add(object);
            }
            ++n2;
        }
        if (!set.isEmpty()) {
            for (SessionDisplaySet sessionDisplaySet : this.splitAndSortRuntime.sessionDisplaySets) {
                String string = sessionDisplaySet.getDisplaySet().getStudyUID();
                if (set.remove(string)) {
                    arrayList.add(string);
                }
                if (set.isEmpty()) break;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private List<SessionObject> getFilterAdditionalObjects(Set<String> set) {
        ArrayList<SessionObject> arrayList = new ArrayList<SessionObject>(this.additionalObjects.size());
        for (SessionObject sessionObject : this.additionalObjects) {
            if (!set.contains(sessionObject.getStudyUID())) continue;
            arrayList.add(sessionObject);
        }
        for (IObjectInfo iObjectInfo : this.patientRepresentation.getPatientData().getAdditionalObjects()) {
            if (!set.contains(iObjectInfo.getStudyUID())) continue;
            arrayList.add(new SessionObject((ILoadableInfo)iObjectInfo));
        }
        return arrayList;
    }

    SessionStorageData write(DataOutputStream dataOutputStream) throws Throwable {
        dataOutputStream.writeUTF(SERIALIZATION_TAG);
        dataOutputStream.writeUTF(this.getSessionUID());
        dataOutputStream.writeUTF(this.getVisibleName());
        Set<String> set = this.getUsedStudyInstanceUIDs();
        List<SessionDisplaySet> list = this.getFilteredSessionDisplaySets(set);
        dataOutputStream.writeInt(list.size());
        for (SessionDisplaySet object : list) {
            object.write(dataOutputStream);
        }
        dataOutputStream.writeInt(this.getSnapshots().size());
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            sessionSnapshotRuntime.write(dataOutputStream);
        }
        return new SessionStorageData(this, this.getFilteredStudyOrdering(set), list, this.getFilterAdditionalObjects(set));
    }

    private void read(DataInputStream dataInputStream) throws IOException {
        if (!SERIALIZATION_TAG.equals(dataInputStream.readUTF())) {
            throw new IllegalArgumentException("invalid session format");
        }
        this.sessionUID = dataInputStream.readUTF();
        this.setVisibleName(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.splitAndSortRuntime.addSessionDisplaySet(new SessionDisplaySet(dataInputStream, (ISplitAndSortRuntime)this.splitAndSortRuntime));
            ++n2;
        }
        n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            SessionSnapshotRuntime sessionSnapshotRuntime = new SessionSnapshotRuntime(Integer.toString(n3), this);
            sessionSnapshotRuntime.read(dataInputStream, this.sessionKeyObject, this.splitAndSortRuntime.sessionDisplaySets, n3);
            this.snaps.add(sessionSnapshotRuntime);
            ++n3;
        }
    }

    private SessionSnapshotRuntime captureSnapshot() {
        SessionSnapshotRuntime sessionSnapshotRuntime = new SessionSnapshotRuntime(SnapshotUtil.findNextSnapshotName(this), this);
        sessionSnapshotRuntime.capture();
        return sessionSnapshotRuntime;
    }

    public void setDateTime(Date date) {
        this.dateTime = date;
    }

    @Override
    public IHanging.SnapshotModel getSnapshotModel() {
        if (this.snapshotModel == null) {
            this.snapshotModel = new SessionSnapshotModel();
        }
        return this.snapshotModel;
    }

    private int getSnapshotCount() {
        return this.snaps.size();
    }

    public SessionSnapshotRuntime getSnapshot(int n) {
        return n >= this.getSnapshotCount() || n < 0 ? null : this.snaps.get(n);
    }

    public SessionSnapshotRuntime getSnapshot(String string) {
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.snaps) {
            if (!sessionSnapshotRuntime.getName().equals(string)) continue;
            return sessionSnapshotRuntime;
        }
        return null;
    }

    public AbstractSnapshotRuntime findSnap(AbstractSnapshotRuntime abstractSnapshotRuntime) {
        return this.snaps.contains(abstractSnapshotRuntime) ? abstractSnapshotRuntime : null;
    }

    public SessionDisplaySet findDisplaySet(IDisplaySet iDisplaySet) {
        for (SessionDisplaySet sessionDisplaySet : this.splitAndSortRuntime.sessionDisplaySets) {
            if (sessionDisplaySet.getDisplaySet().getID() != iDisplaySet.getID()) continue;
            return sessionDisplaySet;
        }
        return null;
    }

    @Override
    public boolean save(Collection<IWorklistContext> collection) {
        if (this.getSnapshotCount() == 0) {
            return false;
        }
        try {
            Object object2;
            if (DataSelectionManager.getInstance().getActiveHanging() == this) {
                int n;
                object2 = this.getSnapshotModel();
                int n2 = n = object2.size() == 1 ? 0 : object2.getSelected();
                if (n >= 0) {
                    object2.update(n);
                }
            }
            object2 = new SessionStorage();
            SaveData saveData = ((SessionStorage)object2).writeSession(this);
            this.storeHandlers = new ArrayList<IStoreHandler>(2);
            this.addStoreHandler(DataManager.getInstance().getDataStore().store(saveData.getKeyObject(), saveData.getStudy(), collection));
            ArrayList<IObjectData> arrayList = new ArrayList<IObjectData>();
            for (SessionSnapshotRuntime object3 : this.snaps) {
                object3.collectUnsavedSetLiveData(arrayList);
            }
            this.addStoreHandler(DataManager.getInstance().getDataStore().store(arrayList, saveData.getStudy(), null));
            IKeyObjectData iKeyObjectData = saveData.getKeyObject();
            IPatientData iPatientData = iKeyObjectData.getParent() == null ? DataSelectionManager.getInstance().getCurrentPatient().getPatientData() : iKeyObjectData.getParent().getParent().getParent();
            ObjectID objectID = ObjectID.forSingleInstance((String)iPatientData.getDicomObject().getString(0x100020), (String)iKeyObjectData.getSOPInstanceUID());
            objectID.setStudyUID(iKeyObjectData.getDicomObject().getString(0x20000D));
            IntegrationFrameworkFactory.getInstance().sessionStored(objectID, this.getVisibleName());
            this.isSaved = true;
            return true;
        }
        catch (Throwable throwable) {
            log.error("Could not store session", throwable);
            return false;
        }
    }

    private void addStoreHandler(IStoreHandler iStoreHandler) {
        if (iStoreHandler != null) {
            this.storeHandlers.add(iStoreHandler);
        }
    }

    @Override
    public List<IStoreHandler> getStoreHandlers() {
        return this.storeHandlers;
    }

    @Override
    public boolean save() {
        return this.save(null);
    }

    @Override
    public boolean save(boolean bl) {
        return this.save();
    }

    @Override
    public boolean isSaved() {
        return this.isSaved;
    }

    @Override
    public boolean isSetLiveEnabled() {
        return this.isSetLiveEnabled;
    }

    public SessionSnapshotRuntime addSnapshot(Integer n) {
        SessionSnapshotRuntime sessionSnapshotRuntime = this.captureSnapshot();
        if (sessionSnapshotRuntime != null) {
            this.addSnap(n, sessionSnapshotRuntime);
        }
        return sessionSnapshotRuntime;
    }

    private int addSnap(Integer n, SessionSnapshotRuntime sessionSnapshotRuntime) {
        this.isSaved = false;
        if (n == null || n < 0 || n >= this.getSnapshotCount()) {
            this.snaps.add(sessionSnapshotRuntime);
            return this.snaps.size() - 1;
        }
        this.snaps.add(n, sessionSnapshotRuntime);
        return n;
    }

    public void removeSnapshot(int n) {
        if (n < 0 || n >= this.getSnapshotCount()) {
            return;
        }
        this.isSaved = false;
        this.snaps.remove(n);
        this.removeUnusedSetLiveSCs();
    }

    private void initFromActiveHanging() {
        Object object;
        IDisplaySet[] iDisplaySetArray;
        if (this.patientRepresentation == null || this.patientRepresentation.getActiveHanging() == null) {
            return;
        }
        IHanging iHanging = this.patientRepresentation.getActiveHanging();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray = iHanging.getSplitAndSortRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDisplaySetArray2[n2];
            this.splitAndSortRuntime.addDisplaySet((IDisplaySet)object);
            ++n2;
        }
        object = iHanging.getStudyContainer();
        this.studyOrdering = new String[object.getRelevantPriorCount() + 1];
        this.studyOrdering[0] = object.getBaseStudy().getStudyInstanceUID();
        n2 = 0;
        while (n2 < object.getRelevantPriorCount()) {
            this.studyOrdering[n2 + 1] = object.getPriorInfo(n2).getStudyUID();
            ++n2;
        }
    }

    public List<SessionDisplaySet> getSessionDisplaySets() {
        return this.splitAndSortRuntime.sessionDisplaySets;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    @Override
    public List<IDisplaySet> getDisplaySets() {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        IDisplaySet[] iDisplaySetArray = this.getSplitAndSortRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
            arrayList.add(iDisplaySet);
            ++n2;
        }
        return arrayList;
    }

    @Override
    public IStudyContainer getStudyContainer() {
        return this.myStudyContainer;
    }

    int getStudyOrdering(String string) {
        if (this.studyOrdering != null) {
            int n = 0;
            String[] stringArray = this.studyOrdering;
            int n2 = this.studyOrdering.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                if (string2.equals(string)) {
                    return n;
                }
                ++n;
                ++n3;
            }
        }
        return -1;
    }

    IStudyData getSessionBaseStudy() {
        IStudyData iStudyData;
        Iterator<IStudyData> iterator;
        if (this.studyOrdering != null) {
            iterator = this.splitAndSortRuntime.getStudies().iterator();
            while (iterator.hasNext()) {
                iStudyData = iterator.next();
                if (this.getStudyOrdering(iStudyData.getKey()) != 0) continue;
                return iStudyData;
            }
        }
        if ((iterator = this.splitAndSortRuntime.getStudies().iterator()).hasNext()) {
            iStudyData = iterator.next();
            return iStudyData;
        }
        return null;
    }

    protected void removeUnusedSetLiveSCs() {
        Collection<SessionDisplaySet> collection = this.collectAllSetLiveSCs();
        this.removeUsedSessionDisplaySets(collection);
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(collection.size());
        for (SessionDisplaySet sessionDisplaySet : collection) {
            arrayList.add(sessionDisplaySet.getDisplaySet());
            this.splitAndSortRuntime.removeSessionDisplaySet(sessionDisplaySet);
        }
        DataManager.getInstance().removeDisplaySet(arrayList.toArray(new IDisplaySet[arrayList.size()]), true);
    }

    private Collection<SessionDisplaySet> collectAllSetLiveSCs() {
        HashSet<SessionDisplaySet> hashSet = new HashSet<SessionDisplaySet>();
        for (SessionDisplaySet sessionDisplaySet : this.splitAndSortRuntime.sessionDisplaySets) {
            IDisplaySet iDisplaySet = sessionDisplaySet.getDisplaySet();
            if (!iDisplaySet.isSetLiveSecondaryCapture()) continue;
            hashSet.add(sessionDisplaySet);
        }
        return hashSet;
    }

    private void removeUsedSessionDisplaySets(Collection<SessionDisplaySet> collection) {
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.snaps) {
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                collection.remove(sessionDisplay.getSessionDisplaySet());
            }
        }
    }

    public void removeDisplaySets(IDisplaySet[] iDisplaySetArray) {
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.snaps) {
            for (SessionDisplay sessionDisplay : sessionSnapshotRuntime.displays()) {
                SessionDisplaySet sessionDisplaySet = sessionDisplay.getSessionDisplaySet();
                IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
                int n = iDisplaySetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
                    if (sessionDisplaySet != null && sessionDisplaySet.getDisplaySet() == iDisplaySet) {
                        sessionDisplay.setSessionDisplaySet(null);
                        this.splitAndSortRuntime.removeSessionDisplaySet(sessionDisplaySet);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public List<IWorklistContext> getUserAndScheduledWorklistContexts() {
        Collection<IWorklistContext> collection = DataManager.getInstance().getDataStore().getAvailableWorklistContexts();
        ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>();
        boolean bl = Config.impaxee.jvision.DIALOGS.ShowOnlySelectedWorklists.get();
        for (IWorklistContext iWorklistContext : collection) {
            if (!"USER".equals(iWorklistContext.getType()) && !iWorklistContext.isScheduled() || bl && !iWorklistContext.isSelected()) continue;
            arrayList.add(iWorklistContext);
        }
        return arrayList;
    }

    @Override
    public ISaveItem newSaveItem(IPatientRepresentation iPatientRepresentation) {
        ISaveItem iSaveItem = this;
        List<IWorklistContext> list = this.getUserAndScheduledWorklistContexts();
        if (list.size() > 0) {
            iSaveItem = new ImageAreaWorklistChooserPanel(list, this, Config.impaxee.jvision.DIALOGS.RememberLastUsedWorklist.get());
            Collection<IWorklistContext> collection = ImageAreaWorklistChooserPanel.getUnsavedHangings().get(this);
            if (collection != null && !collection.isEmpty()) {
                ((ImageAreaWorklistChooserPanel)iSaveItem).setSelectedWorklistContexts(collection);
            }
        }
        return iSaveItem;
    }

    @Override
    public Component getComponent() {
        return null;
    }

    @Override
    public int getProgressAmount() {
        return 0;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    @Override
    public void setSaveManager(ISaveManager iSaveManager) {
    }

    @Override
    public SessionSplitAndSortRuntime getSplitAndSortRuntime() {
        return this.splitAndSortRuntime;
    }

    @Override
    public void studyRemoved(IStudyData iStudyData) {
        if (this.getStudyContainer().getBaseStudy().equals(iStudyData)) {
            HangingUtil.dismissHanging(this);
            return;
        }
        if (this.splitAndSortRuntime.sessionDisplaySets != null && this.splitAndSortRuntime.sessionDisplaySets.size() > 0) {
            for (SessionDisplaySet sessionDisplaySet : this.splitAndSortRuntime.sessionDisplaySets) {
                IStudyData iStudyData2;
                IFrameObjectData iFrameObjectData = sessionDisplaySet.getDisplaySet().getOneObject();
                if (iFrameObjectData == null || !(iStudyData2 = iFrameObjectData.getParent().getParent()).equals(iStudyData)) continue;
                if (DataSelectionManager.getInstance().getActiveHanging() != this) {
                    HangingUtil.dismissHanging(this);
                    break;
                }
                this.splitAndSortRuntime.removeStudy(iStudyData);
                this.isSaved = false;
                break;
            }
        }
    }

    @Override
    public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray) {
    }

    @Override
    public IPatientRepresentation getPatient() {
        return this.patientRepresentation;
    }

    @Override
    public String getIdentifier() {
        return this.getSessionUID();
    }

    public void setSessionKeyObject(SessionKeyObject sessionKeyObject, IKeyObjectData iKeyObjectData) {
        this.sessionKeyObject = sessionKeyObject;
        this.keyObjectData = iKeyObjectData;
    }

    public SessionKeyObject getSessionKeyObject() {
        return this.sessionKeyObject;
    }

    public IKeyObjectData getKeyObjectData() {
        return this.keyObjectData;
    }

    @Override
    public void setSaved(boolean bl) {
    }

    @Override
    public IStudyInfo getStudyInstance() {
        if (this.keyObjectData == null) {
            return null;
        }
        return (IStudyInfo)this.keyObjectData.getQueryObject().getTreeParent().getTreeParent();
    }

    List<String[]> getSpecialScreenLayouts() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(this.getSnapshotCount());
        for (SessionSnapshotRuntime sessionSnapshotRuntime : this.getSnapshots()) {
            arrayList.add(sessionSnapshotRuntime.getSpecialScreenLayouts());
        }
        return arrayList;
    }

    void addAdditionalObject(SessionObject sessionObject) {
        this.additionalObjects.add(sessionObject);
    }

    private class SessionSnapshotModel
    extends AbstractHangingSnapshotModel {
        private SessionSnapshotModel() {
        }

        @Override
        public int size() {
            return Session.this.getSnapshotCount();
        }

        @Override
        public AbstractSnapshotRuntime get(int n) {
            return Session.this.getSnapshot(n);
        }

        @Override
        public AbstractSnapshotRuntime get(String string) {
            return Session.this.getSnapshot(string);
        }

        @Override
        public AbstractSnapshotRuntime remove(int n) {
            AbstractSnapshotRuntime abstractSnapshotRuntime = this.get(n);
            this.delete(n);
            return abstractSnapshotRuntime;
        }

        @Override
        public void update(int n) {
            SessionSnapshotRuntime sessionSnapshotRuntime = Session.this.getSnapshot(n);
            sessionSnapshotRuntime.capture();
            Session.this.removeUnusedSetLiveSCs();
            Session.this.isSaved = false;
            this.fireUpdateEvent(n);
        }

        @Override
        public void delete(int n) {
            Session.this.removeSnapshot(n);
            this.fireRemoveEvent(n);
        }

        @Override
        public void insertAt(int n, AbstractSnapshotRuntime abstractSnapshotRuntime) {
            if (abstractSnapshotRuntime instanceof SessionSnapshotRuntime) {
                n = Session.this.addSnap(n, (SessionSnapshotRuntime)abstractSnapshotRuntime);
                this.fireAddEvent(n, abstractSnapshotRuntime);
            }
        }

        @Override
        public void add(AbstractSnapshotRuntime abstractSnapshotRuntime) {
            this.insertAt(-1, abstractSnapshotRuntime);
        }

        @Override
        public SessionSnapshotRuntime newInstance() {
            return Session.this.captureSnapshot();
        }

        @Override
        public AbstractSnapshotRuntime findSnapshot(AbstractSnapshotRuntime abstractSnapshotRuntime) {
            return Session.this.findSnap(abstractSnapshotRuntime);
        }
    }

    private class SessionStudyContainer
    extends AbstractStudyContainer {
        public SessionStudyContainer() {
            this.baseStudy = Session.this.getSessionBaseStudy();
        }

        @Override
        public IPatientRepresentation getPatientRepresentation() {
            return Session.this.patientRepresentation;
        }

        @Override
        public int getRelevantPriorCount() {
            return 0;
        }

        @Override
        public int getLoadedPriorCount() {
            return 0;
        }

        @Override
        public boolean hasStudy(String string) {
            return Session.this.splitAndSortRuntime.hasStudies(string);
        }

        @Override
        public boolean isPriorLoaded(int n) {
            return true;
        }

        @Override
        public IStudyData loadRelevantPrior(int n) {
            return null;
        }

        @Override
        public void setPatientRepresentation(IPatientRepresentation iPatientRepresentation) {
        }

        @Override
        public IStudyInfo getPriorInfo(int n) {
            return null;
        }

        @Override
        public void updateLoadedPriors(Set<String> set) {
        }

        @Override
        public int getIndexOfStudy(String string) {
            return Session.this.getStudyOrdering(string);
        }

        @Override
        public StudyType getStudyType(String string) {
            if (DATA_MANAGER.isStudyMerged(DATA_MANAGER.getStudy(string))) {
                return StudyType.MERGED;
            }
            return StudyType.getStudyType(this.getIndexOfStudy(string));
        }
    }
}

