/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.presentationstate;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.presentationstate.IPresentationState;
import com.agfa.pacs.impaxee.presentationstate.SharedSoftcopyPS;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.lut.IRescaleSlopeInterceptProvider;
import com.agfa.pacs.listtext.dicomobject.module.equipment.GeneralEquipmentModule;
import com.agfa.pacs.listtext.dicomobject.module.general.SOPCommonModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedAreaModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayerModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationStateIdentificationModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.RescaleType;
import com.agfa.pacs.listtext.dicomobject.module.ps.SoftcopyPresentationLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.SoftcopyVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.SoftcopyVOILUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.module.series.GeneralSeriesModule;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPresentationStateObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PresentationStatePool {
    private static final ALogger log = ALogger.getLogger(PresentationStatePool.class);
    private List<PresentationState> psTable;
    private IStudyData studyData;
    private ISeriesData seriesData;
    private SoftcopyPresentationStateInformationObject seriesSPS;
    private boolean color;
    private String label;
    private String creator;
    private String description;
    private Date date;
    private final boolean isTemporary;

    PresentationStatePool(IStudyData iStudyData, boolean bl, String string, String string2, String string3, Date date, boolean bl2) {
        this.color = bl;
        this.studyData = iStudyData;
        this.psTable = new Vector<PresentationState>();
        this.label = string2;
        this.creator = string;
        this.description = string3;
        this.date = date;
        this.isTemporary = bl2;
    }

    private PresentationState check(int n, int n2, ModalityLUT modalityLUT, PresentationLUT presentationLUT, SpatialTransformationModule spatialTransformationModule, String string) {
        PresentationState presentationState2;
        for (PresentationState presentationState2 : this.psTable) {
            if (!presentationState2.equals(n, n2, modalityLUT, presentationLUT, spatialTransformationModule, string)) continue;
            return presentationState2;
        }
        presentationState2 = new PresentationState(n, n2, modalityLUT, presentationLUT, spatialTransformationModule, string);
        this.initPresentationState(presentationState2);
        this.psTable.add(presentationState2);
        return presentationState2;
    }

    public IStudyData getStudyData() {
        return this.studyData;
    }

    public List<SoftcopyPresentationStateInformationObject> getPresentationStateObjects() {
        Vector<SoftcopyPresentationStateInformationObject> vector = new Vector<SoftcopyPresentationStateInformationObject>();
        for (PresentationState presentationState : this.psTable) {
            vector.add(presentationState.getPresentationStateObject());
        }
        return vector;
    }

    public List<IObjectData> getObjectDatas() {
        Vector<IObjectData> vector = new Vector<IObjectData>();
        for (PresentationState presentationState : this.psTable) {
            vector.add(presentationState.getObjectData());
        }
        return vector;
    }

    public void storeInStudy(boolean bl, int n) {
        if (this.studyData == null) {
            log.error("studyData in " + this.getClass().getName() + "[" + this.date + ", " + this.description + ", " + this.creator + "] is null! Omitting storing PR in study.");
            return;
        }
        for (PresentationState presentationState : this.psTable) {
            this.studyData.getFramePresentationStateProviderContainer().add(presentationState.getPresentationStateObject(), bl, n);
        }
    }

    void addPresentationState(IPresentationState iPresentationState) {
        Object object;
        String string = iPresentationState.getSeriesInstanceUID();
        ReferencedImage referencedImage = iPresentationState.createReferencedImage();
        ModalityLUT modalityLUT = iPresentationState.getModalityLUT();
        PresentationLUT presentationLUT = iPresentationState.getPresentationLUT();
        IVOILUT iVOILUT = iPresentationState.getVOILUT(this.isTemporary);
        if (iPresentationState.isIndexedColor()) {
            this.color = true;
        }
        int n = iPresentationState.getRows();
        int n2 = iPresentationState.getColumns();
        if (modalityLUT != null && referencedImage.getSOPClassUID().equals("1.2.840.10008.5.1.4.1.1.2")) {
            modalityLUT = new ModalityLUT((IRescaleSlopeInterceptProvider)modalityLUT);
            modalityLUT.setRescaleType(RescaleType.HounsfieldUnits);
        }
        SpatialTransformationModule spatialTransformationModule = iPresentationState.createSpatialTransformationModule();
        PresentationState presentationState = this.check(n, n2, modalityLUT, presentationLUT, spatialTransformationModule, null);
        SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject = presentationState.getPresentationStateObject();
        softcopyPresentationStateInformationObject.setForceIndexedColorLUT(this.color);
        softcopyPresentationStateInformationObject.addReference(string, referencedImage);
        Object object2 = iPresentationState.createDisplayedArea();
        if (object2 != null) {
            object = (DisplayedAreaModule)softcopyPresentationStateInformationObject.getModuleCreate(DisplayedAreaModule.class);
            boolean bl = false;
            for (Object object3 : object.displayedAreas()) {
                if (!object3.equals(object2)) continue;
                object2 = object3;
                bl = true;
                break;
            }
            if (!bl) {
                object.displayedAreas().add(object2);
            }
            ReferencedImage.addReference((Map)object2.referencedImages(), (ReferencedImage)referencedImage);
        }
        if (iVOILUT != null) {
            object = (SoftcopyVOILUTModule)softcopyPresentationStateInformationObject.getModuleCreate(SoftcopyVOILUTModule.class);
            Object object4 = null;
            for (Object object3 : object.softcopyVOILUTs()) {
                if (!object3.getVOILUT().equals(iVOILUT)) continue;
                object4 = object3;
                break;
            }
            if (object4 == null) {
                object4 = new SoftcopyVOILUT();
                object4.setVOILUT(iVOILUT);
                object.softcopyVOILUTs().add(object4);
            }
            ReferencedImage.addReference((Map)object4.referencedImages(), (ReferencedImage)referencedImage);
        }
        if ((object = iPresentationState.getGraphicAnnotations(((GraphicLayerModule)softcopyPresentationStateInformationObject.getModuleCreate(GraphicLayerModule.class)).graphicLayers(), !this.isTemporary)) != null) {
            Object object3;
            object3 = object.iterator();
            while (object3.hasNext()) {
                GraphicAnnotation graphicAnnotation = (GraphicAnnotation)object3.next();
                ReferencedImage.addReference((Map)graphicAnnotation.referencedImages(), (ReferencedImage)referencedImage);
                ((GraphicAnnotationModule)softcopyPresentationStateInformationObject.getModuleCreate(GraphicAnnotationModule.class)).graphicAnnotations().add(graphicAnnotation);
            }
        }
    }

    private static String getClassUID(boolean bl) {
        return bl ? "1.2.840.10008.5.1.4.1.1.11.3" : "1.2.840.10008.5.1.4.1.1.11.1";
    }

    private void initPresentationState(PresentationState presentationState) {
        try {
            if (this.seriesData == null) {
                this.seriesData = this.studyData.createSeriesData("PR");
                if (this.isTemporary) {
                    this.studyData.getQueryObject().removeChild(this.seriesData.getQueryObject());
                    this.seriesData.getDicomObject().remove(0x200011);
                }
            }
            String string = PresentationStatePool.getClassUID(this.color);
            IPresentationStateObjectData iPresentationStateObjectData = this.seriesData.createObjectData(IPresentationStateObjectData.class, string, "1.2.840.10008.1.2.1");
            presentationState.setObjectData(iPresentationStateObjectData);
            if (this.seriesSPS == null) {
                String string2;
                SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject = (SoftcopyPresentationStateInformationObject)iPresentationStateObjectData.getDicomInformationObject();
                PresentationStateIdentificationModule presentationStateIdentificationModule = (PresentationStateIdentificationModule)softcopyPresentationStateInformationObject.getModuleCreate(PresentationStateIdentificationModule.class);
                presentationStateIdentificationModule.setContentCreatorsName(this.creator);
                presentationStateIdentificationModule.setContentDescription(this.description);
                presentationStateIdentificationModule.setContentLabel(this.label);
                presentationStateIdentificationModule.setPresentationCreationDateTime(this.date);
                GeneralEquipmentModule generalEquipmentModule = (GeneralEquipmentModule)softcopyPresentationStateInformationObject.getModuleCreate(GeneralEquipmentModule.class);
                if (Config.impaxee.jvision.DISPLAY.UseUniqueStationNameForPR.get() && (string2 = this.getStationName()) != null) {
                    generalEquipmentModule.setStationName(string2);
                }
                generalEquipmentModule.setManufacturer(Product.getProductVendor());
                generalEquipmentModule.setManufacturerModelName(Product.getProductName());
                generalEquipmentModule.setSoftwareVersions(new String[]{Product.getVersionString()});
                string2 = this.description != null && this.description.length() > 0 ? this.description : this.label;
                GeneralSeriesModule generalSeriesModule = (GeneralSeriesModule)softcopyPresentationStateInformationObject.getModuleCreate(GeneralSeriesModule.class);
                generalSeriesModule.setSeriesDate(this.date);
                generalSeriesModule.setSeriesDescription(string2);
                this.seriesSPS = softcopyPresentationStateInformationObject;
            }
            presentationState.setParentPresentationStateObject(this.seriesSPS);
        }
        catch (Exception exception) {
            log.error("PresentationStatePool", (Throwable)exception);
        }
    }

    private String getStationName() {
        List<ISeriesData> list = this.seriesData.getParent().getSeries();
        String string = null;
        for (ISeriesData iSeriesData : list) {
            if (iSeriesData.getNumberOfFrames() <= 0) continue;
            String string2 = iSeriesData.getDicomObject().getString(528400);
            if (string == null) {
                string = string2;
                continue;
            }
            if (string.equals(string2)) continue;
            return null;
        }
        if (string != null && string.isEmpty()) {
            return null;
        }
        return string;
    }

    private static class PresentationState {
        private int rows;
        private int columns;
        private ModalityLUT modalityLUT;
        private PresentationLUT presentationLUT;
        private SpatialTransformationModule stm;
        private String instanceUID;
        private SoftcopyPresentationStateInformationObject sps = null;
        private IObjectData objectData;
        private SoftcopyPresentationStateInformationObject parentSPS;

        public PresentationState(int n, int n2, ModalityLUT modalityLUT, PresentationLUT presentationLUT, SpatialTransformationModule spatialTransformationModule, String string) {
            this.stm = spatialTransformationModule;
            this.rows = n;
            this.columns = n2;
            this.modalityLUT = modalityLUT;
            this.presentationLUT = presentationLUT;
            this.instanceUID = string;
        }

        public boolean equals(int n, int n2, ModalityLUT modalityLUT, PresentationLUT presentationLUT, SpatialTransformationModule spatialTransformationModule, String string) {
            if (!CompareUtils.equals((Object)this.instanceUID, (Object)string)) {
                return false;
            }
            if (this.rows != n) {
                return false;
            }
            if (this.columns != n2) {
                return false;
            }
            if (!CompareUtils.equals((Object)spatialTransformationModule, (Object)this.stm)) {
                return false;
            }
            if (!CompareUtils.equals((Object)this.modalityLUT, (Object)modalityLUT)) {
                return false;
            }
            return CompareUtils.equals((Object)this.presentationLUT, (Object)presentationLUT);
        }

        public SoftcopyPresentationStateInformationObject getPresentationStateObject() {
            if (this.sps == null) {
                SharedSoftcopyPS sharedSoftcopyPS = new SharedSoftcopyPS(this.parentSPS);
                sharedSoftcopyPS.init(true);
                sharedSoftcopyPS.getModuleCreate(SOPCommonModule.class, this.objectData.getDicomObject());
                if (this.modalityLUT != null) {
                    sharedSoftcopyPS.getModuleCreate(ModalityLUTModule.class).setModalityLUT(this.modalityLUT);
                }
                if (this.presentationLUT != null) {
                    sharedSoftcopyPS.getModuleCreate(SoftcopyPresentationLUTModule.class).setPresentationLUT(this.presentationLUT);
                }
                if (this.stm != null) {
                    sharedSoftcopyPS.getModuleCreate(SpatialTransformationModule.class).copy(this.stm);
                }
                this.parentSPS = null;
                this.sps = sharedSoftcopyPS;
            }
            return this.sps;
        }

        public void setParentPresentationStateObject(SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject) {
            this.parentSPS = softcopyPresentationStateInformationObject;
        }

        public void setObjectData(IObjectData iObjectData) {
            this.objectData = iObjectData;
        }

        public IObjectData getObjectData() {
            this.objectData.initFromDicomObject(this.sps.toDataset());
            return this.objectData;
        }
    }
}

