/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.PluginKeeper;
import java.util.ArrayList;
import java.util.List;

abstract class PluginFactory {
    private static PluginFactory implementation;

    static synchronized PluginFactory getInstance() {
        if (implementation == null) {
            PluginFactory.initialize();
        }
        return implementation;
    }

    List<PluginKeeper> getPluginKeeper() {
        return implementation.getPluginsInt();
    }

    List<IPlugin> getPlugins() {
        ArrayList<IPlugin> arrayList = new ArrayList<IPlugin>();
        for (PluginKeeper pluginKeeper : implementation.getPluginsInt()) {
            arrayList.add(pluginKeeper.getPlugin());
        }
        return arrayList;
    }

    protected abstract List<PluginKeeper> getPluginsInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)PluginFactory.class.getName()));
            implementation = (PluginFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + PluginFactory.class.getName(), reflectiveOperationException);
        }
    }
}

