/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.plugin;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.agfa.pacs.impaxee.utils.IconFactory;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.util.TIcon;
import com.tiani.jvision.main.AbstractToolBarTabPanel;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.TabDefRecord;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toolbox.PluginToolbox;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public abstract class AbstractPlugin
implements IPlugin {
    protected final ALogger log = ALogger.getLogger(this.getClass());
    private IconFactory iconFactory = new IconFactory(new String[]{"/icons"});
    private PIcon icon;
    private List<TabDefRecord> pluginPanelDefinitions;
    private boolean hasContext = false;

    public AbstractPlugin() {
        this.registerActions();
    }

    @Override
    public PIcon getIcon() {
        if (this.icon == null) {
            IconDefinition iconDefinition = this.getIconDefinition();
            this.icon = IAIconFactory.DEFAULT_FACTORY.loadIcon(iconDefinition.definingClass, iconDefinition.iconName);
        }
        return this.icon;
    }

    @Override
    public TIcon loadIcon(String string) {
        Image image = this.loadImage(string);
        return image != null ? new TIcon(image, string) : null;
    }

    @Override
    public PIcon loadPIcon(String string, int n) {
        IAIconFactory iAIconFactory = new IAIconFactory(n);
        return iAIconFactory.loadIcon(this.getClass(), string);
    }

    private Image loadImage(String string) {
        try {
            URL uRL = this.iconFactory.getResource(string, this.getClass());
            return Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            this.log.error("Cannot load icon " + string, (Throwable)exception);
            return null;
        }
    }

    @Override
    public String getRequiredHardwareID() {
        return null;
    }

    @Override
    public boolean isForDiagnosticWorkstation() {
        return true;
    }

    @Override
    public String getVersion() {
        return Product.getVersionString();
    }

    @Override
    public void registerActions() {
    }

    @Override
    public boolean isSelectionMaster() {
        return false;
    }

    @Override
    public boolean noDisplayPlugin() {
        return false;
    }

    @Override
    public boolean toolboxMandatory() {
        return false;
    }

    @Override
    public boolean showToolboxAtStart() {
        return true;
    }

    public void cleanUp() {
    }

    @Override
    public IDisplayPlugin createDisplayPlugin(VisDisplayData visDisplayData) {
        return null;
    }

    @Override
    public void contextGained() {
        if (this.hasContext) {
            return;
        }
        if (VisData.getLastModified() == null) {
            return;
        }
        IDisplayPlugin iDisplayPlugin = VisData.getLastModified().getParent().getDisplayPlugin();
        this.pluginPanelDefinitions = iDisplayPlugin.getTabRecords();
        if (this.pluginPanelDefinitions == null) {
            return;
        }
        JComponent jComponent = this.getPluginPanels();
        this.manageToolboxOnContextGained(jComponent);
        JVision2.getMainFrame().getPluginToolbox().setDialogHideable(!this.toolboxMandatory());
        this.hasContext = true;
    }

    @Override
    public void contextLost() {
        if (!this.hasContext) {
            return;
        }
        this.hasContext = false;
        this.manageToolboxOnContextLost();
    }

    private JComponent getPluginPanels() {
        JTabbedPane jTabbedPane = null;
        for (TabDefRecord tabDefRecord : this.pluginPanelDefinitions) {
            JComponent jComponent = (JComponent)((Object)tabDefRecord.tabComp);
            if (jComponent == null) continue;
            if (jTabbedPane == null) {
                jTabbedPane = ComponentFactory.instance.createTabbedPane();
            }
            jTabbedPane.addTab(tabDefRecord.tabTitle, jComponent);
        }
        return jTabbedPane;
    }

    private void manageToolboxOnContextGained(JComponent jComponent) {
        PluginToolbox pluginToolbox = JVision2.getMainFrame().getPluginToolbox();
        Container container = pluginToolbox.getPluginContainer();
        container.removeAll();
        if (jComponent != null) {
            container.add(jComponent);
            container.revalidate();
            VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
            if (visDisplay2 != null) {
                pluginToolbox.attachToDisplayOnContextGained(visDisplay2);
            }
        } else {
            pluginToolbox.setDialogVisible(false);
        }
    }

    private void manageToolboxOnContextLost() {
        PluginToolbox pluginToolbox = JVision2.getMainFrame().getPluginToolbox();
        Container container = pluginToolbox.getPluginContainer();
        pluginToolbox.saveDialogState();
        container.removeAll();
        pluginToolbox.setDialogVisible(false);
    }

    @Override
    public AbstractToolBarTabPanel[] getTopToolBarComponents() {
        return null;
    }

    @Override
    public String[] getTopToolBarComponentTitles() {
        return null;
    }

    @Override
    public String getActionID() {
        return PluginActions.getPluginActionID(this.getPluginName());
    }

    @Override
    public abstract PluginName getPluginName();

    @Override
    public String getName() {
        return this.getPluginName().getPluginName();
    }

    @Override
    public String getDescription() {
        return this.getPluginName().getCaption();
    }
}

