/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.mousemodeinfo;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfoListener;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeFillActionProvider;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeFillGroupAction;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeGroupAction;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeInfoGlobal;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MouseModeActionProvider
implements PActionProvider {
    private IMouseModeInfo mouseMode = MouseModeInfoGlobal.getInstance();
    private static final String ID_PREFIX = "MOUSE_MODE_";
    public static final String NORMAL_MOUSE_MODE = "MOUSE_MODE_NORMAL";
    private static final List<MouseSubModes> CD_VIEWER_ACTIONS = Arrays.asList(MouseSubModes.MEASURE_DISTANCE, MouseSubModes.MEASURE_ANGLE, MouseSubModes.DRAW_ARROW, MouseSubModes.DRAW_TEXT, MouseSubModes.DRAW_CIRCLE, MouseSubModes.DRAW_RECTANGLE, MouseSubModes.DRAW_POLYGON, MouseSubModes.DRAW_SPLINECURVE);
    private static List<PAction> toBeNotifiedActions = new ArrayList<PAction>();
    private static PAction groupAction;

    public static String getIDForMode(MouseSubModes mouseSubModes) {
        return ID_PREFIX + mouseSubModes.name();
    }

    public static void registerMouseModeAction(PAction pAction) {
        toBeNotifiedActions.add(pAction);
    }

    private String getIconImpl(MouseSubModes mouseSubModes) {
        return String.valueOf(mouseSubModes.name()) + ".svg";
    }

    private void modeChanged() {
        groupAction.forcedSelectionChanged();
        for (PAction pAction : toBeNotifiedActions) {
            pAction.fireSelectionChanged();
        }
    }

    void handleEscape() {
        this.mouseMode.handleEscape();
        if (JVision2.getMainFrame() != null) {
            for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                IMouseModeInfo iMouseModeInfo = visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
                if (this.mouseMode == iMouseModeInfo) continue;
                iMouseModeInfo.handleEscape();
            }
        }
    }

    public static List<MouseSubModes> getUsableEnums() {
        ArrayList<MouseSubModes> arrayList = new ArrayList<MouseSubModes>();
        arrayList.add(MouseSubModes.DRAW_CIRCLE);
        int n = MouseSubModes.MEASURE_DISTANCE.ordinal();
        while (n <= MouseSubModes.RIGHT.ordinal()) {
            if (n != MouseSubModes.DRAW_CIRCLE.ordinal()) {
                arrayList.add(MouseSubModes.values()[n]);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        for (MouseSubModes object2 : MouseModeActionProvider.getUsableEnums()) {
            arrayList.add(new MouseModeAction(object2));
        }
        ArrayList<PAction> arrayList2 = new ArrayList<PAction>();
        arrayList2.addAll(new MouseModeFillActionProvider().getActions());
        MouseModeFillGroupAction mouseModeFillGroupAction = new MouseModeFillGroupAction(arrayList2);
        toBeNotifiedActions.addAll(arrayList);
        groupAction = new MouseModeGroupAction(new ArrayList<PAction>(arrayList), mouseModeFillGroupAction);
        arrayList.add(groupAction);
        arrayList.addAll(arrayList2);
        arrayList.add(mouseModeFillGroupAction);
        this.mouseMode.addMouseModeInfoListener(new MouseModeListener());
        arrayList.add(new ExitMouseModeAction());
        return arrayList;
    }

    private class ExitMouseModeAction
    extends AbstractPAction {
        private ExitMouseModeAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_EDIT_NORMAL_MODE");
        }

        @Override
        public String getGroupName() {
            return "INTERNAL";
        }

        @Override
        public String getID() {
            return MouseModeActionProvider.NORMAL_MOUSE_MODE;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_EDIT_NORMAL_MODE_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            MouseModeActionProvider.this.handleEscape();
            return true;
        }
    }

    private class MouseModeAction
    extends SelectablePAction {
        private MouseSubModes mode;

        public MouseModeAction(MouseSubModes mouseSubModes) {
            super(MouseModeActionProvider.this.getIconImpl(mouseSubModes));
            this.mode = mouseSubModes;
        }

        @Override
        public boolean isAvailable() {
            return !Product.isCDViewer() || CD_VIEWER_ACTIONS.contains((Object)this.mode);
        }

        @Override
        protected boolean isEnabledImpl() {
            return !PresentationObject.isHideAllROIs();
        }

        @Override
        public boolean isSelected() {
            return MouseModeActionProvider.this.mouseMode.getSubMode() == this.mode;
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_ROIS_" + this.mode.name());
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            switch (this.mode) {
                case MEASURE_ANGLE: {
                    return new KeyShortcut(65, 2);
                }
                case DRAW_SPLINECURVE: {
                    return new KeyShortcut(70, 2);
                }
                case DRAW_RECTANGLE: {
                    return new KeyShortcut(82, 2);
                }
                case DRAW_CIRCLE: {
                    return new KeyShortcut(67);
                }
                case DRAW_TEXT: {
                    return new KeyShortcut(84);
                }
                case DRAW_ARROW: {
                    return new KeyShortcut(65, 10);
                }
                case MEASURE_DISTANCE: {
                    return new KeyShortcut(76);
                }
            }
            return null;
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getID() {
            return MouseModeActionProvider.getIDForMode(this.mode);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_ROIS_" + this.mode.name() + "_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MouseSubModes mouseSubModes = this.mode;
            if (this.isSelected()) {
                MouseModeActionProvider.this.handleEscape();
                return true;
            }
            MouseModeActionProvider.this.mouseMode.setSubMode(mouseSubModes);
            for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                IMouseModeInfo iMouseModeInfo = visDisplay2.getData().getDisplayPlugin().getMouseModeInfo();
                if (MouseModeActionProvider.this.mouseMode == iMouseModeInfo) continue;
                iMouseModeInfo.setSubMode(mouseSubModes);
            }
            return true;
        }
    }

    private class MouseModeListener
    implements IMouseModeInfoListener {
        private MouseModeListener() {
        }

        @Override
        public void mouseModeChanged() {
            MouseModeActionProvider.this.modeChanged();
        }

        @Override
        public void hotregionOutsideModeChanged(boolean bl) {
        }
    }
}

