/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.keyimages;

import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.keyimages.KeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.utils.ConcurrentMultiValueHashMap;
import com.agfa.pacs.impaxee.utils.IConcurrentMultiValueMap;
import com.agfa.pacs.impaxee.xds.source.IXDSDocumentSource;
import com.agfa.pacs.impaxee.xds.source.XDSDocumentSourceException;
import com.agfa.pacs.impaxee.xds.source.XDSDocumentSourceFactory;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.lta.deletion.DeletionUtils;
import com.agfa.pacs.listtext.lta.store.StoreUtils;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectAttributes;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.util.message.Message;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.Pair;
import org.dcm4che3.data.Attributes;

public class KeyImageManager {
    private static ALogger log = ALogger.getLogger(KeyImageManager.class);
    private static KeyImageManager instance;
    private Map<IFrameObjectData, KeyImageInfo> infoMap = new ConcurrentHashMap<IFrameObjectData, KeyImageInfo>();
    private final IConcurrentMultiValueMap<Pair<IStudyData, KeyImageType>, ReferringObject> referringObjectsByStudy = new ConcurrentMultiValueHashMap<Pair<IStudyData, KeyImageType>, ReferringObject>();
    private final Set<IStudyData> studiesInEditMode = new CopyOnWriteArraySet<IStudyData>();

    private KeyImageManager() {
        DataManager.getInstance().addListener(new PatientRemovalListener());
    }

    public static synchronized KeyImageManager getInstance() {
        if (instance == null) {
            instance = new KeyImageManager();
        }
        return instance;
    }

    public boolean isEmpty() {
        return this.infoMap.isEmpty();
    }

    public boolean isMarked(IFrameObjectData iFrameObjectData) {
        return this.infoMap.containsKey(iFrameObjectData) ? this.infoMap.get(iFrameObjectData).isMarked() : false;
    }

    public KeyImageInfo getKeyInfo(IFrameObjectData iFrameObjectData) {
        return this.infoMap.get(iFrameObjectData);
    }

    public boolean isMarked(IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        return this.infoMap.containsKey(iFrameObjectData) ? this.infoMap.get(iFrameObjectData).isMarked(keyImageType) : false;
    }

    public boolean isModified(IFrameObjectData iFrameObjectData) {
        return this.infoMap.containsKey(iFrameObjectData) ? this.infoMap.get(iFrameObjectData).isModified() : false;
    }

    public boolean isModifiable(IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        return this.infoMap.containsKey(iFrameObjectData) ? this.infoMap.get(iFrameObjectData).isModifiable(keyImageType) : true;
    }

    public boolean hasKeyImages(IStudyData iStudyData) {
        for (Map.Entry<IFrameObjectData, KeyImageInfo> entry : this.infoMap.entrySet()) {
            if (!iStudyData.getKey().equals(entry.getKey().getParent().getParent().getKey()) || !entry.getValue().isMarked()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSavedKeyImages(IStudyData iStudyData) {
        for (Map.Entry<IFrameObjectData, KeyImageInfo> entry : this.infoMap.entrySet()) {
            if (!iStudyData.getKey().equals(entry.getKey().getParent().getParent().getKey()) || !entry.getValue().isInitiallyMarked()) continue;
            return true;
        }
        return false;
    }

    public List<IFrameObjectData> getKeyImagesOfStudy(IStudyData iStudyData) {
        return this.getKeyImagesOfStudy(iStudyData, null);
    }

    public List<IFrameObjectData> getKeyImagesOfStudy(IStudyData iStudyData, KeyImageType keyImageType) {
        ArrayList<IFrameObjectData> arrayList = null;
        for (Map.Entry<IFrameObjectData, KeyImageInfo> entry : this.infoMap.entrySet()) {
            boolean bl;
            if (!iStudyData.getKey().equals(entry.getKey().getParent().getParent().getKey())) continue;
            boolean bl2 = bl = keyImageType == null ? entry.getValue().isMarked() : entry.getValue().isMarked(keyImageType);
            if (!bl) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IFrameObjectData>();
            }
            arrayList.add(entry.getKey());
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public Integer getFirstMarked(IFrameObjectData[] iFrameObjectDataArray) {
        if (iFrameObjectDataArray != null) {
            int n = 0;
            while (n < iFrameObjectDataArray.length) {
                if (this.isMarked(iFrameObjectDataArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return null;
    }

    public Integer getLastMarked(IFrameObjectData[] iFrameObjectDataArray) {
        if (iFrameObjectDataArray != null) {
            int n = iFrameObjectDataArray.length - 1;
            while (n >= 0) {
                if (this.isMarked(iFrameObjectDataArray[n])) {
                    return n;
                }
                --n;
            }
        }
        return null;
    }

    public boolean hasUnsavedKeyImages(IStudyData iStudyData) {
        return this.getModifiedTypesOfStudy(iStudyData).length > 0;
    }

    public KeyImageType[] getModifiedTypesOfStudy(IStudyData iStudyData) {
        ArrayList<KeyImageType> arrayList = new ArrayList<KeyImageType>(KeyImageType.values().length);
        if (this.infoMap != null) {
            for (Map.Entry<IFrameObjectData, KeyImageInfo> entry : this.infoMap.entrySet()) {
                try {
                    if (!iStudyData.getKey().equals(entry.getKey().getParent().getParent().getKey())) continue;
                    KeyImageType[] keyImageTypeArray = KeyImageType.values();
                    int n = keyImageTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        KeyImageType keyImageType = keyImageTypeArray[n2];
                        if (!arrayList.contains((Object)keyImageType) && entry.getValue().isModified(keyImageType)) {
                            arrayList.add(keyImageType);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
            }
        }
        return arrayList.toArray(new KeyImageType[0]);
    }

    public void markInitially(ReferringObject referringObject, IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        KeyImageInfo keyImageInfo = this.infoMap.get(iFrameObjectData);
        if (keyImageInfo == null) {
            keyImageInfo = new KeyImageInfo();
            this.infoMap.put(iFrameObjectData, keyImageInfo);
        }
        keyImageInfo.markInitially(keyImageType);
        this.getReferringObjects(iFrameObjectData.getParent().getParent(), keyImageType).add(referringObject);
    }

    public void mark(IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        if (!this.isEditable(iFrameObjectData.getParent().getParent())) {
            return;
        }
        KeyImageInfo keyImageInfo = this.infoMap.get(iFrameObjectData);
        if (keyImageInfo == null) {
            keyImageInfo = new KeyImageInfo();
            this.infoMap.put(iFrameObjectData, keyImageInfo);
        }
        keyImageInfo.mark(keyImageType);
    }

    public void unmark(IFrameObjectData iFrameObjectData, KeyImageType keyImageType) {
        if (!this.isEditable(iFrameObjectData.getParent().getParent())) {
            return;
        }
        KeyImageInfo keyImageInfo = this.infoMap.get(iFrameObjectData);
        if (keyImageInfo == null) {
            return;
        }
        keyImageInfo.unmark(keyImageType);
    }

    public boolean isInEditMode(IStudyData iStudyData) {
        return this.studiesInEditMode.contains(iStudyData);
    }

    public void startEditMode(IStudyData iStudyData) {
        this.studiesInEditMode.add(iStudyData);
    }

    private void stopEditMode(IStudyData iStudyData) {
        this.studiesInEditMode.remove(iStudyData);
    }

    private boolean isEditable(IStudyData iStudyData) {
        if (this.isInEditMode(iStudyData)) {
            return true;
        }
        if (!this.hasKeyImages(iStudyData) || Message.yesNo(Messages.getString("KeyImageManager.StartEditMode.Query")) == 0) {
            this.startEditMode(iStudyData);
            return true;
        }
        return false;
    }

    public boolean save(IStudyData iStudyData, KeyImageType keyImageType, boolean bl) {
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>();
        for (Map.Entry<IFrameObjectData, KeyImageInfo> entry : this.infoMap.entrySet()) {
            if (!iStudyData.getKey().equals(entry.getKey().getParent().getParent().getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return this.save(iStudyData, arrayList, keyImageType, bl);
    }

    private boolean save(IStudyData iStudyData, List<IFrameObjectData> list, KeyImageType keyImageType, boolean bl) {
        boolean bl2;
        KeyImageInfo keyImageInfo;
        ArrayList<IFrameObjectData> arrayList = new ArrayList<IFrameObjectData>(list.size());
        ArrayList<KeyImageInfo> arrayList2 = new ArrayList<KeyImageInfo>(list.size());
        for (IFrameObjectData object22 : list) {
            keyImageInfo = this.infoMap.get(object22);
            if (keyImageInfo == null) continue;
            if (keyImageInfo.isModified(keyImageType)) {
                arrayList2.add(keyImageInfo);
            }
            if (!keyImageType.isModifiable()) continue;
            if (keyImageInfo.isMarked(keyImageType)) {
                arrayList.add(object22);
            }
            if (!keyImageInfo.isInitiallyMarked(keyImageType)) continue;
            arrayList2.add(keyImageInfo);
        }
        Set<ReferringObject> set = this.getReferringObjects(iStudyData, keyImageType);
        ArrayList<ReferringObject> arrayList3 = new ArrayList<ReferringObject>(set);
        keyImageInfo = null;
        if (!arrayList.isEmpty()) {
            bl2 = false;
            if (keyImageType == KeyImageType.ForXDS) {
                keyImageInfo = this.compileKeyObject(KeyImageType.ForXDS, iStudyData, new ArrayList<IFrameObjectData>(arrayList));
                IXDSDocumentSource exception = XDSDocumentSourceFactory.getInstance();
                try {
                    bl2 = exception.provideAndRegister(keyImageInfo.toDataset());
                }
                catch (XDSDocumentSourceException xDSDocumentSourceException) {
                    log.error("Exception during XDS provide and register", (Throwable)xDSDocumentSourceException);
                }
            } else {
                keyImageInfo = this.compileKeyObject(keyImageType, iStudyData, new ArrayList<IFrameObjectData>(arrayList));
                bl2 = StoreUtils.storeObjects((IDataInfoSource)iStudyData.getQueryObject().getSource(), (Attributes[])new Attributes[]{keyImageInfo.toDataset()});
            }
            if (!bl2) {
                if (bl) {
                    if (!ComponentFactory.instance.showYesNoDialog(Messages.getString("KeyImageManager.storeErrorTitle"), Messages.getString("KeyImageManager.storeErrorMessage"), null)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        bl2 = true;
        if (!arrayList3.isEmpty()) {
            try {
                bl2 = DeletionUtils.deleteInstances((List)ReferencedObjectUtilities.extractReferencedObjects((Collection)arrayList3));
                if (bl2) {
                    set.removeAll(arrayList3);
                }
            }
            catch (Exception exception) {
                log.error("Deletion of key object(s) failed.", (Throwable)exception);
                bl2 = false;
            }
        }
        for (KeyImageInfo keyImageInfo2 : arrayList2) {
            keyImageInfo2.resetModified(keyImageType);
        }
        if (keyImageInfo != null) {
            ReferringObject referringObject = new ReferringObject(keyImageType.getType(), keyImageInfo.toObjectInfo());
            set.add(referringObject);
            for (Object object : arrayList) {
                this.markInitially(referringObject, (IFrameObjectData)object, keyImageType);
            }
        }
        this.stopEditMode(iStudyData);
        return bl2;
    }

    public static boolean storeKeyObjects(IStudyData iStudyData, KeyImageType keyImageType, Set<ReferencedImage> set) {
        ISeriesData iSeriesData22;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ISeriesData iSeriesData22 : iStudyData.getSeries()) {
            for (IImageObjectData object : iSeriesData22.getObjects()) {
                hashMap.put(object.getSOPInstanceUID(), iSeriesData22.getSeriesInstanceUID());
            }
        }
        iSeriesData22 = new KeyObjectAttributes(keyImageType.getType(), (IStudyInfo)iStudyData.getQueryObject());
        for (ReferencedImage referencedImage : set) {
            Object object = referencedImage.getFrames();
            iSeriesData22.insertReference(referencedImage.getSOPClassUID(), referencedImage.getSOPInstanceUID(), (String)hashMap.get(referencedImage.getSOPInstanceUID()), iStudyData.getStudyInstanceUID(), (int[])object);
        }
        boolean bl = StoreUtils.storeObjects((IDataInfoSource)iStudyData.getQueryObject().getSource(), (Attributes[])new Attributes[]{iSeriesData22.toDataset()});
        return bl;
    }

    private KeyObjectAttributes compileKeyObject(KeyImageType keyImageType, IStudyData iStudyData, List<IFrameObjectData> list) {
        Object object;
        KeyObjectAttributes keyObjectAttributes = new KeyObjectAttributes(keyImageType.getType(), (IStudyInfo)iStudyData.getQueryObject());
        HashMap<IImageObjectData, Object> hashMap = new HashMap<IImageObjectData, Object>(list.size());
        for (IFrameObjectData object2 : list) {
            if (object2.getMainFrame().getFrameCount() == 1) {
                hashMap.put(object2.getMainFrame(), null);
                continue;
            }
            object = (BitSet)hashMap.get(object2.getMainFrame());
            if (object == null) {
                object = new BitSet();
                hashMap.put(object2.getMainFrame(), object);
            }
            ((BitSet)object).set(object2.getFrameNumber() + 1);
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (IImageObjectData)entry.getKey();
                BitSet bitSet = (BitSet)entry.getValue();
                int[] nArray = null;
                if (bitSet != null) {
                    nArray = new int[bitSet.cardinality()];
                    int n = 0;
                    while (n < nArray.length) {
                        nArray[n] = bitSet.nextSetBit(n == 0 ? 0 : nArray[n - 1] + 1);
                        ++n;
                    }
                }
                keyObjectAttributes.insertReference(object.getSOPClassUID(), object.getSOPInstanceUID(), object.getParent().getSeriesInstanceUID(), object.getParent().getParent().getStudyInstanceUID(), nArray);
            }
        }
        return keyObjectAttributes;
    }

    private Set<ReferringObject> getReferringObjects(IStudyData iStudyData, KeyImageType keyImageType) {
        return this.referringObjectsByStudy.getOrCreate((Pair<IStudyData, KeyImageType>)Pair.of((Object)iStudyData, (Object)((Object)keyImageType)));
    }

    private class PatientRemovalListener
    extends DataManagerListenerAdapter {
        private PatientRemovalListener() {
        }

        @Override
        public void patientRemoved(IPatientRepresentation iPatientRepresentation) {
            this.updateInfoMap(iPatientRepresentation);
            this.updateReferringObjectsMap(iPatientRepresentation);
            this.updateEditModeSet(iPatientRepresentation);
        }

        private void updateInfoMap(IPatientRepresentation iPatientRepresentation) {
            if (KeyImageManager.this.infoMap.isEmpty() || iPatientRepresentation == null) {
                return;
            }
            Iterator iterator = KeyImageManager.this.infoMap.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    String string = ((IFrameObjectData)iterator.next()).getParent().getParent().getParent().getKey();
                    if (!iPatientRepresentation.getPatientKey().equals(string)) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    log.error("Error on removal handling", (Throwable)exception);
                    iterator.remove();
                }
            }
        }

        private void updateReferringObjectsMap(IPatientRepresentation iPatientRepresentation) {
            if (KeyImageManager.this.referringObjectsByStudy.isEmpty() || iPatientRepresentation == null) {
                return;
            }
            Iterator iterator = KeyImageManager.this.referringObjectsByStudy.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    String string = ((IStudyData)((Pair)iterator.next()).left).getParent().getKey();
                    if (!iPatientRepresentation.getPatientKey().equals(string)) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    log.error("Error on removal handling.", (Throwable)exception);
                    iterator.remove();
                }
            }
        }

        private void updateEditModeSet(IPatientRepresentation iPatientRepresentation) {
            if (KeyImageManager.this.studiesInEditMode.isEmpty() || iPatientRepresentation == null) {
                return;
            }
            for (IStudyData iStudyData : KeyImageManager.this.studiesInEditMode) {
                try {
                    String string = iStudyData.getParent().getKey();
                    if (!iPatientRepresentation.getPatientKey().equals(string)) continue;
                    KeyImageManager.this.stopEditMode(iStudyData);
                }
                catch (Exception exception) {
                    log.error("Error on removal handling, stopping edit mode for study: " + iStudyData, (Throwable)exception);
                    KeyImageManager.this.stopEditMode(iStudyData);
                }
            }
        }
    }
}

