/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.DefaultHangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.enums.DefaultHangingProtocolType;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.tiani.gui.dialog.IHideableDialogStateProvider;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;

public class MultiPatientHangingProtocolRuntime
extends HangingProtocolRuntime
implements IMultiplePatientHanging,
IDataManagerListener {
    private static final Icon ICON = IAIconFactory.DEFAULT_FACTORY.loadIcon("hangingcase_multiple_patient.svg");
    private List<IPatientRepresentation> patients = new ArrayList<IPatientRepresentation>(2);
    private IHideableDialogStateProvider hideableDialogStateProvider;

    public MultiPatientHangingProtocolRuntime(String string) {
        super(string);
        DefaultHangingProtocol defaultHangingProtocol2 = new DefaultHangingProtocol(DefaultHangingProtocolType.USER_DEFINED);
        this.setHangingDefinition(new HangingDefinitionRuntime(defaultHangingProtocol2.getHangingDefinition(), (HangingProtocolRuntime)this));
    }

    public void addPatient(IPatientRepresentation iPatientRepresentation) {
        if (!this.patients.contains(iPatientRepresentation)) {
            this.patients.add(iPatientRepresentation);
        }
    }

    @Override
    public void ensurePriorsLoaded() {
    }

    @Override
    public List<IDisplaySet> getDisplaySets() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public Collection<IPatientRepresentation> getPatients() {
        return Collections.unmodifiableCollection(this.patients);
    }

    @Override
    public ISplitAndSortRuntime getSplitAndSortRuntime() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            return iPatientRepresentation.getDecompositionRuntime();
        }
        return null;
    }

    @Override
    public IStudyContainer getStudyContainer() {
        return null;
    }

    public void removePatient(IPatientRepresentation iPatientRepresentation) {
        this.patients.remove(iPatientRepresentation);
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public void setSaved(boolean bl) {
    }

    @Override
    public boolean isSaved() {
        return true;
    }

    @Override
    public void patientRemoved(IPatientRepresentation iPatientRepresentation) {
        if (iPatientRepresentation.getDecompositionRuntime() != null) {
            this.displaySetsRemoved(iPatientRepresentation.getDecompositionRuntime().getDisplaySets());
        }
    }

    @Override
    public String getIdentifier() {
        return this.getVisibleName();
    }

    public IHideableDialogStateProvider getHideableDialogStateProvider() {
        if (this.hideableDialogStateProvider == null) {
            this.hideableDialogStateProvider = new MyHideableDialogStateProvider();
        }
        return this.hideableDialogStateProvider;
    }

    @Override
    public void hangingStateRemoved(IHanging iHanging) {
    }

    @Override
    public void patientAdded(IPatientRepresentation iPatientRepresentation) {
    }

    @Override
    public void patientRepresentationModified(IPatientRepresentation iPatientRepresentation) {
    }

    @Override
    public void patientsSorted(Comparator<IPatientRepresentation> comparator) {
    }

    private static class MyHideableDialogStateProvider
    implements IHideableDialogStateProvider {
        private boolean isVisible = true;

        private MyHideableDialogStateProvider() {
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        @Override
        public void setVisible(boolean bl) {
            this.isVisible = bl;
        }
    }
}

