/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.ILayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.Layout;
import com.agfa.pacs.impaxee.hanging.model.xml.ScreenLayout;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import java.util.ArrayList;
import java.util.List;

public class LayoutRuntime
implements ILayoutDefinition {
    private HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime;
    private MainLayoutType mainLayoutType;
    private List<ScreenLayoutRuntime> screenLayoutRuntimes = new ArrayList<ScreenLayoutRuntime>(2);

    public LayoutRuntime(Layout layout) {
        if (layout != null) {
            this.mainLayoutType = layout.getType();
            ScreenLayout[] screenLayoutArray = layout.screenLayouts();
            int n = screenLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenLayout screenLayout = screenLayoutArray[n2];
                this.addScreenLayoutRuntime(new ScreenLayoutRuntime(screenLayout));
                ++n2;
            }
        }
    }

    public LayoutRuntime(LayoutRuntime layoutRuntime) {
        this.mainLayoutType = layoutRuntime.getType();
        ScreenLayoutRuntime[] screenLayoutRuntimeArray = layoutRuntime.screenLayouts();
        int n = screenLayoutRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScreenLayoutRuntime screenLayoutRuntime = screenLayoutRuntimeArray[n2];
            this.addScreenLayoutRuntime(new ScreenLayoutRuntime(screenLayoutRuntime));
            ++n2;
        }
    }

    public void addScreenLayoutRuntime(ScreenLayoutRuntime screenLayoutRuntime) {
        if (screenLayoutRuntime != null) {
            this.screenLayoutRuntimes.add(screenLayoutRuntime);
            screenLayoutRuntime.setLayoutRuntime(this);
        }
    }

    @Override
    public void appendScreenLayout(IScreenLayoutDefinition iScreenLayoutDefinition) {
        if (iScreenLayoutDefinition instanceof ScreenLayoutRuntime) {
            this.addScreenLayoutRuntime((ScreenLayoutRuntime)iScreenLayoutDefinition);
        }
    }

    @Override
    public IScreenLayoutDefinition appendScreenLayout(String string) {
        ScreenLayoutRuntime screenLayoutRuntime = new ScreenLayoutRuntime(new ScreenLayout());
        screenLayoutRuntime.setHorizontalXVertical(string);
        this.addScreenLayoutRuntime(screenLayoutRuntime);
        return screenLayoutRuntime;
    }

    public HangingProtocolSnapshotRuntime getHangingSnapshot() {
        return this.hangingProtocolSnapshotRuntime;
    }

    @Override
    public MainLayoutType getType() {
        return this.mainLayoutType;
    }

    @Override
    public boolean removeScreenLayout(IScreenLayoutDefinition iScreenLayoutDefinition) {
        return this.screenLayoutRuntimes.remove(iScreenLayoutDefinition);
    }

    public ScreenLayoutRuntime[] screenLayouts() {
        return this.screenLayoutRuntimes.toArray(new ScreenLayoutRuntime[this.screenLayoutRuntimes.size()]);
    }

    public void setHangingSnapshot(HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime) {
        this.hangingProtocolSnapshotRuntime = hangingProtocolSnapshotRuntime;
    }

    @Override
    public void setType(MainLayoutType mainLayoutType) {
        this.mainLayoutType = mainLayoutType;
    }
}

