/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.config.ConfigUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.plugin.IAnim2DControl;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.presentationstate.IPresStateApplicationFinishedListener;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.toptoolbar.ZoomUtils;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.util.expressions.IEvaluationContext;
import java.lang.constant.Constable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HangingCaseDisplay
implements IPresStateApplicationFinishedListener {
    private static final ALogger LOG = ALogger.getLogger(HangingCaseDisplay.class);
    private static final Object DUMMY_HANGING_SOURCE = new Object();
    private DisplayLayoutRuntime layout;
    private VisDisplay2 display;
    private static final boolean autoStartAnimation = Config.impaxee.jvision.ANIMATION.AutoStart.get();
    private static AtomicInteger counter;
    private static CountDownLatch hpWaiting;

    public HangingCaseDisplay(VisDisplay2 visDisplay2, DisplayLayoutRuntime displayLayoutRuntime) {
        this.layout = displayLayoutRuntime;
        this.display = visDisplay2;
    }

    public DisplayLayoutRuntime getLayoutRuntime() {
        return this.layout;
    }

    public VisDisplay2 getDisplay() {
        return this.display;
    }

    public void hangup(IDisplaySet iDisplaySet, Integer n, boolean bl) {
        if (this.layout != null && counter != null) {
            counter.incrementAndGet();
        }
        this.display.initVisDisplay(iDisplaySet, n, bl, ActivationMode.HANGUP, this.layout == null ? null : this);
    }

    @Override
    public void notifyPresStateApplied(boolean bl) {
        this.applyHangingDisplayState(bl);
    }

    public static void prepareWaitForHP() {
        counter = new AtomicInteger();
        hpWaiting = new CountDownLatch(2);
    }

    public static void setHPPrepareFinished() {
        if (hpWaiting != null) {
            hpWaiting.countDown();
            if (counter.get() == 0) {
                hpWaiting.countDown();
            }
        }
        if (autoStartAnimation) {
            IDisplayPlugin iDisplayPlugin = null;
            IAnim2DControl iAnim2DControl = null;
            for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
                for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                    if (!visDisplay2.getData().hasData() || !((iDisplayPlugin = visDisplay2.getData().getDisplayPlugin()) instanceof IAnim2DControl)) continue;
                    iAnim2DControl = (IAnim2DControl)((Object)iDisplayPlugin);
                    break;
                }
                if (iAnim2DControl != null) break;
            }
            if (iAnim2DControl != null) {
                LOG.info("Auto-start animation");
                iAnim2DControl.animate(true);
            }
        }
    }

    public static final void waitForHP(long l) {
        if (hpWaiting == null) {
            LOG.error("Waiter not correctly initialised");
            return;
        }
        try {
            hpWaiting.await(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void applyHorizonalFlip(VisDisplay2 visDisplay2) {
        TEvent tEvent = new TEvent(8);
        TEventDispatch.sendEventToVis(visDisplay2, tEvent, DUMMY_HANGING_SOURCE, TEventDispatch.ALL_VISUALS);
    }

    public static void applyImageInvert(VisDisplay2 visDisplay2) {
        TEvent tEvent = new TEvent(6);
        TEventDispatch.sendEventToVis(visDisplay2, tEvent, null, TEventDispatch.ALL_VISUALS);
    }

    public static void applyZoomMode(VisDisplay2 visDisplay2, ZoomMode zoomMode, double d) {
        double d2;
        ZoomUtils.setZoomMode(visDisplay2, zoomMode);
        TEvent tEvent = new TEvent(2);
        if ((zoomMode == ZoomMode.NORMAL || zoomMode == ZoomMode.PIXELIDENTITY) && (d2 = d) != 0.0) {
            TEventDispatch.sendEventToVis(visDisplay2, tEvent, new ZoomParameter(1.0 / d2), TEventDispatch.ALL_VISUALS);
        }
    }

    private void applyHangingDisplayState(boolean bl) {
        boolean bl2;
        boolean bl3;
        View view;
        Object object;
        Constable constable;
        Object object2;
        Object object3;
        int n;
        Object object4;
        ZoomMode zoomMode;
        if (this.layout == null) {
            return;
        }
        int n2 = 0;
        boolean bl4 = false;
        ZoomMode zoomMode2 = null;
        boolean bl5 = false;
        IFrameObjectData iFrameObjectData = this.display.getData().getFirstVis().getFrameData();
        if (iFrameObjectData != null && (zoomMode = ConfigUtils.getFirstMatchOfList((IEvaluationContext)(object4 = new DisplaySetEvaluable(iFrameObjectData, this.display.getData().getDisplaySet(), DataSelectionManager.getInstance().getActiveHanging().getStudyContainer())), Config.impaxee.jvision.PLUGINS.autoUsePlugin.getList(), null, "conditionText")) != null) {
            String string = zoomMode.getString("pluginName");
            PluginName pluginName = PluginName.getItemWithName(string);
            if (pluginName == PluginName.INVERT) {
                n2 = 1;
            } else if (pluginName == PluginName.TRUESIZE_ZOOM) {
                zoomMode2 = ZoomMode.TRUESIZE;
            } else if (pluginName == PluginName.PIXELIDENTITY_ZOOM) {
                zoomMode2 = ZoomMode.PIXELIDENTITY;
            } else if (pluginName == PluginName.FLIP) {
                bl4 = true;
            } else if (pluginName == PluginName.LOCALIZER) {
                bl5 = true;
            }
        }
        object4 = null;
        if (this.display.getData() != null && this.display.getData().getFirstVis() != null) {
            object4 = new DisplayState();
            this.display.getData().getFirstVis().saveDisplayState((DisplayState)object4);
        }
        if ((zoomMode = this.layout.getDisplayState().getZoomMode()) == ZoomMode.NORMAL && zoomMode2 != null) {
            zoomMode = zoomMode2;
        }
        double d = this.layout.getDisplayState().getMagnificationRatio();
        if (zoomMode != ZoomMode.NORMAL || d != 0.0) {
            HangingCaseDisplay.applyZoomMode(this.display, zoomMode, d);
        }
        if (!bl) {
            n = 0;
            if (object4 != null && ((DisplayState)object4).getImageRotation() != null) {
                n = ((DisplayState)object4).getImageRotation();
            }
            this.rotate(n, 0);
            object3 = this.layout.getDisplayState().getImageRotation();
            if (object3 != null && (Integer)object3 != 0) {
                this.rotate(0, (Integer)object3);
            }
            if ((bl4 |= Boolean.TRUE.equals(this.layout.getDisplayState().getImageHorizontalFlip())) && object4 != null) {
                boolean bl6 = Boolean.TRUE.equals(((DisplayState)object4).getImageHorizontalFlip());
                if (bl6 != bl4) {
                    HangingCaseDisplay.applyHorizonalFlip(this.display);
                }
            } else if (bl4) {
                HangingCaseDisplay.applyHorizonalFlip(this.display);
            }
            object2 = new TEvent(17);
            constable = this.layout.getDisplayState().getViewPortCenterX();
            Double d2 = this.layout.getDisplayState().getViewPortCenterY();
            if ((Double)constable == 0.0 && d2 == 0.0) {
                constable = Double.valueOf(0.5);
                d2 = 0.5;
            }
            constable = this.roundViewPortCenter((Double)constable);
            d2 = this.roundViewPortCenter(d2);
            if ((Double)constable != 0.5 || d2 != 0.5) {
                object = ViewportDefinition.getImageAbsoluteNormalized((Double)constable, d2);
                TEventDispatch.sendEventToVis(this.display, (TEvent)object2, object, TEventDispatch.ALL_VISUALS);
            }
            if ((object = this.layout.getDisplayState().getViewPortCenterAlignmentX()) != null) {
                TEventDispatch.sendEventToVis(this.display, new TEvent(132), object, TEventDispatch.ALL_VISUALS);
            }
            if (object3 == null || (Integer)object3 == 0) {
                this.rotate(0, n);
            }
        }
        if ((n2 |= Boolean.TRUE.equals(this.layout.getDisplayState().getImageInvert())) != 0 && object4 != null) {
            n = Boolean.TRUE.equals(((DisplayState)object4).getImageInvert()) ? 1 : 0;
            if (n != n2) {
                HangingCaseDisplay.applyImageInvert(this.display);
            }
        } else if (n2 != 0) {
            HangingCaseDisplay.applyImageInvert(this.display);
        }
        if (bl5 && this.display.hasData() && (view = this.display.getVis(0).getView()) instanceof ImgView2 && ((ImgView2)view).canHaveLocalizer()) {
            object3 = new TEvent(116);
            TEventDispatch.sendEventToVis(this.display, (TEvent)object3, (Object)Localizer.LocalizerState.UserForcedOn, TEventDispatch.ALL_VISUALS);
        }
        if (bl3 = Boolean.TRUE.equals(this.layout.getDisplayState().getLocalizerEnabled())) {
            object3 = new TEvent(116);
            TEventDispatch.sendEventToVis(this.display, (TEvent)object3, (Object)Localizer.LocalizerState.UserForcedOn, TEventDispatch.ALL_VISUALS);
        }
        object3 = this.layout.getDisplayState().getWindowCenter();
        object2 = this.layout.getDisplayState().getWindowWidth();
        constable = this.layout.getDisplayState().getUseWindowLevel();
        if (((Boolean)constable).booleanValue() && object3 != null && object2 != null) {
            this.display.onWindowingValueChange(new WindowValue((Double)object3, (Double)object2), TEventDispatch.ALL_VISUALS);
        }
        if (bl2 = this.layout.getDisplayState().getSynced().booleanValue()) {
            this.display.setSynchronized(bl2);
        }
        if ((object = FilterActions.FilterType.parse(this.layout.getDisplayState().getFilterName())) != FilterActions.FilterType.None) {
            TEvent tEvent = new TEvent(12);
            TEventDispatch.sendEventToVis(this.display, tEvent, object, TEventDispatch.ALL_VISUALS);
            FilterActions.updateSelectionState(this.display, object);
        }
        if (counter != null && counter.decrementAndGet() == 0 && hpWaiting.getCount() < 2L) {
            hpWaiting.countDown();
        }
    }

    private Double roundViewPortCenter(Double d) {
        if (d != null && Math.abs(d - 0.5) < 0.005) {
            return 0.5;
        }
        return d;
    }

    private void rotate(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            this.sendRotateEvent(n3, 10);
        } else if (n3 < 0) {
            this.sendRotateEvent(-n3, 9);
        }
    }

    private void sendRotateEvent(int n, int n2) {
        TEvent tEvent = new TEvent(n2);
        int n3 = 0;
        while (n3 < n / 90) {
            TEventDispatch.sendEventToVis(this.display, tEvent, null, TEventDispatch.ALL_VISUALS);
            ++n3;
        }
    }
}

