/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.DisplayTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenSettingsPanel;
import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHangingScreen;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.layout.StateLytScreen;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class ScreenTreeNode
extends ActivationStateTreeNode {
    private ScreenSettingsPanel screenSettingsPanel;
    private int number;
    private IHangingProtocolManipulationListener imageHangingChangeListener;
    private IComponentFactory componentFactory;
    private Window parentWindow;
    private IScreenLayoutDefinition screenLayout;
    private ConditionalHangingScreen conditionalHangingScreen;
    private OrderHangingScreen orderHangingScreen;
    private boolean isOrderHanging;

    public ScreenTreeNode(Window window, MainLayoutType mainLayoutType, IScreenLayoutDefinition iScreenLayoutDefinition, OrderHangingScreen orderHangingScreen, ConditionalHangingScreen conditionalHangingScreen, boolean bl, int n, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IComponentFactory iComponentFactory) {
        super(iComponentFactory);
        this.parentWindow = window;
        this.screenSettingsPanel = new ScreenSettingsPanel(mainLayoutType, iScreenLayoutDefinition, orderHangingScreen, bl, iHangingProtocolManipulationListener, iComponentFactory);
        this.number = n;
        this.imageHangingChangeListener = iHangingProtocolManipulationListener;
        this.componentFactory = iComponentFactory;
        this.screenLayout = iScreenLayoutDefinition;
        this.conditionalHangingScreen = conditionalHangingScreen;
        this.orderHangingScreen = orderHangingScreen;
        this.isOrderHanging = bl;
        this.screenSettingsPanel.setOwner(this);
        this.addActivationStateTreeListener(this.screenSettingsPanel);
        IDisplayLayoutDefinition[] iDisplayLayoutDefinitionArray = iScreenLayoutDefinition.displayLayouts();
        int n2 = 0;
        while (n2 < iDisplayLayoutDefinitionArray.length) {
            DisplaySetCondition displaySetCondition2 = conditionalHangingScreen.getDisplaySetCondition(n2);
            if (displaySetCondition2 == null) {
                displaySetCondition2 = new DisplaySetCondition();
                conditionalHangingScreen.addDisplaySetCondition(displaySetCondition2);
            }
            this.add(new DisplayTreeNode(window, mainLayoutType, displaySetCondition2, iDisplayLayoutDefinitionArray[n2], iHangingProtocolManipulationListener, iComponentFactory, n2 + 1, bl));
            ++n2;
        }
    }

    public ScreenSettingsPanel getScreenSettingsPanel() {
        return this.screenSettingsPanel;
    }

    @Override
    public String toString() {
        return String.valueOf(Messages.getString("HangingDefinitionConfigurationSavePanel.Screen")) + " " + this.number;
    }

    @Override
    public JPanel getPanel() {
        return this.screenSettingsPanel;
    }

    public void screenLayoutTypeChanged(MainLayoutType mainLayoutType) {
        if (this.isActive()) {
            this.getScreenSettingsPanel().setScreenLayout(mainLayoutType, "1x1", null, true);
        }
        this.screenLayoutChanged("1x1");
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof DisplayTreeNode)) continue;
                if (this.isActive()) {
                    ((DisplayTreeNode)e).screenLayoutTypeChanged(mainLayoutType);
                }
                this.model.nodeChanged((TreeNode)e);
            }
        }
    }

    public void screenLayoutChanged(String string) {
        String string22;
        int n = 0;
        int n2 = StateLytScreen.getRequiredDisplayCount(this.getScreenSettingsPanel().getCurrentScreenLayoutType(), string);
        if (this.children != null) {
            for (String string22 : this.children) {
                if (!(string22 instanceof DisplayTreeNode)) continue;
                if (!this.isActive() || n >= n2) {
                    if (((DisplayTreeNode)((Object)string22)).isActive()) {
                        ((DisplayTreeNode)((Object)string22)).setActive(false);
                        if (this.screenLayout.removeDisplayLayout(((DisplayTreeNode)((Object)string22)).getDisplayLayout())) {
                            this.conditionalHangingScreen.removeDisplaySetCondition(((DisplayTreeNode)((Object)string22)).getDisplaySetCondition());
                            if (this.imageHangingChangeListener != null) {
                                this.imageHangingChangeListener.hangingChanged();
                            }
                        }
                    }
                } else {
                    if (!((DisplayTreeNode)((Object)string22)).isActive()) {
                        this.screenLayout.appendDisplayLayout(((DisplayTreeNode)((Object)string22)).getDisplayLayout());
                        this.conditionalHangingScreen.addDisplaySetCondition(((DisplayTreeNode)((Object)string22)).getDisplaySetCondition());
                        if (this.imageHangingChangeListener != null) {
                            this.imageHangingChangeListener.hangingChanged();
                        }
                    }
                    ((DisplayTreeNode)((Object)string22)).setActive(true);
                }
                ++n;
                this.model.nodeChanged((TreeNode)((Object)string22));
            }
        }
        if ((string22 = this.screenSettingsPanel.getSelectedStripeDisplayLayout()) == null) {
            string22 = "1x1";
        }
        while (n < n2) {
            this.addDisplay(this.screenSettingsPanel.getCurrentScreenLayoutType(), "1x1", PluginName.DEFAULT.getPluginName());
            ++n;
        }
    }

    public void displayLayoutChanged(MainLayoutType mainLayoutType, String string) {
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof DisplayTreeNode)) continue;
                ((DisplayTreeNode)e).displayLayoutChanged(mainLayoutType, string);
                this.model.nodeChanged((TreeNode)e);
            }
        }
    }

    public void kindOfHangingChanged(boolean bl) {
        if (this.isOrderHanging != bl) {
            if (this.children != null) {
                for (Object e : this.children) {
                    if (!(e instanceof DisplayTreeNode)) continue;
                    ((DisplayTreeNode)e).kindOfHangingChanged(bl);
                }
            }
            if (this.screenSettingsPanel != null) {
                this.screenSettingsPanel.kindOfHangingChanged(bl);
            }
            this.isOrderHanging = bl;
        }
    }

    public void addDisplay(MainLayoutType mainLayoutType, String string, String string2) {
        IDisplayLayoutDefinition iDisplayLayoutDefinition = this.screenLayout.appendDisplayLayout(string);
        iDisplayLayoutDefinition.setPluginName(string2);
        DisplaySetCondition displaySetCondition2 = new DisplaySetCondition();
        this.conditionalHangingScreen.addDisplaySetCondition(displaySetCondition2);
        DisplayTreeNode displayTreeNode = new DisplayTreeNode(this.parentWindow, mainLayoutType, displaySetCondition2, iDisplayLayoutDefinition, this.imageHangingChangeListener, this.componentFactory, this.getChildCount() + 1, this.isOrderHanging);
        this.model.insertNodeInto(displayTreeNode, this, this.getChildCount());
        displayTreeNode.setModel(this.model);
    }

    public OrderHangingScreen getOrderScreen() {
        return this.orderHangingScreen;
    }

    public ConditionalHangingScreen getConditionalHangingScreen() {
        return this.conditionalHangingScreen;
    }

    public IScreenLayoutDefinition getScreenLayout() {
        return this.screenLayout;
    }
}

