/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationHandler;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeCellRenderer;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingProtocolTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotTreeNode;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.ILayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.impaxee.save.ISaveItem;
import com.agfa.pacs.impaxee.save.ISaveManager;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.tiani.base.data.IStudyData;
import com.tiani.gui.util.tree.ImpaxEETree;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.dcm4che3.data.Attributes;

public class HangingDefinitionConfigurationEditPanel
extends JPanel
implements ISaveItem {
    private Window parentWindow;
    private HangingProtocolManipulationHandler hangingProtocolManipulationHandler;
    private MyTreeModelListener treeModelListener;
    private IHangingProtocolDefinition hangingProtocolDefinition;
    private HangingProtocolTreeNode hangingProtocolTreeNode;
    private JSplitPane splitPane;
    private DefaultTreeModel treeModel;
    private ImpaxEETree tree;
    private IComponentFactory componentFactory;

    public String findNextSnapshotName() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.hangingProtocolTreeNode.getChildCount()) {
            TreeNode treeNode = this.hangingProtocolTreeNode.getChildAt(n2);
            if (treeNode instanceof SnapshotTreeNode) {
                try {
                    int n3 = Integer.parseInt(((SnapshotTreeNode)treeNode).getSnapshotName());
                    if (n3 > n) {
                        n = n3;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return Integer.toString(n + 1);
    }

    public HangingDefinitionConfigurationEditPanel(IHangingProtocolDefinition iHangingProtocolDefinition, IComponentFactory iComponentFactory, HangingProtocolManipulationHandler hangingProtocolManipulationHandler, boolean bl) {
        this.hangingProtocolDefinition = iHangingProtocolDefinition;
        this.componentFactory = iComponentFactory;
        this.hangingProtocolManipulationHandler = hangingProtocolManipulationHandler;
        this.createComponents(bl);
    }

    private void addToSnapshotTreeNode(ISnapshotDefinition iSnapshotDefinition) {
        this.addToSnapshotTreeNode(iSnapshotDefinition, this.hangingProtocolTreeNode.getChildCount());
    }

    private void addToSnapshotTreeNode(ISnapshotDefinition iSnapshotDefinition, int n) {
        SnapshotTreeNode snapshotTreeNode = new SnapshotTreeNode(this.parentWindow, this.hangingProtocolDefinition, iSnapshotDefinition, this.hangingProtocolManipulationHandler, this.componentFactory);
        snapshotTreeNode.addActivationStateTreeListener(this.hangingProtocolTreeNode);
        snapshotTreeNode.setModel(this.treeModel);
        this.treeModel.insertNodeInto(snapshotTreeNode, this.hangingProtocolTreeNode, n);
        Object[] objectArray = this.treeModel.getPathToRoot(snapshotTreeNode);
        if (objectArray != null && objectArray.length > 0) {
            TreePath treePath = new TreePath(objectArray);
            this.tree.expandPath(treePath);
        }
        snapshotTreeNode.setAddToParentFinished(true);
    }

    private void createComponents(boolean bl) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel jPanel = ComponentFactory.instance.createPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "North");
        this.hangingProtocolTreeNode = new HangingProtocolTreeNode(this.parentWindow, this.hangingProtocolDefinition, this.componentFactory, this.hangingProtocolManipulationHandler, bl);
        this.treeModel = new DefaultTreeModel(this.hangingProtocolTreeNode);
        this.hangingProtocolTreeNode.setModel(this.treeModel);
        this.tree = new ImpaxEETree(this.treeModel, this.componentFactory);
        this.tree.setCellRenderer(new ActivationStateTreeCellRenderer());
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setOpaque(true);
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        this.tree.setToolTipText(Messages.getString("HangingDefinitionConfigurationSavePanel.TreeSnapshotsToolTip"));
        JScrollPane jScrollPane = this.componentFactory.createScrollPane((Component)this.tree, Integer.valueOf(20), Integer.valueOf(30), Boolean.valueOf(true), Boolean.valueOf(true));
        jScrollPane.setPreferredSize(this.componentFactory.scaleDimension(230, 200));
        jScrollPane.setMinimumSize(this.componentFactory.scaleDimension(150, 0));
        this.splitPane = new JSplitPane(1, jScrollPane, SwingUtilities2.createPanel((Boolean)false, null));
        int n = this.tree.getRowCount() - 1;
        while (n >= 0) {
            this.tree.expandRow(n);
            if (n == 0) {
                this.tree.expandRow(1);
            }
            --n;
        }
        Object[] objectArray = this.hangingProtocolTreeNode.getFirstRuntimeSnapshotTreeNode();
        if (objectArray != null && objectArray.length > 0) {
            this.tree.setSelectionPath(new TreePath(objectArray));
        } else {
            this.tree.setSelectionRow(0);
        }
        this.tree.addMouseListener(new TreeContextMenuMouseListener());
        if (this.hangingProtocolDefinition instanceof IHanging) {
            JPanel jPanel2 = ComponentFactory.instance.createPanel((LayoutManager)new RowLayout());
            for (String object2 : this.createStudyContainerInfo((IHanging)((Object)this.hangingProtocolDefinition))) {
                jPanel2.add(this.componentFactory.createLabel(object2));
            }
            JScrollPane jScrollPane2 = this.componentFactory.createScrollPane((Component)jPanel2, Integer.valueOf(20), Integer.valueOf(30), Boolean.valueOf(true), Boolean.valueOf(false));
            jScrollPane2.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 5, 5, 5), this.componentFactory.createTitledBorder(Messages.getString("HangingDefinitionConfigurationEditPanel.AvailableStudies"))));
            JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, this.splitPane);
            jSplitPane.setDividerLocation(this.componentFactory.scaleInt(100));
            jSplitPane.setOpaque(false);
            this.add((Component)jSplitPane, "Center");
        } else {
            this.add((Component)this.splitPane, "Center");
        }
        this.treeModelListener = new MyTreeModelListener();
        this.treeModel.addTreeModelListener(this.treeModelListener);
        this.hangingProtocolTreeNode.validStateChanged();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public int getProgressAmount() {
        return 1;
    }

    @Override
    public List<IStoreHandler> getStoreHandlers() {
        return null;
    }

    void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    ISnapshotDefinition getSelectedSnapshot(boolean bl) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && treePath.getPathCount() > 0) {
            if (bl) {
                Object[] objectArray = treePath.getPath();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof SnapshotTreeNode) {
                        return ((SnapshotTreeNode)object).getSnapshot();
                    }
                    ++n2;
                }
            } else if (treePath.getLastPathComponent() instanceof SnapshotTreeNode) {
                return ((SnapshotTreeNode)treePath.getLastPathComponent()).getSnapshot();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public boolean isSaveable() {
        return false;
    }

    @Override
    @Deprecated
    public boolean save(boolean bl) {
        return false;
    }

    @Override
    @Deprecated
    public void setSaveManager(ISaveManager iSaveManager) {
    }

    public void deregisterListeners() {
        if (this.hangingProtocolTreeNode != null) {
            this.hangingProtocolTreeNode.deregisterListeners();
        }
    }

    private List<String> createStudyContainerInfo(IHanging iHanging) {
        IStudyData iStudyData;
        ArrayList<String> arrayList = new ArrayList<String>();
        IStudyContainer iStudyContainer = iHanging.getStudyContainer();
        if (iStudyContainer != null && (iStudyData = iStudyContainer.getBaseStudy()) != null) {
            Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
            arrayList.add("<html><b>" + Messages.getString("HangingDefinitionConfigurationEditPanel.BaseStudy") + ": </b>" + iStudyData.getDicomObject().getString(528432) + " [" + date + "]</html>");
            int n = 0;
            while (n < iStudyContainer.getRelevantPriorCount()) {
                IStudyInfo iStudyInfo = iStudyContainer.getPriorInfo(n);
                date = DateTimeUtils.getStudyDateTime((IDataInfo)iStudyInfo);
                arrayList.add("<html><b>" + (n + 1) + ". " + Messages.getString("HangingDefinitionConfigurationEditPanel.Prior") + ": </b>" + iStudyInfo.getAttributes().getString(528432) + " [" + date + "]</html>");
                ++n;
            }
        }
        return arrayList;
    }

    private class AddScreenAction
    extends AbstractAction {
        private SnapshotTreeNode snapshotTreeNode;

        public AddScreenAction(SnapshotTreeNode snapshotTreeNode) {
            super(Messages.getString("HangingDefinitionConfigurationEditPanel.AddScreen"));
            this.snapshotTreeNode = snapshotTreeNode;
            this.setEnabled(snapshotTreeNode.getSnapshotSettingsPanel().getScreenLayoutType() == MainLayoutType.variable);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainLayoutType mainLayoutType = this.snapshotTreeNode.getSnapshotSettingsPanel().getScreenLayoutType();
            IScreenLayoutDefinition iScreenLayoutDefinition = this.snapshotTreeNode.getSnapshot().getLayout().appendScreenLayout("1x1");
            this.snapshotTreeNode.addScreen(mainLayoutType, iScreenLayoutDefinition, HangingDefinitionConfigurationEditPanel.this.componentFactory);
        }
    }

    private class AddSnapshotAction
    extends AbstractAction {
        public AddSnapshotAction() {
            super(Messages.getString("HangingDefinitionConfigurationEditPanel.AddSnapshot"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ISnapshotDefinition iSnapshotDefinition = HangingDefinitionConfigurationEditPanel.this.hangingProtocolDefinition.getHangingDefinition().appendNewSnapshot(HangingDefinitionConfigurationEditPanel.this.findNextSnapshotName());
            ILayoutDefinition iLayoutDefinition = iSnapshotDefinition.getLayout();
            iLayoutDefinition.appendScreenLayout("1x1").appendDisplayLayout("1x1");
            iLayoutDefinition.appendScreenLayout("1x1").appendDisplayLayout("1x1");
            iLayoutDefinition.setType(MainLayoutType.variable);
            HangingDefinitionConfigurationEditPanel.this.addToSnapshotTreeNode(iSnapshotDefinition);
        }
    }

    private class DeleteScreenAction
    extends AbstractAction {
        private ScreenTreeNode screenTreeNode;

        public DeleteScreenAction(ScreenTreeNode screenTreeNode) {
            super(screenTreeNode.isActive() ? Messages.getString("HangingDefinitionConfigurationEditPanel.DeactivateScreen") : Messages.getString("HangingDefinitionConfigurationEditPanel.ActivateScreen"));
            this.screenTreeNode = screenTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.screenTreeNode.setActive(!this.screenTreeNode.isActive());
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolManipulationHandler.hangingChanged();
            HangingDefinitionConfigurationEditPanel.this.tree.repaint();
        }
    }

    private class DuplicateSnapshotAction
    extends AbstractAction {
        private SnapshotTreeNode snapShotTreeNode;

        public DuplicateSnapshotAction(SnapshotTreeNode snapshotTreeNode) {
            super(Messages.getString("HangingDefinitionConfigurationEditPanel.DuplicateSnapshot"));
            this.snapShotTreeNode = snapshotTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            while (true) {
                if ((string = JOptionPane.showInputDialog(HangingDefinitionConfigurationEditPanel.this.getParent(), Messages.getString("HangingDefinitionConfigurationEditPanel.DuplicatedSnapshotNameQuestion"), HangingDefinitionConfigurationEditPanel.this.findNextSnapshotName())) == null) {
                    return;
                }
                if (string.trim().length() == 0) {
                    Message.warning(Messages.getString("SnapshotSettingsPanel.ErrorTitleEmptyString"), Messages.getString("SnapshotSettingsPanel.ErrorMessageEmptyString"));
                    continue;
                }
                if (HangingDefinitionConfigurationEditPanel.this.hangingProtocolDefinition.isUniqueSnapshotName(string, null)) break;
                Message.warning(Messages.getString("SnapshotSettingsPanel.ErrorTitleAmbiguousSnapshotName"), Messages.getString("SnapshotSettingsPanel.ErrorMessageAmbiguousSnapshotName"));
            }
            Snapshot snapshot = ((Snapshot)this.snapShotTreeNode.getSnapshot()).clone();
            snapshot.setName(string);
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolDefinition.getHangingDefinition().appendSnapshot(snapshot);
            HangingDefinitionConfigurationEditPanel.this.addToSnapshotTreeNode(snapshot);
        }
    }

    private class MoveSnapshotAction
    extends AbstractAction {
        private SnapshotTreeNode snapshotTreeNode;
        private boolean moveUpwards;

        public MoveSnapshotAction(boolean bl, SnapshotTreeNode snapshotTreeNode, String string) {
            super(string);
            this.moveUpwards = bl;
            this.snapshotTreeNode = snapshotTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HangingDefinitionConfigurationEditPanel.this.treeModel.removeTreeModelListener(HangingDefinitionConfigurationEditPanel.this.treeModelListener);
            int n = this.snapshotTreeNode.getParent().getIndex(this.snapshotTreeNode);
            n = this.moveUpwards ? n - 1 : n + 1;
            HangingDefinitionConfigurationEditPanel.this.treeModel.removeNodeFromParent(this.snapshotTreeNode);
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolDefinition.getHangingDefinition().removeSnapshot(this.snapshotTreeNode.getSnapshot());
            HangingDefinitionConfigurationEditPanel.this.addToSnapshotTreeNode(this.snapshotTreeNode.getSnapshot(), n);
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolDefinition.getHangingDefinition().insertSnapshot(n, this.snapshotTreeNode.getSnapshot());
            HangingDefinitionConfigurationEditPanel.this.treeModel.addTreeModelListener(HangingDefinitionConfigurationEditPanel.this.treeModelListener);
        }
    }

    private class MyTreeModelListener
    implements TreeModelListener {
        private MyTreeModelListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolManipulationHandler.hangingChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolManipulationHandler.hangingChanged();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            Object object = treePath.getLastPathComponent();
            if (object instanceof ActivationStateTreeNode) {
                ActivationStateTreeNode activationStateTreeNode = (ActivationStateTreeNode)object;
                int n = HangingDefinitionConfigurationEditPanel.this.splitPane.getDividerLocation();
                HangingDefinitionConfigurationEditPanel.this.splitPane.setRightComponent(activationStateTreeNode.getPanel());
                HangingDefinitionConfigurationEditPanel.this.splitPane.setDividerLocation(n);
                HangingDefinitionConfigurationEditPanel.this.revalidate();
                HangingDefinitionConfigurationEditPanel.this.repaint();
            }
        }
    }

    private class SwitchSnapshotActivationAction
    extends AbstractAction {
        private SnapshotTreeNode snapShotTreeNode;

        public SwitchSnapshotActivationAction(SnapshotTreeNode snapshotTreeNode) {
            super(snapshotTreeNode.isActive() ? Messages.getString("HangingDefinitionConfigurationEditPanel.DeactivateSnapshot") : Messages.getString("HangingDefinitionConfigurationEditPanel.ActivateSnapshot"));
            this.snapShotTreeNode = snapshotTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snapShotTreeNode.setActive(!this.snapShotTreeNode.isActive());
            HangingDefinitionConfigurationEditPanel.this.hangingProtocolManipulationHandler.hangingChanged();
            HangingDefinitionConfigurationEditPanel.this.tree.repaint();
        }
    }

    private class TreeContextMenuMouseListener
    extends MouseAdapter {
        private TreeContextMenuMouseListener() {
        }

        private boolean allPreviousActive(ScreenTreeNode screenTreeNode, SnapshotTreeNode snapshotTreeNode) {
            int n = snapshotTreeNode.getIndex(screenTreeNode);
            int n2 = 0;
            while (n2 < n) {
                ScreenTreeNode screenTreeNode2;
                TreeNode treeNode = snapshotTreeNode.getChildAt(n2);
                if (treeNode instanceof ScreenTreeNode && !(screenTreeNode2 = (ScreenTreeNode)treeNode).isActive()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private boolean allNextDeactivedAndNotFirst(ScreenTreeNode screenTreeNode, SnapshotTreeNode snapshotTreeNode) {
            int n = snapshotTreeNode.getIndex(screenTreeNode);
            if (n == 0) {
                return false;
            }
            int n2 = n + 1;
            while (n2 < snapshotTreeNode.getChildCount()) {
                ScreenTreeNode screenTreeNode2;
                TreeNode treeNode = snapshotTreeNode.getChildAt(n2);
                if (treeNode instanceof ScreenTreeNode && (screenTreeNode2 = (ScreenTreeNode)treeNode).isActive()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            if (mouseEvent.getButton() == 3 && (treePath = HangingDefinitionConfigurationEditPanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getPathCount() > 0) {
                Serializable serializable;
                Serializable serializable2;
                if (treePath.getLastPathComponent() instanceof SnapshotTreeNode) {
                    serializable2 = (SnapshotTreeNode)treePath.getLastPathComponent();
                    serializable = new JPopupMenu();
                    ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new AddScreenAction((SnapshotTreeNode)serializable2)));
                    ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new SwitchSnapshotActivationAction((SnapshotTreeNode)serializable2)));
                    if (((DefaultMutableTreeNode)serializable2).getParent().getIndex((TreeNode)((Object)serializable2)) == 0) {
                        ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new MoveSnapshotAction(false, (SnapshotTreeNode)serializable2, Messages.getString("HangingDefinitionConfigurationEditPanel.MoveSnapshotDownward"))));
                    } else if (((DefaultMutableTreeNode)serializable2).getParent().getChildCount() - 1 == ((DefaultMutableTreeNode)serializable2).getParent().getIndex((TreeNode)((Object)serializable2))) {
                        ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new MoveSnapshotAction(true, (SnapshotTreeNode)serializable2, Messages.getString("HangingDefinitionConfigurationEditPanel.MoveSnapshotUpward"))));
                    } else {
                        ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new MoveSnapshotAction(true, (SnapshotTreeNode)serializable2, Messages.getString("HangingDefinitionConfigurationEditPanel.MoveSnapshotUpward"))));
                        ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new MoveSnapshotAction(false, (SnapshotTreeNode)serializable2, Messages.getString("HangingDefinitionConfigurationEditPanel.MoveSnapshotDownward"))));
                    }
                    if (((SnapshotTreeNode)serializable2).getSnapshot() instanceof Snapshot) {
                        ((JPopupMenu)serializable).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new DuplicateSnapshotAction((SnapshotTreeNode)serializable2)));
                    }
                    ((JPopupMenu)serializable).show(HangingDefinitionConfigurationEditPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                }
                if (treePath.getLastPathComponent() instanceof ScreenTreeNode) {
                    serializable2 = (ScreenTreeNode)treePath.getLastPathComponent();
                    serializable = (SnapshotTreeNode)((DefaultMutableTreeNode)serializable2).getParent();
                    if (((SnapshotTreeNode)serializable).getSnapshotSettingsPanel().getScreenLayoutType() == MainLayoutType.variable && (((ActivationStateTreeNode)serializable2).isActive() && this.allNextDeactivedAndNotFirst((ScreenTreeNode)serializable2, (SnapshotTreeNode)serializable) || !((ActivationStateTreeNode)serializable2).isActive() && this.allPreviousActive((ScreenTreeNode)serializable2, (SnapshotTreeNode)serializable))) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        jPopupMenu.add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new DeleteScreenAction((ScreenTreeNode)serializable2)));
                        jPopupMenu.show(HangingDefinitionConfigurationEditPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (treePath.getLastPathComponent() instanceof HangingProtocolTreeNode) {
                    serializable2 = new JPopupMenu();
                    ((JPopupMenu)serializable2).add(HangingDefinitionConfigurationEditPanel.this.componentFactory.createMenuItem((Action)new AddSnapshotAction()));
                    ((JPopupMenu)serializable2).show(HangingDefinitionConfigurationEditPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }
}

