/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationHandler;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingDefinitionConfigurationEditPanel;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.main.JVision2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class HangingDefinitionConfigurationEditDialog
extends StandardDialog {
    private UserDefinedHangingProtocolRuntime hangingProtocolRuntime;
    private HangingDefinitionConfigurationEditPanel hangingDefinitionConfigurationEditPanel;
    private IStudyContainer studyContainer;
    private boolean reHangupRequired = false;

    public HangingDefinitionConfigurationEditDialog(JFrame jFrame, UserDefinedHangingProtocolRuntime userDefinedHangingProtocolRuntime, IStudyContainer iStudyContainer) {
        super((Frame)jFrame, HangingDefinitionConfigurationEditDialog.createTitleBarText(userDefinedHangingProtocolRuntime));
        this.hangingProtocolRuntime = userDefinedHangingProtocolRuntime;
        this.studyContainer = iStudyContainer;
        this.init(this.createDescriptiveLabelText(userDefinedHangingProtocolRuntime));
    }

    private static String createTitleBarText(IHangingProtocolDefinition iHangingProtocolDefinition) {
        return String.valueOf(Messages.getString("HangingDefinitionConfigurationEditDialog.DialogTitle")) + " (Hanging: " + iHangingProtocolDefinition.getName() + ")";
    }

    private String createDescriptiveLabelText(IHangingProtocolDefinition iHangingProtocolDefinition) {
        return String.valueOf(Messages.getString("HangingDefinitionConfigurationSaveDialog.LabelHanging")) + " \"" + iHangingProtocolDefinition.getName() + "\" ";
    }

    private void init(String string) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HangingDefinitionConfigurationEditDialog.this.setDialogResult(0);
                HangingDefinitionConfigurationEditDialog.this.setVisible(false);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HangingDefinitionConfigurationEditDialog.this.setVisible(false);
            }
        };
        this.addOKButton(abstractAction);
        this.addCancelButton(abstractAction2);
        this.hangingDefinitionConfigurationEditPanel = new HangingDefinitionConfigurationEditPanel(this.hangingProtocolRuntime, ComponentFactory.instance, new HangingProtocolManipulationHandler(this.hangingProtocolRuntime), false);
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.studyContainer != null) {
            final JButton jButton = ComponentFactory.instance.createButton(Messages.getString("HangingDefinitionConfigurationEditDialog.Preview"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final ISnapshotDefinition iSnapshotDefinition = HangingDefinitionConfigurationEditDialog.this.hangingDefinitionConfigurationEditPanel.getSelectedSnapshot(true);
                    if (iSnapshotDefinition != null) {
                        if (iSnapshotDefinition.getConditionalHanging() != null) {
                            ConditionalHanging conditionalHanging = iSnapshotDefinition.getConditionalHanging();
                            int n = conditionalHanging.screenCount();
                            int n2 = 0;
                            while (n2 < n) {
                                ConditionalHangingScreen conditionalHangingScreen = conditionalHanging.getConditionalHangingScreen(n2);
                                int n3 = conditionalHangingScreen.runtimeGetDisplaySetConditionCount();
                                int n4 = 0;
                                while (n4 < n3) {
                                    conditionalHangingScreen.getDisplaySetCondition(n4).runtimeSetBaseDisplaySet(null);
                                    ++n4;
                                }
                                ++n2;
                            }
                        }
                        HangingDefinitionConfigurationEditDialog.this.reHangupRequired = true;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                JVision2.getMainFrame().clearAllDisplays();
                                JVision2.getMainFrame().hangup(HangingDefinitionConfigurationEditDialog.this.hangingProtocolRuntime, iSnapshotDefinition.getName());
                            }
                        };
                        try {
                            EventUtil.invokeSynchronous((Runnable)runnable);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            this.hangingDefinitionConfigurationEditPanel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (HangingDefinitionConfigurationEditDialog.this.hangingDefinitionConfigurationEditPanel.getSelectedSnapshot(true) != null) {
                        jButton.setEnabled(true);
                    } else {
                        jButton.setEnabled(false);
                    }
                }
            });
            jButton.setEnabled(this.hangingDefinitionConfigurationEditPanel.getSelectedSnapshot(true) != null);
            jPanel.add((Component)this.hangingDefinitionConfigurationEditPanel, "Center");
            jPanel.add((Component)jButton, "South");
        }
        this.setContent(jPanel);
        this.setSize(ComponentFactory.instance.scaleDimension(960, 900));
        this.initLocation();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                HangingDefinitionConfigurationEditDialog.this.hangingDefinitionConfigurationEditPanel.deregisterListeners();
            }
        });
    }

    public boolean isReHangupRequired() {
        return this.reHangupRequired;
    }
}

