/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.descriptors.gui.DescriptorEditDialog;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IConditionEvaluator;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.ConditionListEntry;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractReferencedDescriptorsContainer;
import com.agfa.pacs.listtext.swingx.controls.EditableComboBox;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.layout.RowLayout;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CreateAbstractConditionPanel
extends JPanel {
    private static final int COMBOBOX_MIN_WIDTH = 200;
    private static final ALogger log = ALogger.getLogger(CreateAbstractConditionPanel.class);
    private static final String ICON_PATH = "/icons/hangingGUI";
    private final PIcon deleteIcon;
    private final PIcon addIcon;
    private final IConditionEvaluator conditionEvaluator;
    private List<DescriptorPanel> descriptorPanels;
    private IComponentFactory componentFactory;
    private Window parent;
    private IHangingProtocolManipulationListener listener;
    private AbstractReferencedDescriptorsContainer referencedDescriptorsContainer;
    private Map<Descriptor, DescriptorPanel> selectedDescriptors;
    private JPanel panelDescriptorPanels;
    private JScrollPane scrollPaneSelectedConditions;
    private JComboBox comboBoxAvailableDescriptors;
    private JCheckBox checkBoxFilterDescriptors;
    private JPanel panelButtonAddCreate;
    private JButton buttonCreateConditionSet;
    private JButton buttonDeleteSelectedDescriptor;
    private DescriptorListListener descriptorListListener;
    private boolean restrictTags;
    private boolean isDescriptorFilterEnabled;

    public CreateAbstractConditionPanel(Window window, String string, AbstractReferencedDescriptorsContainer abstractReferencedDescriptorsContainer, IComponentFactory iComponentFactory, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IConditionEvaluator iConditionEvaluator) {
        this(window, string, abstractReferencedDescriptorsContainer, iComponentFactory, iHangingProtocolManipulationListener, iConditionEvaluator, false);
    }

    public CreateAbstractConditionPanel(Window window, String string, AbstractReferencedDescriptorsContainer abstractReferencedDescriptorsContainer, IComponentFactory iComponentFactory, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IConditionEvaluator iConditionEvaluator, boolean bl) {
        this.componentFactory = iComponentFactory;
        this.parent = window;
        this.listener = iHangingProtocolManipulationListener;
        this.conditionEvaluator = iConditionEvaluator;
        this.restrictTags = bl;
        this.isDescriptorFilterEnabled = iConditionEvaluator != null && iConditionEvaluator.isEvaluationPossible();
        PIconFactory pIconFactory = new PIconFactory(iComponentFactory, 20);
        this.deleteIcon = pIconFactory.loadIcon(CreateAbstractConditionPanel.class, "/icons/hangingGUI/Delete.svg");
        this.addIcon = pIconFactory.loadIcon(CreateAbstractConditionPanel.class, "/icons/hangingGUI/Add.svg");
        this.descriptorPanels = new ArrayList<DescriptorPanel>();
        this.referencedDescriptorsContainer = abstractReferencedDescriptorsContainer;
        this.comboBoxAvailableDescriptors = new EditableComboBox(EditableComboBox.StringFilterTypeEnum.CONTAINS, true);
        iComponentFactory.scaleFont((Component)this.comboBoxAvailableDescriptors);
        this.createCheckBoxes();
        this.init(string);
        this.descriptorListListener = new DescriptorListListener();
        DescriptorRegistry.getInstance().addListDataListener(this.descriptorListListener);
    }

    private void createCheckBoxes() {
        this.descriptorPanels.clear();
        this.selectedDescriptors = new HashMap<Descriptor, DescriptorPanel>();
        ReferencedDescriptor[] referencedDescriptorArray = this.referencedDescriptorsContainer.referencedDescriptors();
        int n = referencedDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = referencedDescriptorArray[n2];
            if (object != null && object.referencedDescriptor() != null) {
                DescriptorPanel descriptorPanel = new DescriptorPanel((ReferencedDescriptor)((Object)object));
                this.descriptorPanels.add(descriptorPanel);
                this.selectedDescriptors.put(object.referencedDescriptor(), descriptorPanel);
            }
            ++n2;
        }
        ((EditableComboBox.FilterableComboBoxModel)this.comboBoxAvailableDescriptors.getModel()).clear();
        for (Object object : DescriptorRegistry.getInstance().getAll()) {
            if (this.restrictTags) {
                if (((Descriptor)object).containsOnlyCFindOrPrivateTags()) {
                    if (this.selectedDescriptors.containsKey(object)) continue;
                    this.addDescriptor((Descriptor)object);
                    continue;
                }
                if (!this.selectedDescriptors.containsKey(object)) continue;
                log.warn("Referenced Descriptor container\"" + this.referencedDescriptorsContainer.toString() + "\" contains the descriptor\"" + ((Descriptor)object).getName() + "\" which uses not only C-Find or private tags... Removed this descriptor.");
                this.referencedDescriptorsContainer.removeDescriptor((Descriptor)object);
                this.descriptorPanels.remove(this.selectedDescriptors.remove(object));
                continue;
            }
            if (this.selectedDescriptors.containsKey(object)) continue;
            this.addDescriptor((Descriptor)object);
        }
    }

    private void rebuildPanelCheckBoxes() {
        this.createCheckBoxes();
        this.panelDescriptorPanels.removeAll();
        for (Component component : this.descriptorPanels) {
            this.panelDescriptorPanels.add(component);
        }
    }

    protected void addDescriptor(Descriptor descriptor) {
        if (!this.isDescriptorFilterEnabled || this.conditionEvaluator.meetsConditions(descriptor.conditions())) {
            ((EditableComboBox.FilterableComboBoxModel)this.comboBoxAvailableDescriptors.getModel()).addElement((Object)descriptor);
        }
    }

    private void init(String string) {
        this.setBorder(this.componentFactory.createTitledBorder(string));
        this.setLayout(new BorderLayout(5, 5));
        this.setOpaque(false);
        JPanel jPanel = ComponentFactory.instance.createPanel(new BorderLayout());
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel2.setOpaque(false);
        this.buttonCreateConditionSet = this.componentFactory.createButton((Action)new CreateConditionSetAction());
        this.comboBoxAvailableDescriptors.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        String string = ((JTextField)CreateAbstractConditionPanel.this.comboBoxAvailableDescriptors.getEditor().getEditorComponent()).getText();
                        if (string.trim().length() > 0) {
                            CreateAbstractConditionPanel.this.comboBoxAvailableDescriptors.setSelectedItem(string);
                            CreateAbstractConditionPanel.this.addSelectedDescriptor();
                            break;
                        }
                        keyEvent.consume();
                    }
                }
            }
        });
        this.comboBoxAvailableDescriptors.addPopupMenuListener(new MyPopupMenuListener());
        this.checkBoxFilterDescriptors = this.componentFactory.createCheckBox(Messages.getString("CreateAbstractConditionPanel.DescriptorsFilter.Text"), null, Boolean.valueOf(this.isDescriptorFilterEnabled));
        this.checkBoxFilterDescriptors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateAbstractConditionPanel.this.isDescriptorFilterEnabled = !CreateAbstractConditionPanel.this.isDescriptorFilterEnabled;
                CreateAbstractConditionPanel.this.rebuildPanelCheckBoxes();
            }
        });
        this.panelDescriptorPanels = ComponentFactory.instance.createPanel((LayoutManager)new RowLayout(0));
        for (Component serializable2 : this.descriptorPanels) {
            this.panelDescriptorPanels.add(serializable2);
        }
        jPanel2.add((Component)this.componentFactory.createLabel((Icon)this.addIcon), "West");
        jPanel2.add((Component)this.comboBoxAvailableDescriptors, "Center");
        Dimension dimension = this.comboBoxAvailableDescriptors.getMinimumSize();
        this.comboBoxAvailableDescriptors.setMinimumSize(new Dimension(GUI.getScaledInt((int)200), (int)dimension.getHeight()));
        if (this.conditionEvaluator != null && this.conditionEvaluator.isEvaluationPossible()) {
            jPanel2.add((Component)this.checkBoxFilterDescriptors, "South");
        }
        this.scrollPaneSelectedConditions = this.componentFactory.createScrollPane((Component)this.panelDescriptorPanels);
        this.scrollPaneSelectedConditions.getVerticalScrollBar().setUnitIncrement(6);
        jPanel.add((Component)this.scrollPaneSelectedConditions, "Center");
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        Dimension dimension2 = this.scrollPaneSelectedConditions.getMinimumSize();
        dimension2.height = this.componentFactory.scaleInt(75);
        this.scrollPaneSelectedConditions.setMinimumSize(dimension2);
        JPanel jPanel3 = ComponentFactory.instance.createPanel();
        jPanel3.setLayout((LayoutManager)new RowLayout(0));
        this.panelButtonAddCreate = ComponentFactory.instance.createPanel(new BorderLayout());
        this.panelButtonAddCreate.add((Component)this.buttonCreateConditionSet, "East");
        jPanel3.add(this.panelButtonAddCreate);
        jPanel2.add((Component)jPanel3, "East");
    }

    protected void addSelectedDescriptor() {
        Object object = this.comboBoxAvailableDescriptors.getSelectedItem();
        if (object instanceof String) {
            object = ((EditableComboBox.FilterableComboBoxModel)this.comboBoxAvailableDescriptors.getModel()).getElementWithName((String)object);
        }
        if (object instanceof Descriptor) {
            ReferencedDescriptor referencedDescriptor = new ReferencedDescriptor((Descriptor)object);
            if (referencedDescriptor.referencedDescriptor().conditionCount() == 0 && !this.componentFactory.showYesNoDialog(Messages.getString("CreateAbstractConditionPanel.ConditionSetEmptyDialogTitle"), Messages.getString("CreateAbstractConditionPanel.ConditionSetEmptyDialog"), (Component)this)) {
                return;
            }
            DescriptorPanel descriptorPanel = new DescriptorPanel(referencedDescriptor);
            int n = Collections.binarySearch(this.descriptorPanels, descriptorPanel);
            if (n < 0) {
                this.panelDescriptorPanels.add((Component)descriptorPanel, -n - 1);
                this.descriptorPanels.add(-n - 1, descriptorPanel);
                this.referencedDescriptorsContainer.addReferencedDescriptor(referencedDescriptor);
                this.selectedDescriptors.put(referencedDescriptor.referencedDescriptor(), descriptorPanel);
                this.comboBoxAvailableDescriptors.removeItem(object);
                this.comboBoxAvailableDescriptors.setSelectedItem(null);
                ((EditableComboBox.FilterableComboBoxModel)this.comboBoxAvailableDescriptors.getModel()).setFilter(null);
                if (this.listener != null) {
                    this.listener.hangingChanged();
                }
            } else {
                log.warn("Descriptor " + (Object)((Object)referencedDescriptor) + " is already selected");
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = 0;
        while (n < this.getComponentCount()) {
            this.recursiveSetEnabled(bl, this.getComponent(n));
            ++n;
        }
    }

    private void recursiveSetEnabled(boolean bl, Component component) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                this.recursiveSetEnabled(bl, component2);
                ++n2;
            }
        }
    }

    public void deregisterListener() {
        DescriptorRegistry.getInstance().removeListDataListener(this.descriptorListListener);
    }

    private class CreateConditionSetAction
    extends AbstractAction {
        public CreateConditionSetAction() {
            super(Messages.getString("CreateAbstractConditionPanel.CreateConditionSet"));
            this.putValue("ShortDescription", Messages.getString("CreateAbstractConditionPanel.CreateConditionSetToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Descriptor descriptor = new Descriptor();
            DescriptorEditDialog descriptorEditDialog = CreateAbstractConditionPanel.this.parent instanceof JDialog ? new DescriptorEditDialog((JDialog)CreateAbstractConditionPanel.this.parent, CreateAbstractConditionPanel.this.componentFactory, descriptor, CreateAbstractConditionPanel.this.restrictTags) : new DescriptorEditDialog((JFrame)CreateAbstractConditionPanel.this.parent, CreateAbstractConditionPanel.this.componentFactory, descriptor, CreateAbstractConditionPanel.this.restrictTags);
            descriptorEditDialog.setVisible(true);
            if (descriptorEditDialog.getDialogResult() == 0) {
                descriptor.setId(DescriptorRegistry.getInstance().getFreeDescriptorID());
                DescriptorRegistry.getInstance().addElement(descriptor);
            }
        }
    }

    private class DescriptorListListener
    implements ListDataListener {
        private DescriptorListListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            CreateAbstractConditionPanel.this.rebuildPanelCheckBoxes();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            if (n < 0 || n2 < 0) {
                CreateAbstractConditionPanel.this.rebuildPanelCheckBoxes();
            } else {
                int n3;
                int n4;
                if (n < n2) {
                    n4 = n;
                    n3 = n2;
                } else {
                    n4 = n2;
                    n3 = n;
                }
                int n5 = n4;
                while (n5 <= n3) {
                    CreateAbstractConditionPanel.this.addDescriptor((Descriptor)DescriptorRegistry.getInstance().getElementAt(n5));
                    ++n5;
                }
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            if (n < 0 || n2 < 0) {
                CreateAbstractConditionPanel.this.rebuildPanelCheckBoxes();
            } else {
                int n3;
                int n4;
                if (n < n2) {
                    n4 = n;
                    n3 = n2;
                } else {
                    n4 = n2;
                    n3 = n;
                }
                int n5 = n3;
                while (n5 >= n4) {
                    Descriptor descriptor = (Descriptor)DescriptorRegistry.getInstance().getElementAt(n5);
                    if (CreateAbstractConditionPanel.this.selectedDescriptors.containsKey(descriptor)) {
                        int n6 = CreateAbstractConditionPanel.this.descriptorPanels.indexOf(CreateAbstractConditionPanel.this.selectedDescriptors.get(descriptor));
                        CreateAbstractConditionPanel.this.selectedDescriptors.remove(descriptor);
                        if (n6 > -1) {
                            CreateAbstractConditionPanel.this.descriptorPanels.remove(n6);
                            CreateAbstractConditionPanel.this.panelDescriptorPanels.remove(n6);
                        }
                    }
                    --n5;
                }
                CreateAbstractConditionPanel.this.panelDescriptorPanels.revalidate();
            }
        }
    }

    private class DescriptorPanel
    extends JPanel
    implements Comparable<DescriptorPanel> {
        private Descriptor descriptor;
        private ReferencedDescriptor referencedDescriptor;
        private JLabel descriptorNameLabel;

        public DescriptorPanel(ReferencedDescriptor referencedDescriptor) {
            this.descriptor = referencedDescriptor.referencedDescriptor();
            this.referencedDescriptor = referencedDescriptor;
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setOpaque(false);
            final Color color = this.getBackground();
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    DescriptorPanel.this.setOpaque(true);
                    DescriptorPanel.this.setBackground(ColorUtils.brighter((Color)color, (float)0.5f));
                    DescriptorPanel.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    DescriptorPanel.this.setOpaque(false);
                    DescriptorPanel.this.setBackground(color);
                    DescriptorPanel.this.repaint();
                }
            };
            this.descriptorNameLabel = CreateAbstractConditionPanel.this.componentFactory.createLabel(this.descriptor.getName());
            this.descriptorNameLabel.addMouseListener(mouseAdapter);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            List<Condition> list = this.descriptor.conditions();
            int n = 0;
            while (n < list.size() - 1) {
                Condition condition = list.get(n);
                stringBuilder.append(ConditionListEntry.formStringWithoutHTMLTag(condition));
                stringBuilder.append("<br>");
                ++n;
            }
            if (list.size() > 0) {
                stringBuilder.append(ConditionListEntry.formStringWithoutHTMLTag(list.get(list.size() - 1)));
            }
            stringBuilder.append("</html>");
            this.descriptorNameLabel.setToolTipText(stringBuilder.toString());
            CreateAbstractConditionPanel.this.buttonDeleteSelectedDescriptor = CreateAbstractConditionPanel.this.componentFactory.createButton((Icon)CreateAbstractConditionPanel.this.deleteIcon);
            CreateAbstractConditionPanel.this.buttonDeleteSelectedDescriptor.addMouseListener(mouseAdapter);
            CreateAbstractConditionPanel.this.buttonDeleteSelectedDescriptor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CreateAbstractConditionPanel.this.referencedDescriptorsContainer.removeReferencedDescriptor(DescriptorPanel.this.referencedDescriptor);
                    CreateAbstractConditionPanel.this.descriptorPanels.remove(DescriptorPanel.this);
                    CreateAbstractConditionPanel.this.panelDescriptorPanels.remove(DescriptorPanel.this);
                    CreateAbstractConditionPanel.this.panelDescriptorPanels.repaint();
                    CreateAbstractConditionPanel.this.addDescriptor(DescriptorPanel.this.descriptor);
                    if (CreateAbstractConditionPanel.this.listener != null) {
                        CreateAbstractConditionPanel.this.listener.hangingChanged();
                    }
                }
            });
            this.add((Component)this.descriptorNameLabel, "Center");
            this.add((Component)CreateAbstractConditionPanel.this.buttonDeleteSelectedDescriptor, "East");
        }

        @Override
        public int compareTo(DescriptorPanel descriptorPanel) {
            return this.descriptor.compareTo(descriptorPanel.descriptor);
        }
    }

    private class MyPopupMenuListener
    implements PopupMenuListener {
        private MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateAbstractConditionPanel.this.addSelectedDescriptor();
                }
            });
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

