/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.attributes;

import com.agfa.pacs.impaxee.hanging.attributes.Attr;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.Tag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDescriptionComparator;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractAttributeFilterSubset
extends AbstractIntermediateXMLElement {
    private static final ALogger log = ALogger.getLogger(AbstractAttributeFilterSubset.class);
    private Map<Integer, Attr> attributes = new LinkedHashMap<Integer, Attr>();

    public Attr getAttr(int n) {
        if (n >= 0 && n < this.attributes.size()) {
            int n2 = 0;
            Iterator<Attr> iterator = this.attributes.values().iterator();
            while (n2 < n && iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return null;
    }

    public void addAttr(Attr attr) {
        this.attributes.put(attr.tagAsInt(), attr);
    }

    public boolean isIn(int n) {
        return this.attributes.containsKey(n);
    }

    public int attributeCount() {
        return this.attributes.size();
    }

    public Attr[] toArray() {
        return this.attributes.values().toArray(new Attr[this.attributes.size()]);
    }

    public void removeAll() {
        this.attributes.clear();
    }

    public List<DicomTag> createDicomTagList(boolean bl) {
        ArrayList<DicomTag> arrayList = new ArrayList<DicomTag>();
        for (Attr attr : this.attributes.values()) {
            try {
                DicomTag dicomTag = TagDictionary.getInstance().getDicomTag(Integer.valueOf(Integer.parseInt(attr.getTag(), 16)));
                if (dicomTag == null) continue;
                arrayList.add(dicomTag);
            }
            catch (NumberFormatException numberFormatException) {
                log.error(String.valueOf(attr.getTag()) + " is not a valid DICOM tag number!", (Throwable)numberFormatException);
            }
        }
        if (bl) {
            Collections.sort(arrayList, TagDescriptionComparator.getInstance());
        }
        return arrayList;
    }

    public List<Tag> createTagList() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Attr attr : this.attributes.values()) {
            try {
                DicomTag dicomTag = TagDictionary.getInstance().getDicomTag(Integer.valueOf(Integer.parseInt(attr.getTag(), 16)));
                if (dicomTag == null) continue;
                arrayList.add((Tag)dicomTag);
            }
            catch (NumberFormatException numberFormatException) {
                log.error(String.valueOf(attr.getTag()) + " is not a valid DICOM tag number!", (Throwable)numberFormatException);
            }
        }
        Collections.sort(arrayList, TagDescriptionComparator.getInstance());
        return arrayList;
    }

    Set<Integer> getAllContainedTags() {
        return this.attributes.keySet();
    }
}

