/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.AbstractDescriptorsXmlLoader;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.hanging.HangingImportExport;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractReferencedDescriptorsContainer;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class HangingXmlLoader
extends AbstractDescriptorsXmlLoader {
    public static final String FILE_EXTENSION = ".AGH";
    private static final ALogger log = ALogger.getLogger(HangingXmlLoader.class);

    public HangingXmlLoader() {
        super(FILE_EXTENSION);
    }

    @Override
    protected boolean importSelectedXmlData(Component component, XmlLoadable xmlLoadable, boolean bl) {
        HangingImportExport hangingImportExport = (HangingImportExport)xmlLoadable;
        List<HangingProtocol> list = hangingImportExport.hangingProtocolsAsList();
        for (HangingProtocol hangingProtocol : list) {
            if (!this.importReferencedDescriptors(hangingProtocol, hangingImportExport, bl)) continue;
            HPRegistry.getInstance().importHangingProtocol(hangingProtocol);
        }
        return true;
    }

    @Override
    protected Class<? extends XmlLoadable> getXmlLoadableClass() {
        return HangingImportExport.class;
    }

    @Override
    protected String getAbortOption() {
        return Messages.getString("HangingXmlLoader.DecriptorConflict.DontImport");
    }

    protected boolean importReferencedDescriptors(HangingProtocol hangingProtocol, HangingImportExport hangingImportExport, boolean bl) {
        AbstractIntermediateXMLElement abstractIntermediateXMLElement;
        int n;
        int n2;
        AbstractIntermediateXMLElement[] abstractIntermediateXMLElementArray;
        Object object2;
        Collection collection = null;
        try {
            collection = hangingProtocol.referencedDescriptorIDs();
        }
        catch (Exception exception) {
            log.error("Error getting descriptor information from hanging protocol", (Throwable)exception);
            return false;
        }
        List<Descriptor> list = hangingImportExport.descriptorsAsList();
        ArrayList<Descriptor> arrayList2 = new ArrayList<Descriptor>();
        for (Descriptor arrayList3 : list) {
            if (!collection.contains(arrayList3.getId())) continue;
            arrayList2.add(arrayList3);
        }
        ArrayList<Descriptor> arrayList = new ArrayList<Descriptor>();
        HashMap hashMap = new HashMap();
        if (!this.collectReferencedDescriptorsForImport(arrayList2, arrayList, hashMap, bl)) {
            return false;
        }
        HashSet<AbstractIntermediateXMLElement> hashSet = new HashSet<AbstractIntermediateXMLElement>();
        for (Object object2 : arrayList) {
            long l = ((Descriptor)object2).getId();
            long l2 = DescriptorRegistry.getInstance().importDescriptor((Descriptor)object2);
            hangingProtocol.updateReferencedDescriptors(l, l2);
            abstractIntermediateXMLElementArray = hangingProtocol.getHangingDefinition().snapshots();
            n2 = abstractIntermediateXMLElementArray.length;
            n = 0;
            while (n < n2) {
                abstractIntermediateXMLElement = abstractIntermediateXMLElementArray[n];
                if (abstractIntermediateXMLElement.getConditionalHanging() != null) {
                    for (ConditionalHangingScreen conditionalHangingScreen : abstractIntermediateXMLElement.getConditionalHanging().screens()) {
                        for (DisplaySetCondition displaySetCondition2 : conditionalHangingScreen.displaySetConditions()) {
                            displaySetCondition2.updateReferencedDescriptors(l, l2);
                            hashSet.add(displaySetCondition2);
                        }
                    }
                }
                ++n;
            }
        }
        object2 = hashMap.keySet();
        Iterator<Object> iterator = object2.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            long l3 = (Long)hashMap.get(l);
            HangingCondition[] hangingConditionArray = hangingProtocol.getHangingApplicability().hangingConditions();
            abstractIntermediateXMLElementArray = hangingConditionArray;
            n2 = hangingConditionArray.length;
            n = 0;
            while (n < n2) {
                abstractIntermediateXMLElement = abstractIntermediateXMLElementArray[n];
                abstractIntermediateXMLElement.updateReferencedDescriptors(l, l3);
                hashSet.add(abstractIntermediateXMLElement);
                ++n;
            }
            abstractIntermediateXMLElementArray = hangingProtocol.getHangingDefinition().snapshots();
            n2 = abstractIntermediateXMLElementArray.length;
            n = 0;
            while (n < n2) {
                abstractIntermediateXMLElement = abstractIntermediateXMLElementArray[n];
                if (abstractIntermediateXMLElement.getConditionalHanging() != null) {
                    for (ConditionalHangingScreen conditionalHangingScreen : abstractIntermediateXMLElement.getConditionalHanging().screens()) {
                        for (DisplaySetCondition displaySetCondition2 : conditionalHangingScreen.displaySetConditions()) {
                            displaySetCondition2.updateReferencedDescriptors(l, l3);
                            hashSet.add(displaySetCondition2);
                        }
                    }
                }
                ++n;
            }
        }
        for (AbstractReferencedDescriptorsContainer abstractReferencedDescriptorsContainer : hashSet) {
            abstractReferencedDescriptorsContainer.rebuildConditions();
        }
        return true;
    }
}

