/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.data.manager.HangingEvaluation;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.attributes.ConfiguredAttributeFilter;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingApplicability;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlUtil;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.util.TagUtils;

public class HangingRuntimeManager
extends DataManagerListenerAdapter {
    private static final ALogger log = ALogger.getLogger(HangingRuntimeManager.class);
    private static final ConfiguredAttributeFilter attributeFilter = ConfiguredAttributeFilter.getInstance();
    private static final DescriptorRegistry descriptorsRegistry = DescriptorRegistry.getInstance();
    private static DataManager dm = DataManager.getInstance();
    private static HangingRuntimeManager instance = new HangingRuntimeManager();
    public static boolean autoHangup = Config.impaxee.jvision.HANGMAN.AutoHangup.get();
    private List<HPEvaluationThread> appendedDataEvalThreads = new ArrayList<HPEvaluationThread>();
    private HPEvaluationThread baseStudyEvalThread;
    private Map<String, AtomicInteger> loadedStudies = new HashMap<String, AtomicInteger>();

    private HangingRuntimeManager() {
        dm.addListener(this);
    }

    public static HangingRuntimeManager getInstance() {
        return instance;
    }

    @Override
    public void patientRemoved(IPatientRepresentation iPatientRepresentation) {
        this.loadedStudies.clear();
        if (this.baseStudyEvalThread != null && this.baseStudyEvalThread.getPatientRepresentation() == iPatientRepresentation) {
            this.baseStudyEvalThread.terminate();
        }
        for (HPEvaluationThread hPEvaluationThread : this.appendedDataEvalThreads) {
            if (hPEvaluationThread.getPatientRepresentation() != iPatientRepresentation) continue;
            hPEvaluationThread.terminate();
        }
        this.appendedDataEvalThreads.clear();
    }

    private EvaluationResult evaluateDescriptor(ReferencedDescriptor referencedDescriptor, IDataObject iDataObject) {
        Condition condition;
        EvaluationResult evaluationResult = EvaluationResult.FALSE;
        Descriptor descriptor = descriptorsRegistry.getDescriptorWithID(referencedDescriptor.getId());
        if (descriptor == null) {
            log.error("Referenced descriptor (ID=" + referencedDescriptor.getId() + ") not found in registry. Returning evaluation result FALSE.");
            return EvaluationResult.FALSE;
        }
        int n = 0;
        while ((condition = descriptor.getCondition(n)) != null && (evaluationResult = this.meetsCondition(condition, iDataObject)) != EvaluationResult.FALSE) {
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug("Evaluation of descriptor(ID=" + referencedDescriptor.getId() + ", name='" + descriptor.getName() + "'): result=" + (Object)((Object)evaluationResult));
        }
        return evaluationResult;
    }

    private boolean checkHangingCondition(HangingCondition hangingCondition2, HangingProtocol hangingProtocol, IDataObject iDataObject) {
        ReferencedDescriptor referencedDescriptor;
        boolean bl = false;
        if (log.isDebugEnabled()) {
            log.debug("Starting evaluating applicability of hanging protocol '" + hangingProtocol.getName() + "'");
        }
        int n = 0;
        while ((referencedDescriptor = hangingCondition2.getReferencedDescriptor(n)) != null) {
            EvaluationResult evaluationResult = this.evaluateDescriptor(referencedDescriptor, iDataObject);
            switch (evaluationResult) {
                case TRUE: {
                    bl = true;
                    break;
                }
                case FALSE: {
                    return false;
                }
            }
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished evaluating applicability of hanging protocol '" + hangingProtocol.getName() + "': result=" + bl);
        }
        return bl;
    }

    private boolean checkPriors(IStudyContainer iStudyContainer, HangingProtocol hangingProtocol) {
        int n = hangingProtocol.getNumberOfPriors();
        switch (hangingProtocol.getUsePriors()) {
            case FIRST_X_PRIORS: 
            case FIRST_X_PRIORS_WITH_LAST: {
                return iStudyContainer.getRelevantPriorCount() >= n;
            }
        }
        return true;
    }

    private boolean checkApplicability(HangingApplicability hangingApplicability, IStudyContainer iStudyContainer, HangingProtocol hangingProtocol) {
        if (iStudyContainer == null) {
            return false;
        }
        if (!this.checkPriors(iStudyContainer, hangingProtocol)) {
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(hangingProtocol.getName()) + " has not enough priors");
            }
            return false;
        }
        try {
            HangingCondition hangingCondition2;
            boolean bl = false;
            int n = 0;
            while ((hangingCondition2 = hangingApplicability.getHangingCondition(n)) != null && !(bl = this.checkHangingCondition(hangingCondition2, hangingProtocol, iStudyContainer.getBaseStudy()))) {
                ++n;
            }
            return bl;
        }
        catch (Exception exception) {
            log.error("Could not check applicability", (Throwable)exception);
            return false;
        }
    }

    private List<HangingProtocol> getActiveHPsForCurrentRole() {
        return HPRegistry.getInstance().getActiveHangingProtocolsForCurrentRole();
    }

    public HangingEvaluation triggerHangingProtocolEvaluation(IPatientRepresentation iPatientRepresentation, boolean bl) {
        if (this.baseStudyEvalThread != null) {
            this.baseStudyEvalThread.terminate();
        }
        this.loadedStudies.clear();
        HangingEvaluation hangingEvaluation = null;
        log.info("Start HP Evaluation:" + iPatientRepresentation.hashCode());
        if (bl) {
            this.baseStudyEvalThread = new HPEvaluationThread(null, iPatientRepresentation, false);
            this.baseStudyEvalThread.start();
        } else {
            List<HangingProtocol> list = this.getActiveHPsForCurrentRole();
            if (autoHangup) {
                IStudyContainer iStudyContainer = iPatientRepresentation.getFirstUncheckedStudyContainers();
                if (iStudyContainer == null) {
                    return null;
                }
                int n = 0;
                while (n < list.size()) {
                    HangingProtocol hangingProtocol = list.get(n);
                    HangingApplicability hangingApplicability = hangingProtocol.getHangingApplicability();
                    if (this.checkApplicability(hangingApplicability, iStudyContainer, hangingProtocol)) {
                        log.debug("hp application success: " + hangingProtocol.getName());
                        hangingEvaluation = new HangingEvaluation(hangingProtocol, iStudyContainer);
                        this.startEvaluationThread(list, iPatientRepresentation, iStudyContainer, ++n);
                        break;
                    }
                    log.debug("hp application failed: " + hangingProtocol.getName());
                    ++n;
                }
            } else {
                this.startEvaluationThread(list, iPatientRepresentation, null, 0);
            }
        }
        return hangingEvaluation;
    }

    private void startEvaluationThread(List<HangingProtocol> list, IPatientRepresentation iPatientRepresentation, IStudyContainer iStudyContainer, int n) {
        List<HangingProtocol> list2 = list.subList(n, list.size());
        if (list2.size() > 0) {
            this.baseStudyEvalThread = new HPEvaluationThread(list2, iPatientRepresentation, true);
            this.baseStudyEvalThread.setStudyContainer(iStudyContainer);
            this.baseStudyEvalThread.start();
        } else {
            this.baseStudyEvalThread = new HPEvaluationThread(list, iPatientRepresentation, false);
            this.baseStudyEvalThread.start();
        }
    }

    private EvaluationResult meetsCondition(Condition condition, IDataObject iDataObject) {
        int n = condition.getTag();
        EvaluationResult evaluationResult = this.evaluateOnRespectiveLevel(condition, iDataObject, n);
        if (log.isTraceEnabled()) {
            String string = iDataObject.resolveString(n);
            log.trace("Evaluating condition: " + XmlUtil.getObjectAsXML((XmlSaveable)condition) + ", value=" + string + ", result=" + (Object)((Object)evaluationResult));
        }
        return evaluationResult;
    }

    private EvaluationResult evaluateOnRespectiveLevel(Condition condition, IDataObject iDataObject, int n) {
        if (TagUtils.isPrivateGroup((int)n)) {
            return Condition.evaluate(condition, iDataObject) ? EvaluationResult.TRUE : EvaluationResult.FALSE;
        }
        if (iDataObject instanceof IStudyData) {
            try {
                if (!attributeFilter.isInStudyLevel(n) && !attributeFilter.isInPatientLevel(n)) {
                    IStudyData iStudyData = (IStudyData)iDataObject;
                    List<ISeriesData> list = iStudyData.getSeries();
                    if (list != null) {
                        for (ISeriesData iSeriesData : list) {
                            if (this.meetsCondition(condition, iSeriesData) != EvaluationResult.TRUE) continue;
                            return EvaluationResult.TRUE;
                        }
                    }
                    return EvaluationResult.FALSE;
                }
                return Condition.evaluate(condition, iDataObject) ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Illegal Argument", (Throwable)illegalArgumentException);
                return EvaluationResult.FALSE;
            }
        }
        if (iDataObject instanceof ISeriesData) {
            try {
                if (!attributeFilter.isInSeriesLevel(n)) {
                    ISeriesData iSeriesData = (ISeriesData)iDataObject;
                    List<IImageObjectData> list = iSeriesData.getObjects();
                    if (list != null) {
                        for (IImageObjectData iImageObjectData : list) {
                            if (this.meetsCondition(condition, iImageObjectData) != EvaluationResult.TRUE) continue;
                            return EvaluationResult.TRUE;
                        }
                    }
                    return EvaluationResult.FALSE;
                }
                return Condition.evaluate(condition, iDataObject) ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Illegal Argument", (Throwable)illegalArgumentException);
                return EvaluationResult.FALSE;
            }
        }
        if (iDataObject instanceof IObjectData) {
            try {
                return Condition.evaluate(condition, iDataObject) ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Illegal Argument", (Throwable)illegalArgumentException);
                return EvaluationResult.FALSE;
            }
        }
        throw new RuntimeException(Messages.getString("HangingDefinitionManager.ExceptionMessageUnknownDataLevel"));
    }

    public boolean meetsConditions(Iterable<Condition> iterable, IHanging iHanging) {
        IStudyData iStudyData;
        IStudyContainer iStudyContainer = iHanging.getStudyContainer();
        if (iStudyContainer != null && (iStudyData = iStudyContainer.getBaseStudy()) != null) {
            for (Condition condition : iterable) {
                if (this.meetsCondition(condition, iStudyData) == EvaluationResult.TRUE) continue;
                return false;
            }
        }
        return true;
    }

    private static enum EvaluationResult {
        TRUE,
        FALSE;

    }

    private class HPEvaluationThread
    extends Thread {
        private List<HangingProtocol> hpList;
        private IPatientRepresentation patientRepresentation;
        private IStudyContainer studyContainer;
        private boolean shouldTerminate;
        private boolean shouldStartAgain;
        private boolean firstActivation;

        HPEvaluationThread(List<HangingProtocol> list, IPatientRepresentation iPatientRepresentation, boolean bl) {
            super("Hanging Protocol Evaluation Thread");
            this.studyContainer = null;
            this.setPriority(1);
            this.hpList = list;
            this.patientRepresentation = iPatientRepresentation;
            this.firstActivation = bl;
        }

        public void setStudyContainer(IStudyContainer iStudyContainer) {
            this.studyContainer = iStudyContainer;
        }

        IPatientRepresentation getPatientRepresentation() {
            return this.patientRepresentation;
        }

        synchronized void terminate() {
            this.shouldTerminate = true;
        }

        private void checkHPs(IStudyContainer iStudyContainer, List<HangingProtocol> list) {
            String string = iStudyContainer.getPreferredHangingID();
            IHanging iHanging = null;
            for (HangingProtocol hangingProtocol : list) {
                if (this.shouldTerminate || this.shouldStartAgain) break;
                HangingApplicability hangingApplicability = hangingProtocol.getHangingApplicability();
                if (!HangingRuntimeManager.this.checkApplicability(hangingApplicability, iStudyContainer, hangingProtocol)) continue;
                if (string != null && hangingProtocol.getName().equals(string)) {
                    iHanging = dm.addHangingProtocol(hangingProtocol, iStudyContainer);
                    continue;
                }
                dm.addHangingProtocol(hangingProtocol, iStudyContainer);
            }
            if (iHanging != null) {
                log.debug("Applying preferred hanging: " + iHanging);
                DataSelectionManager.getInstance().setActiveHanging(this.patientRepresentation, iHanging, true, false);
            }
            dm.notifyPatientRepresentationModified(this.patientRepresentation);
        }

        @Override
        public void run() {
            List<IStudyContainer> list;
            if (this.firstActivation && this.studyContainer != null) {
                this.checkHPs(this.studyContainer, this.hpList);
                this.studyContainer = null;
            }
            if (!(list = this.patientRepresentation.getUncheckedStudyContainers()).isEmpty()) {
                List list2 = HangingRuntimeManager.this.getActiveHPsForCurrentRole();
                while (true) {
                    if (this.studyContainer == null) {
                        for (IStudyContainer iStudyContainer : list) {
                            this.checkHPs(iStudyContainer, list2);
                        }
                    } else {
                        this.checkHPs(this.studyContainer, list2);
                    }
                    if (this.shouldTerminate || !this.shouldStartAgain) break;
                    this.shouldStartAgain = false;
                }
            }
            log.info("finished hanging protocol evaluation thread");
        }
    }
}

