/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.selection;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.selection.AbstractSelectionData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;

public class StudySelectionData
extends AbstractSelectionData<IStudyData> {
    public StudySelectionData(IStudyData iStudyData) {
        super(iStudyData);
    }

    @Override
    public Iterable<IStudyData> getAllData() {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(((IStudyData)this.getLoadedData()).getParent().getKey());
        ISplitAndSortRuntime iSplitAndSortRuntime = iPatientRepresentation.getDecompositionRuntime();
        IDisplaySet[] iDisplaySetArray = iSplitAndSortRuntime.getDisplaySets();
        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray2[n2];
            IStudyData iStudyData = iDisplaySet.getStudy();
            if (!arrayList.contains(iStudyData)) {
                arrayList.add(iStudyData);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public String getLoadedDataTitle() {
        return Messages.getString("StudySelectionData.LoadedData.Title");
    }

    @Override
    public String getAdditionalDataTitle() {
        return Messages.getString("StudySelectionData.AdditionalData.Title");
    }

    @Override
    public JComponent getIcon(IStudyData iStudyData) {
        return null;
    }

    @Override
    protected String getLabelPrefixImpl(IStudyData iStudyData) {
        return null;
    }

    @Override
    public String getLabel(IStudyData iStudyData) {
        String string = iStudyData.getDicomObject().getString(528432);
        String string2 = this.getModalityString(iStudyData);
        String string3 = null;
        Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (date != null) {
            string3 = DateTimeUtils.dateTime2String((Date)date);
        }
        if (string != null) {
            stringBuilder.append(string);
            if (string3 != null || string2 != null && string2.length() > 0) {
                stringBuilder.append("<br>");
            }
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(string2);
            if (string3 != null) {
                stringBuilder.append(" | ");
            }
        }
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private String getModalityString(IStudyData iStudyData) {
        String[] stringArray = iStudyData.getModalitiesInStudy();
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(',').append(string);
                }
                ++n2;
            }
        }
        return stringBuilder.toString();
    }
}

