/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.chart;

import com.agfa.pacs.impaxee.gui.chart.AbstractAxisData;

class AutoLabelAxisData
extends AbstractAxisData {
    private final int tickMarkCount;

    AutoLabelAxisData(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("At least two tick marks are required.");
        }
        this.tickMarkCount = n;
    }

    @Override
    public int getTickMarkCount() {
        return this.tickMarkCount;
    }

    @Override
    public String getTickMarkLabel(int n) {
        double d = AutoLabelAxisData.roundToOneDecimal(this.getMinimum() + (this.getMaximum() - this.getMinimum()) * (double)n / ((double)this.tickMarkCount - 1.0));
        return String.valueOf(d);
    }
}

