/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gsts;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gsts.ILUT;
import com.agfa.pacs.impaxee.gsts.IWindowPreset;
import com.agfa.pacs.impaxee.gsts.LUT;
import com.agfa.pacs.impaxee.gsts.VOILUT;
import com.agfa.pacs.impaxee.gsts.WindowLevelPreset;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUTShape;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLookupTable;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUTFunction;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILookupTable;
import com.agfa.pacs.listtext.dicomobject.presentation.ILUTContainer;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.WindowDef;
import com.tiani.util.TicketOffice;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.dcm4che3.data.Attributes;

public class GrayScaleTransformationSequence
implements Serializable {
    private static final ALogger log = ALogger.getLogger(GrayScaleTransformationSequence.class);
    private static final String UNNAMED_PRESET = Messages.getString("GrayScaleTransformationSequence.WindowLevelPreset.Unnamed");
    private static final String UNNAMED_VOILUT = Messages.getString("GrayScaleTransformationSequence.VOILUT.Unnamed");
    private int inRange;
    private int inBits;
    private ILUT MLUT;
    private ILUT VOILUT;
    private VOILUT[] originalVOILUTs;
    private IWindowPreset currentWindowPreset;
    private ILUT PLUT_BACKUP;
    private ILUT PLUT;
    private WindowLevelPreset[] windowLevelPresets;
    private WindowDef rsDef;
    private boolean invertPostVOI;
    private boolean mono1;
    private int contentID;
    private boolean signed;
    private VOILUTFunction voiLutFunction;

    public GrayScaleTransformationSequence(ILUTContainer iLUTContainer, int n, boolean bl, boolean bl2) {
        this(iLUTContainer, n, bl, bl2, null, null);
    }

    public GrayScaleTransformationSequence(ILUTContainer iLUTContainer, int n, boolean bl, boolean bl2, IImageInformation iImageInformation, IHistogramProvider iHistogramProvider) {
        IVOILUT iVOILUT;
        this.inBits = n;
        this.inRange = 2 << n;
        this.setMono1(bl);
        this.setRsDef(new WindowDef(bl2, n));
        this.signed = bl2;
        if (iImageInformation != null) {
            this.getRsDef().setUnitFromModality(iImageInformation.getModality(), iImageInformation.resolveString(5509121));
        }
        if (iLUTContainer == null) {
            throw new IllegalArgumentException("lutc == null");
        }
        ModalityLUT modalityLUT = iLUTContainer.getModalityLUT();
        if (modalityLUT != null) {
            if (modalityLUT.getModalityLookupTable() != null) {
                this.setModalityLUT(modalityLUT);
                this.getRsDef().setMLUT(this.MLUT);
            } else {
                this.getRsDef().setIntercept(modalityLUT.getRescaleIntercept());
                this.getRsDef().setSlope(modalityLUT.getRescaleSlope());
            }
        }
        if ((iVOILUT = iLUTContainer.getVOILUT(iHistogramProvider)) != null) {
            this.voiLutFunction = iVOILUT.getVoiLutFunction();
            this.windowLevelPresets = WindowLevelPreset.createList(iVOILUT);
            GrayScaleTransformationSequence.updateWindowPresetDescriptions(this.windowLevelPresets, UNNAMED_PRESET);
            this.activateDefaultWindowPreset();
            if (iVOILUT.voiLookupTables().isEmpty()) {
                if (iVOILUT.hasWindow()) {
                    if (Math.abs(iVOILUT.getWindowWidth() - 1.0) < 0.01 && !this.hasBitmapOverlay(iImageInformation)) {
                        log.warn("Found image with minial window with. Stretchening");
                        this.getRsDef().setCenter(-450.0);
                        this.getRsDef().setWidth(1000.0);
                    } else {
                        this.getRsDef().setCenter(iVOILUT.getWindowCenter());
                        this.getRsDef().setWidth(iVOILUT.getWindowWidth());
                    }
                } else {
                    this.getRsDef().computeWindow();
                }
            } else {
                int n2 = iVOILUT.voiLookupTables().size();
                this.originalVOILUTs = new VOILUT[n2];
                int n3 = 0;
                while (n3 < n2) {
                    this.originalVOILUTs[n3] = new VOILUT(((VOILookupTable)iVOILUT.voiLookupTables().get(n3)).getLookupTable(), n + 1, this.signedInputForVOILut(modalityLUT, bl2, n), true, false, this.getRsDef(), bl2);
                    ++n3;
                }
                GrayScaleTransformationSequence.updateWindowPresetDescriptions(this.originalVOILUTs, UNNAMED_VOILUT);
                this.activateDefaultWindowPreset();
                if (iVOILUT.hasWindow()) {
                    this.getRsDef().setCenter(iVOILUT.getWindowCenter());
                    this.getRsDef().setWidth(iVOILUT.getWindowWidth());
                } else {
                    int[] nArray = ((VOILookupTable)iVOILUT.voiLookupTables().get(0)).getLookupTable().getLUTInputRange(this.signedInputForVOILut(modalityLUT, bl2, n));
                    this.getRsDef().setCenter((nArray[0] + nArray[1]) / 2);
                    this.getRsDef().setWidth(nArray[1] - nArray[0]);
                }
            }
        } else {
            this.getRsDef().setDataCenter(this.getRsDef().getGrays() / 2 - this.getOffset());
            this.getRsDef().setDataWidth(this.getRsDef().getGrays());
        }
        PresentationLUT presentationLUT = iLUTContainer.getPresentationLUT();
        if (presentationLUT != null && presentationLUT.getPresentationLookupTable() == null && presentationLUT.getPresentationLUTShape() == null) {
            presentationLUT = null;
        }
        if (presentationLUT != null) {
            if (presentationLUT.getPresentationLUTShape() != null) {
                if (PresentationLUTShape.Inverse == presentationLUT.getPresentationLUTShape() ^ this.isMono1()) {
                    this.setInvertPostVOI(true);
                }
            } else {
                this.PLUT = new LUT(presentationLUT.getPresentationLookupTable().getLookupTable(), n + 1, bl2);
            }
        } else {
            this.PLUT = this.getPresentationLUT();
        }
        this.contentID = (int)TicketOffice.getNewStamp();
    }

    private void setModalityLUT(ModalityLUT modalityLUT) {
        this.MLUT = new LUT(modalityLUT.getModalityLookupTable().getLookupTable(), this.inBits + 1, this.signed, false, true);
    }

    private boolean hasBitmapOverlay(IImageInformation iImageInformation) {
        return iImageInformation.getDataset().containsValue(0x60000040);
    }

    private boolean signedInputForVOILut(ModalityLUT modalityLUT, boolean bl, int n) {
        if (modalityLUT == null || modalityLUT.getModalityLookupTable() == null && modalityLUT.getRescaleIntercept() == null && modalityLUT.getRescaleSlope() == null) {
            return bl;
        }
        if (modalityLUT.getModalityLookupTable() != null) {
            return false;
        }
        if (bl) {
            int n2 = -(1 << n - 1);
            int n3 = (1 << n - 1) - 1;
            if (this.getRsDef().dataToLogical(n2) < 0.0 || this.getRsDef().dataToLogical(n3) < 0.0) {
                return true;
            }
        } else {
            boolean bl2 = false;
            int n4 = (1 << n) - 1;
            if (this.getRsDef().dataToLogical((double)bl2) < 0.0 || this.getRsDef().dataToLogical(n4) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static void updateWindowPresetDescriptions(IWindowPreset[] iWindowPresetArray, String string) {
        if (iWindowPresetArray == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(iWindowPresetArray.length);
        IWindowPreset[] iWindowPresetArray2 = iWindowPresetArray;
        int n = iWindowPresetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWindowPreset iWindowPreset = iWindowPresetArray2[n2];
            if (iWindowPreset.getDescription() == null) {
                iWindowPreset.setDescription(string);
            }
            iWindowPreset.setDescription(GrayScaleTransformationSequence.findUniqueDescription(iWindowPreset, hashSet));
            hashSet.add(iWindowPreset.getDescription());
            ++n2;
        }
    }

    private static String findUniqueDescription(IWindowPreset iWindowPreset, Set<String> set) {
        String string;
        String string2 = string = iWindowPreset.getDescription();
        int n = 1;
        while (set.contains(string2)) {
            string2 = String.valueOf(string) + " (" + n + ')';
            ++n;
        }
        return string2;
    }

    public GrayScaleTransformationSequence(GrayScaleTransformationSequence grayScaleTransformationSequence) {
        this.windowLevelPresets = grayScaleTransformationSequence.windowLevelPresets;
        this.VOILUT = grayScaleTransformationSequence.VOILUT;
        this.originalVOILUTs = grayScaleTransformationSequence.originalVOILUTs;
        this.currentWindowPreset = grayScaleTransformationSequence.currentWindowPreset;
        this.PLUT_BACKUP = grayScaleTransformationSequence.PLUT_BACKUP;
        this.MLUT = grayScaleTransformationSequence.MLUT;
        this.PLUT = grayScaleTransformationSequence.PLUT;
        this.setMono1(grayScaleTransformationSequence.isMono1());
        this.setInvertPostVOI(grayScaleTransformationSequence.isInvertPostVOI());
        this.setRsDef(new WindowDef(grayScaleTransformationSequence.getRsDef()));
        this.inBits = grayScaleTransformationSequence.inBits;
        this.inRange = grayScaleTransformationSequence.inRange;
        this.signed = grayScaleTransformationSequence.signed;
        this.voiLutFunction = grayScaleTransformationSequence.voiLutFunction;
    }

    public void reset(ILUTContainer iLUTContainer) {
        Object object;
        this.setInvertPostVOI(false);
        if (iLUTContainer != null && (object = iLUTContainer.getVOILUT()) != null && object.hasWindow()) {
            this.getRsDef().setCenter(object.getWindowCenter());
            this.getRsDef().setWidth(object.getWindowWidth());
        }
        this.currentWindowPreset = null;
        this.activateDefaultWindowPreset();
        if (this.PLUT_BACKUP != null) {
            this.PLUT = this.PLUT_BACKUP;
        }
        if (this.VOILUT == null) {
            if (iLUTContainer != null && iLUTContainer.getModalityLUT() != null) {
                object = iLUTContainer.getModalityLUT().getRescaleIntercept();
                if (object != null) {
                    this.getRsDef().setIntercept((Double)object);
                } else {
                    this.getRsDef().setIntercept(0.0);
                }
                object = iLUTContainer.getModalityLUT().getRescaleSlope();
                if (object != null) {
                    this.getRsDef().setSlope((Double)object);
                } else {
                    this.getRsDef().setSlope(1.0);
                }
            }
            Object object2 = object = iLUTContainer != null ? iLUTContainer.getVOILUT() : null;
            if (object != null && object.hasWindow()) {
                this.getRsDef().setWidth(object.getWindowWidth());
                this.getRsDef().setCenter(object.getWindowCenter());
            }
        }
        if (iLUTContainer == null || iLUTContainer.getModalityLUT() == null || iLUTContainer.getModalityLUT().getModalityLookupTable() == null) {
            this.getRsDef().setMLUT(null);
        } else {
            if (iLUTContainer.getPresentationLUT() != null && iLUTContainer.getPresentationLUT().getPresentationLUTShape() != null) {
                this.setMono1(PresentationLUTShape.Inverse == iLUTContainer.getPresentationLUT().getPresentationLUTShape());
            }
            if (iLUTContainer.getPresentationLUT() != null && iLUTContainer.getPresentationLUT().getPresentationLookupTable() != null) {
                this.PLUT = new LUT(iLUTContainer.getPresentationLUT().getPresentationLookupTable().getLookupTable(), this.inBits + 1, this.signed);
            }
        }
        this.contentID = (int)TicketOffice.getNewStamp();
    }

    public boolean useNearestNeighbourInterpolation() {
        return this.MLUT != null && !this.MLUT.isMonotoneous() || this.VOILUT != null && !this.VOILUT.isMonotoneous() || this.PLUT != null && !this.PLUT.isMonotoneous();
    }

    public int getContentID() {
        return this.contentID;
    }

    public WindowLevelPreset[] getWindowLevelPresets() {
        return this.windowLevelPresets;
    }

    public ILUT[] getOriginalVOILUTs() {
        return this.originalVOILUTs;
    }

    public ILUT getActiveOriginalVOILUT() {
        if (this.currentWindowPreset instanceof ILUT) {
            return (ILUT)this.currentWindowPreset;
        }
        return null;
    }

    public VOILUTFunction getVOILUTFunction() {
        return this.voiLutFunction;
    }

    public ILUT getVOILUT() {
        return this.VOILUT;
    }

    public boolean hasVOILUT() {
        return this.VOILUT != null || this.originalVOILUTs != null;
    }

    public boolean isModalityLUTEnabled() {
        return this.MLUT != null;
    }

    public boolean hasModalityLUTEnabled() {
        return this.MLUT != null;
    }

    public void useModalityLUT(ILUTContainer iLUTContainer) {
        ModalityLUT modalityLUT;
        this.MLUT = null;
        if (iLUTContainer != null && (modalityLUT = iLUTContainer.getModalityLUT()).getModalityLookupTable() != null) {
            this.setModalityLUT(modalityLUT);
        }
        this.rsDef.setMLUT(this.MLUT);
        this.contentID = this.getContentID();
    }

    public boolean isVOILUTEnabled() {
        return this.VOILUT != null;
    }

    public boolean isWindowPresetActive(String string) {
        return this.currentWindowPreset != null && CompareUtils.equals((Object)this.currentWindowPreset.getDescription(), (Object)string);
    }

    public IWindowPreset getCurrentWindowPreset() {
        return this.currentWindowPreset;
    }

    public void windowVOILUT(short[] sArray) {
        if (this.VOILUT == null) {
            return;
        }
        if (sArray.length != this.VOILUT.getData().length) {
            log.warn("Setting incompatible voilut");
            return;
        }
        int n = 0;
        while (n < this.VOILUT.getData().length) {
            this.VOILUT.getData()[n] = sArray[n];
            ++n;
        }
    }

    private boolean disableVOILUT() {
        if (this.VOILUT == null) {
            return false;
        }
        this.VOILUT = null;
        this.currentWindowPreset = null;
        return true;
    }

    public void activateWindowPreset(String string) {
        if (this.activateWindowPresetImpl(string)) {
            this.contentID = (int)TicketOffice.getNewStamp();
        }
    }

    private boolean activateWindowPresetImpl(String string) {
        if (string == null) {
            return this.disableVOILUT();
        }
        VOILUT vOILUT = (VOILUT)this.findWindowPreset(this.originalVOILUTs, string);
        if (vOILUT != null) {
            return this.activateVOILUT(vOILUT);
        }
        WindowLevelPreset windowLevelPreset = (WindowLevelPreset)this.findWindowPreset(this.windowLevelPresets, string);
        if (windowLevelPreset != null) {
            return this.activateWindowLevelPreset(windowLevelPreset);
        }
        return false;
    }

    private <T extends IWindowPreset> T findWindowPreset(T[] TArray, String string) {
        if (TArray != null) {
            T[] TArray2 = TArray;
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray2[n2];
                if (string.equals(t.getDescription())) {
                    return t;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean activateVOILUT(VOILUT vOILUT) {
        if (this.currentWindowPreset == vOILUT) {
            return false;
        }
        this.currentWindowPreset = vOILUT;
        this.VOILUT = new LUT(vOILUT);
        return true;
    }

    private void activateDefaultWindowPreset() {
        if (this.hasVOILUT()) {
            this.activateVOILUT(this.originalVOILUTs[0]);
        } else if (this.windowLevelPresets != null) {
            this.activateWindowLevelPreset(this.windowLevelPresets[0]);
        }
    }

    public ILUT getPresentationLUT() {
        return this.PLUT;
    }

    public ModalityLUT createModalityLUT() {
        ModalityLUT modalityLUT = new ModalityLUT();
        boolean bl = false;
        if (this.MLUT == null && (this.getRsDef().getSlope() != 1.0 || this.getRsDef().getIntercept() != 0.0)) {
            modalityLUT.setRescaleIntercept(Double.valueOf(this.getRsDef().getIntercept()));
            modalityLUT.setRescaleSlope(Double.valueOf(this.getRsDef().getSlope()));
            bl = true;
        } else if (this.MLUT != null) {
            ModalityLookupTable modalityLookupTable = new ModalityLookupTable();
            modalityLookupTable.setLUTData(this.MLUT.getLUTData());
            modalityLookupTable.setLUTDescriptor(this.MLUT.getLUTDescriptor());
            modalityLUT.setModalityLookupTable(modalityLookupTable);
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return modalityLUT;
    }

    private IVOILUT createVOILUT() {
        if (this.VOILUT != null) {
            return com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT.createEmpty();
        }
        return com.agfa.pacs.listtext.dicomobject.module.ps.VOILUT.create((double)this.getRsDef().getCenter(), (double)this.getRsDef().getWidth(), (VOILUTFunction)this.getVOILUTFunction());
    }

    public PresentationLUT createPresentationLUT() {
        PresentationLUT presentationLUT = null;
        if (this.PLUT != null) {
            PresentationLookupTable presentationLookupTable = new PresentationLookupTable();
            presentationLookupTable.setLUTData(this.PLUT.getLUTData());
            presentationLookupTable.setLUTDescriptor(this.PLUT.getLUTDescriptor());
            presentationLUT = new PresentationLUT();
            presentationLUT.setPresentationLookupTable(presentationLookupTable);
        } else {
            presentationLUT = new PresentationLUT();
            if (this.isMono1()) {
                presentationLUT.setPresentationLUTShape(this.isInvertPostVOI() ? PresentationLUTShape.Identity : PresentationLUTShape.Inverse);
            } else {
                presentationLUT.setPresentationLUTShape(this.isInvertPostVOI() ? PresentationLUTShape.Inverse : PresentationLUTShape.Identity);
            }
        }
        return presentationLUT;
    }

    public void storeTo(Attributes attributes) {
        PresentationLUT presentationLUT;
        IVOILUT iVOILUT;
        ModalityLUT modalityLUT = this.createModalityLUT();
        if (modalityLUT != null) {
            attributes.addAll(modalityLUT.toDataset());
        }
        if ((iVOILUT = this.createVOILUT()) != null) {
            iVOILUT.toDataset(attributes);
        }
        if ((presentationLUT = this.createPresentationLUT()) != null) {
            attributes.addAll(presentationLUT.toDataset());
        }
    }

    public void setInversion(boolean bl) {
        if (this.isInvertPostVOI() ^ bl ^ this.isMono1()) {
            this.contentID = (int)TicketOffice.getNewStamp();
            if (this.PLUT != null) {
                this.PLUT_BACKUP = this.PLUT;
                this.PLUT = null;
            }
        }
        this.setInvertPostVOI(bl ^ this.isMono1());
    }

    public void setUserInversion(boolean bl) {
        this.setInvertPostVOI(bl);
    }

    public boolean getUserInversion() {
        return this.isInvertPostVOI();
    }

    public boolean getInversion() {
        return this.isInvertPostVOI() ^ this.isMono1();
    }

    public boolean hasLUTs() {
        return this.MLUT != null || this.VOILUT != null || this.PLUT != null;
    }

    private boolean activateWindowLevelPreset(WindowLevelPreset windowLevelPreset) {
        if (this.currentWindowPreset == windowLevelPreset) {
            return false;
        }
        this.disableVOILUT();
        this.currentWindowPreset = windowLevelPreset;
        this.getRsDef().setCenter(windowLevelPreset.getWindowCenter());
        this.getRsDef().setWidth(windowLevelPreset.getWindowWidth());
        return true;
    }

    public void setWindow(WindowDef windowDef) {
        this.disableVOILUT();
        this.getRsDef().setNormalizedCenter(windowDef.getNormalizedCenter());
        this.getRsDef().setNormalizedWidth(windowDef.getNormalizedWidth());
        this.contentID = (int)TicketOffice.getNewStamp();
    }

    public WindowDef getWindowDef() {
        return this.getRsDef();
    }

    public int[] getRGBMapping(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.inRange];
        }
        if (this.MLUT == null && this.VOILUT == null) {
            if (this.isSigmoid()) {
                this.plainRICWMappingSigmoid(nArray);
            } else {
                this.plainRICWMapping(nArray);
            }
        } else if (this.MLUT == null && this.VOILUT != null) {
            this.voiMapping(nArray);
        } else if (this.MLUT != null) {
            this.MMapping(nArray);
        }
        return nArray;
    }

    public int getOffset() {
        if (this.signed) {
            return 1 << this.inBits;
        }
        return 0;
    }

    public void setSigned(boolean bl) {
        this.signed = bl;
    }

    private void MMapping(int[] nArray) {
        int[] nArray2 = new int[1 << this.MLUT.getBitsStored()];
        if (this.VOILUT != null) {
            this.voiMapping(nArray2);
        } else if (this.isSigmoid()) {
            this.plainRICWMappingSigmoid(nArray2);
        } else {
            this.plainRICWMapping(nArray2);
        }
        int n = this.MLUT.getBitsStored() - (this.inBits + 1);
        log.debug("TRGB output range is " + nArray2.length + " shi:" + n);
        log.debug("window is " + this.getRsDef());
        short[] sArray = this.MLUT.getData();
        log.debug("SHI:" + n);
        if (n >= 0) {
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = nArray2[sArray[n2] & 0xFFFF];
                ++n2;
            }
        } else {
            n = -n;
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = nArray2[(sArray[n3] & 0xFFFF) << n];
                ++n3;
            }
        }
    }

    private void voiMapping(int[] nArray) {
        int[] nArray2 = null;
        short[] sArray = this.VOILUT.getData();
        int n = this.VOILUT.getBitsStored() - 8;
        int n2 = (1 << this.VOILUT.getBitsStored()) - 1;
        if (this.isInvertPostVOI() ^ this.isMono1() && this.PLUT == null) {
            int n3 = 0;
            while (n3 < this.inRange) {
                int n4 = (n2 - (sArray[n3] & 0xFFFF)) * 255 / n2;
                nArray[n3] = n4 << 24 | n4 << 16 | n4 << 8 | n4;
                ++n3;
            }
        } else {
            int n5;
            int n6 = 0;
            if (this.PLUT != null) {
                int n7;
                nArray2 = new int[nArray.length];
                short[] sArray2 = this.PLUT.getData();
                int n8 = this.PLUT.getBitsStored() - 8;
                n6 = this.VOILUT.getBitsStored() - (this.inBits + 1);
                int n9 = this.inBits + 1 - this.PLUT.getBitsOfIndex();
                if (n9 >= 0) {
                    n7 = 0;
                    while (n7 < nArray2.length) {
                        n5 = (sArray2[n7 >> n9] & 0xFFFF) >> n8;
                        nArray2[n7] = n5 | n5 << 8 | n5 << 16 | n5 << 24;
                        ++n7;
                    }
                } else {
                    n9 = -n9;
                    n7 = 0;
                    while (n7 < nArray2.length) {
                        n5 = (sArray2[n7 << n9] & 0xFFFF) >> n8;
                        nArray2[n7] = n5 | n5 << 8 | n5 << 16 | n5 << 24;
                        ++n7;
                    }
                }
            }
            if (nArray2 != null) {
                int n10 = 0;
                while (n10 < this.inRange) {
                    nArray[n10] = nArray2[(sArray[n10] & 0xFFFF) >> n6];
                    ++n10;
                }
            } else {
                int n11 = 0;
                while (n11 < this.inRange) {
                    n5 = (sArray[n11] & 0xFFFF) >> n;
                    nArray[n11] = n5 << 24 | n5 << 16 | n5 << 8 | n5;
                    ++n11;
                }
            }
        }
        nArray2 = null;
    }

    /*
     * Unable to fully structure code
     */
    private void plainRICWMapping(int[] var1_1) {
        block8: {
            block9: {
                block7: {
                    var2_2 = var1_1.length / this.inRange;
                    var3_3 = this.getRsDef().getDataCenter() + this.getOffset();
                    var5_4 = this.getRsDef().getDataWidth();
                    var7_5 = (int)((var3_3 - var5_4 / 2.0) * (double)var2_2);
                    var8_6 = (int)((var3_3 + var5_4 / 2.0) * (double)var2_2);
                    var11_7 = var1_1.length;
                    if (var7_5 == var8_6) {
                        ++var8_6;
                    }
                    var12_8 = Math.min(var11_7, Math.max(0, var7_5));
                    var13_9 = Math.min(var11_7 - 1, Math.max(0, var8_6));
                    if (!this.isInverted()) break block7;
                    var10_10 = -1;
                    Arrays.fill(var1_1, 0, var12_8, var10_10);
                    var9_12 = var12_8;
                    if (var7_5 != var8_6) {
                        while (var9_12 <= var13_9) {
                            var10_10 = (var8_6 - var9_12) * 255 / (var8_6 - var7_5);
                            var1_1[var9_12] = var10_10 | var10_10 << 8 | var10_10 << 16;
                            ++var9_12;
                        }
                    }
                    Arrays.fill(var1_1, var9_12, var11_7, 0);
                    break block8;
                }
                var14_14 = null;
                if (this.PLUT != null) {
                    var14_14 = this.getPLUT(var1_1.length);
                    var10_11 = var14_14[0];
                } else {
                    var10_11 = 0;
                }
                Arrays.fill(var1_1, 0, var12_8, var10_11);
                var9_13 = var12_8;
                if (var7_5 == var8_6) break block9;
                if (var14_14 == null) ** GOTO lbl44
                var15_15 = var1_1.length - 1;
                while (var9_13 <= var13_9) {
                    var10_11 = (int)((long)(var9_13 - var7_5) * (long)var15_15 / (long)(var8_6 - var7_5));
                    var1_1[var9_13] = var14_14[var10_11];
                    ++var9_13;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    var10_11 = (var9_13 - var7_5) * 255 / (var8_6 - var7_5);
                    var1_1[var9_13] = var10_11 | var10_11 << 8 | var10_11 << 16;
                    ++var9_13;
lbl44:
                    // 2 sources

                    ** while (var9_13 <= var13_9)
                }
            }
            var10_11 = var14_14 != null ? var14_14[var14_14.length - 1] : -1;
            Arrays.fill(var1_1, var9_13, var11_7, var10_11);
        }
    }

    private void plainRICWMappingSigmoid(int[] nArray) {
        double d = this.getRsDef().getDataCenter() + this.getOffset();
        double d2 = this.getRsDef().getDataWidth();
        if (this.isInverted()) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = (int)(255.0 - 255.0 / (1.0 + Math.exp(-4.0 * ((double)n - d) / d2)));
                nArray[n] = n2 | n2 << 8 | n2 << 16;
                ++n;
            }
        } else if (this.PLUT != null) {
            int[] nArray2 = this.getPLUT(nArray.length);
            int n = nArray.length - 1;
            int n3 = 0;
            while (n3 <= nArray.length) {
                int n4 = (int)((double)n / (1.0 + Math.exp(-4.0 * ((double)n3 - d) / d2)));
                nArray[n3] = nArray2[n4];
                ++n3;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                int n5 = (int)(255.0 / (1.0 + Math.exp(-4.0 * ((double)n - d) / d2)));
                nArray[n] = n5 | n5 << 8 | n5 << 16;
                ++n;
            }
        }
    }

    private boolean isInverted() {
        boolean bl;
        boolean bl2 = bl = this.isInvertPostVOI() ^ this.isMono1() && this.PLUT == null;
        if (this.getRsDef().getSlope() < 0.0) {
            bl = !bl;
        }
        return bl;
    }

    private int[] getPLUT(int n) {
        int[] nArray = new int[n];
        short[] sArray = this.PLUT.getData();
        int n2 = this.PLUT.getBitsStored() - 8;
        if (sArray.length > nArray.length) {
            int n3 = (int)(Math.log(sArray.length / nArray.length) / Math.log(2.0));
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = (sArray[n4 << n3] & 0xFFFF) >> n2;
                nArray[n4] = n5 | n5 << 8 | n5 << 16;
                ++n4;
            }
        } else {
            int n6 = (int)(Math.log(nArray.length / (1 << this.PLUT.getBitsOfIndex())) / Math.log(2.0));
            int n7 = 0;
            while (n7 < nArray.length) {
                int n8 = (sArray[n7 >> n6] & 0xFFFF) >> n2;
                nArray[n7] = n8 | n8 << 8 | n8 << 16;
                ++n7;
            }
        }
        return nArray;
    }

    public String toString() {
        return "MLUT:" + this.MLUT + "\nVOILUT:" + this.VOILUT + "\nPLUT:" + this.PLUT + "\n";
    }

    public void setInvertPostVOI(boolean bl) {
        this.invertPostVOI = bl;
    }

    public boolean isInvertPostVOI() {
        return this.invertPostVOI;
    }

    public void setMono1(boolean bl) {
        this.mono1 = bl;
    }

    public boolean isMono1() {
        return this.mono1;
    }

    private boolean isSigmoid() {
        return this.voiLutFunction == VOILUTFunction.Sigmoid;
    }

    public void setRsDef(WindowDef windowDef) {
        this.rsDef = windowDef;
    }

    public WindowDef getRsDef() {
        return this.rsDef;
    }
}

