/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.frameofreference;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.frameofreference.EmptyFrameOfReference;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReference;
import com.agfa.pacs.impaxee.frameofreference.IFrameOfReference;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.agfa.pacs.listtext.lta.deletion.DeletionUtils;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IPatientData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.Pair;
import org.dcm4che3.data.Attributes;

public class FrameOfReferenceManager {
    private static final ALogger LOGGER = ALogger.getLogger(FrameOfReferenceManager.class);
    private static final Object WORLD_TO_WORLD_TRANSFORM_MODIFICATION_LOCK = new Object();
    private static final List<IFrameOfReference> frames = new CopyOnWriteArrayList<IFrameOfReference>();
    private static final Map<Pair<String, String>, List<IObjectInfo>> TRANSFORMS_MARKED_FOR_DELETION = new HashMap<Pair<String, String>, List<IObjectInfo>>();

    public static IFrameOfReference getReferenceContext(IImageInformation iImageInformation) {
        String string = iImageInformation.getFrameOfReferenceUID();
        return FrameOfReferenceManager.getReferenceContext(string, iImageInformation.getDataset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static IFrameOfReference getReferenceContext(String string, Attributes attributes) {
        IFrameOfReference iFrameOfReference = FrameOfReferenceManager.getReferenceContextIfExists(string);
        if (iFrameOfReference != null) {
            return iFrameOfReference;
        }
        List<IFrameOfReference> list = frames;
        synchronized (list) {
            void var4_8;
            for (IFrameOfReference object2 : frames) {
                if (!object2.getFrameOfReferenceUID().equals(string)) continue;
                return object2;
            }
            String string2 = PatientKeyUtils.generatePatientKey((Attributes)attributes);
            IPatientData iPatientData = DataManager.getInstance().getMergedPatient(string2);
            if (iPatientData != null) {
                String string3 = iPatientData.getKey();
            }
            FrameOfReference frameOfReference = new FrameOfReference(string, (String)var4_8);
            frames.add(frameOfReference);
            return frameOfReference;
        }
    }

    private static IFrameOfReference getReferenceContextIfExists(String string) {
        if (string == null) {
            return EmptyFrameOfReference.getInstance();
        }
        for (IFrameOfReference iFrameOfReference : frames) {
            if (!iFrameOfReference.getFrameOfReferenceUID().equals(string)) continue;
            return iFrameOfReference;
        }
        return null;
    }

    public static REGISTRATION_TYPE getTypeOfWorldToWorldTransform(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (string.equals(string2)) {
            return null;
        }
        IWorldToWorldTransform iWorldToWorldTransform = FrameOfReferenceManager.getWorldToWorldTransform(string, string2);
        return iWorldToWorldTransform == null ? null : iWorldToWorldTransform.getType();
    }

    public static boolean hasWorldToWorldTransform(String string, String string2) {
        if (Objects.equals(string, string2)) {
            return true;
        }
        return FrameOfReferenceManager.getTypeOfWorldToWorldTransform(string, string2) != null;
    }

    public static IWorldToWorldTransform getWorldToWorldTransform(String string, String string2) {
        IFrameOfReference iFrameOfReference = FrameOfReferenceManager.getReferenceContextIfExists(string);
        if (iFrameOfReference == null) {
            return null;
        }
        return iFrameOfReference.getWorldToWorldTransform(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWorldToWorldTransform(IWorldToWorldTransform iWorldToWorldTransform) {
        Date date = iWorldToWorldTransform.getContentDateTime();
        if (date == null) {
            LOGGER.warn("World-to-world transforms without content date/time are unsupported.");
            return;
        }
        FrameOfReference frameOfReference = (FrameOfReference)FrameOfReferenceManager.getReferenceContextIfExists(iWorldToWorldTransform.getSourceFrameOfReferenceUID());
        if (frameOfReference == null) {
            LOGGER.warn("Unknown frame of reference: " + iWorldToWorldTransform.getSourceFrameOfReferenceUID());
            return;
        }
        FrameOfReference frameOfReference2 = (FrameOfReference)FrameOfReferenceManager.getReferenceContextIfExists(iWorldToWorldTransform.getDestinationFrameOfReferenceUID());
        if (frameOfReference2 == null) {
            LOGGER.warn("Unknown frame of reference: " + iWorldToWorldTransform.getSourceFrameOfReferenceUID());
            return;
        }
        if (frameOfReference.equals(frameOfReference2)) {
            LOGGER.warn("Unsupported world-to-world transform: Source and destination frame of reference must not be equal.");
            return;
        }
        boolean bl = false;
        Object object = WORLD_TO_WORLD_TRANSFORM_MODIFICATION_LOCK;
        synchronized (object) {
            IWorldToWorldTransform iWorldToWorldTransform2 = frameOfReference.getWorldToWorldTransform(iWorldToWorldTransform.getDestinationFrameOfReferenceUID());
            if (iWorldToWorldTransform2 == null) {
                bl = !iWorldToWorldTransform.getPatient().existsWorldToWorldTransforms();
                iWorldToWorldTransform.getPatient().updateWorldToWorldTransformCount(1);
            } else if (iWorldToWorldTransform2.getContentDateTime().before(date)) {
                FrameOfReferenceManager.markWorldToWorldTransformForDeletion(iWorldToWorldTransform2);
            } else {
                FrameOfReferenceManager.markWorldToWorldTransformForDeletion(iWorldToWorldTransform);
                return;
            }
            frameOfReference.addWorldToWorldTransform(iWorldToWorldTransform);
            frameOfReference2.addWorldToWorldTransform(iWorldToWorldTransform.getInvertedTransform());
        }
        if (bl) {
            FrameOfReferenceManager.repaintAllDisplays();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeWorldToWorldTransform(IWorldToWorldTransform iWorldToWorldTransform) {
        FrameOfReference frameOfReference = (FrameOfReference)FrameOfReferenceManager.getReferenceContextIfExists(iWorldToWorldTransform.getSourceFrameOfReferenceUID());
        if (frameOfReference == null) {
            LOGGER.warn("Unknown frame of reference: " + iWorldToWorldTransform.getSourceFrameOfReferenceUID());
            return false;
        }
        FrameOfReference frameOfReference2 = (FrameOfReference)FrameOfReferenceManager.getReferenceContextIfExists(iWorldToWorldTransform.getDestinationFrameOfReferenceUID());
        if (frameOfReference2 == null) {
            LOGGER.warn("Unknown frame of reference: " + iWorldToWorldTransform.getSourceFrameOfReferenceUID());
            return false;
        }
        boolean bl = false;
        Object object = WORLD_TO_WORLD_TRANSFORM_MODIFICATION_LOCK;
        synchronized (object) {
            boolean bl2 = frameOfReference.removeWorldToWorldTransform(iWorldToWorldTransform);
            boolean bl3 = frameOfReference2.removeWorldToWorldTransform(iWorldToWorldTransform.getInvertedTransform());
            assert (bl2 == bl3) : "Inconsistency in world-to-world transform registry.";
            if (bl2 || bl3) {
                iWorldToWorldTransform.getPatient().updateWorldToWorldTransformCount(-1);
                bl = true;
            }
        }
        return bl;
    }

    private static void updateDisplays() {
        VisData visData;
        if (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get() && (visData = VisData.getLastModified()) != null) {
            visData.getParent().synchronizeWithOthers();
        }
        FrameOfReferenceManager.repaintAllDisplays();
    }

    private static void repaintAllDisplays() {
        List<VisDisplay2> list = null;
        if (JVision2.getMainFrame() != null) {
            list = JVision2.getMainFrame().getDisplays();
        }
        if (list != null) {
            for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                if (!visDisplay2.hasData()) continue;
                visDisplay2.repaint();
            }
        }
    }

    private static boolean markWorldToWorldTransformForDeletion(IWorldToWorldTransform iWorldToWorldTransform) {
        boolean bl;
        LOGGER.debug("Discarding outdated world-to-world transformation: " + iWorldToWorldTransform);
        boolean bl2 = bl = iWorldToWorldTransform.isDeletable() && iWorldToWorldTransform.getObjectInfo() != null;
        if (bl) {
            FrameOfReferenceManager.markWorldToWorldTransformForDeletion(FrameOfReferenceManager.createKey(iWorldToWorldTransform.getSourceFrameOfReferenceUID(), iWorldToWorldTransform.getDestinationFrameOfReferenceUID()), iWorldToWorldTransform.getObjectInfo());
        }
        return bl;
    }

    private static synchronized void markWorldToWorldTransformForDeletion(Pair<String, String> pair, IObjectInfo iObjectInfo) {
        List<IObjectInfo> list = TRANSFORMS_MARKED_FOR_DELETION.get(pair);
        if (list == null) {
            list = new ArrayList<IObjectInfo>(2);
            TRANSFORMS_MARKED_FOR_DELETION.put(pair, list);
        }
        if (!list.contains(iObjectInfo)) {
            list.add(iObjectInfo);
        }
    }

    private static Pair<String, String> createKey(String string, String string2) {
        if (string.compareTo(string2) < 0) {
            return Pair.of((Object)string, (Object)string2);
        }
        return Pair.of((Object)string2, (Object)string);
    }

    public static void resetWorldToWorldTransforms(String string) {
        IFrameOfReference iFrameOfReference = FrameOfReferenceManager.getReferenceContextIfExists(string);
        if (iFrameOfReference != null) {
            for (String string2 : iFrameOfReference.getFrameOfReferenceUIDsWithWorldToWorldTransform()) {
                FrameOfReferenceManager.removeWorldToWorldTransform(iFrameOfReference.getWorldToWorldTransform(string2));
            }
            FrameOfReferenceManager.updateDisplays();
        }
    }

    public static void deleteWorldToWorldTransform(IWorldToWorldTransform iWorldToWorldTransform) {
        if (FrameOfReferenceManager.removeWorldToWorldTransform(iWorldToWorldTransform)) {
            FrameOfReferenceManager.updateDisplays();
        }
        if (FrameOfReferenceManager.markWorldToWorldTransformForDeletion(iWorldToWorldTransform) && !FrameOfReferenceManager.deleteOutdatedWorldToWorldTransforms(iWorldToWorldTransform.getSourceFrameOfReferenceUID(), iWorldToWorldTransform.getDestinationFrameOfReferenceUID())) {
            Message.error(Messages.getString("FrameOfReferenceManager.WorldToWorldTransform.DeletionFailure.Title"), (Object)Messages.getString("FrameOfReferenceManager.WorldToWorldTransform.DeletionFailure.Message"));
            FrameOfReferenceManager.addWorldToWorldTransform(iWorldToWorldTransform);
        }
    }

    public static synchronized boolean deleteOutdatedWorldToWorldTransforms(String string, String string2) {
        block3: {
            Pair<String, String> pair = FrameOfReferenceManager.createKey(string, string2);
            List<IObjectInfo> list = TRANSFORMS_MARKED_FOR_DELETION.get(pair);
            if (!DeletionUtils.deleteInstances(list)) break block3;
            TRANSFORMS_MARKED_FOR_DELETION.remove(pair);
            return true;
        }
        try {
            LOGGER.error("Deletion of outdated world-to-world transform(s) failed.");
        }
        catch (Exception exception) {
            LOGGER.error("Deletion of outdated world-to-world transform(s) failed.", (Throwable)exception);
        }
        return false;
    }

    public static boolean existsUnsavedWorldToWorldTransforms(IPatientData iPatientData) {
        if (iPatientData == null || !iPatientData.existsWorldToWorldTransforms()) {
            return false;
        }
        for (IFrameOfReference iFrameOfReference : FrameOfReferenceManager.getFramesOfPatient(iPatientData.getKey())) {
            for (String string : iFrameOfReference.getFrameOfReferenceUIDsWithWorldToWorldTransform()) {
                IWorldToWorldTransform iWorldToWorldTransform = iFrameOfReference.getWorldToWorldTransform(string);
                if (iWorldToWorldTransform == null || iWorldToWorldTransform.isSaved()) continue;
                return true;
            }
        }
        return false;
    }

    public static void clearAllFrames() {
        for (IFrameOfReference iFrameOfReference : frames) {
            iFrameOfReference.clear();
        }
        LocalizerManager.clear();
    }

    public static void clearLocalizerDataForDisplay(VisDisplay2 visDisplay2) {
        IFrameOfReference iFrameOfReference;
        VisData visData = visDisplay2.getVis(0);
        if (visData != null && (iFrameOfReference = FrameOfReferenceManager.getReferenceContextIfExists(visData.getImageInformation().getFrameOfReferenceUID())) != null) {
            iFrameOfReference.clearDisplay(visDisplay2.getData());
            return;
        }
        LocalizerManager.clearDisplay(visDisplay2);
    }

    public static void removeFramesOfPatient(String string) {
        frames.removeAll(FrameOfReferenceManager.getFramesOfPatient(string));
    }

    public static List<IFrameOfReference> getFramesOfPatient(String string) {
        ArrayList<IFrameOfReference> arrayList = new ArrayList<IFrameOfReference>(4);
        for (IFrameOfReference iFrameOfReference : frames) {
            if (!iFrameOfReference.getPatientKey().equals(string)) continue;
            arrayList.add(iFrameOfReference);
        }
        return arrayList;
    }

    public static Map<String, IFrameOfReference> getFramesOfPatientByUID(String string) {
        List<IFrameOfReference> list = FrameOfReferenceManager.getFramesOfPatient(string);
        HashMap<String, IFrameOfReference> hashMap = new HashMap<String, IFrameOfReference>(list.size());
        for (IFrameOfReference iFrameOfReference : list) {
            hashMap.put(iFrameOfReference.getFrameOfReferenceUID(), iFrameOfReference);
        }
        return hashMap;
    }

    public static enum REGISTRATION_TYPE {
        VERIFIED,
        UNVERIFIED;

    }
}

