/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.descriptors;

import com.agfa.pacs.base.swing.lists.models.ComparatorAdapter;
import com.agfa.pacs.impaxee.AbstractRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.hanging.attributes.ConfiguredAttributeFilter;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DescriptorRegistry
extends AbstractRegistry<Descriptor> {
    private static final ALogger log = ALogger.getLogger(DescriptorRegistry.class);
    private static final String importString = "_IMPORT_";
    private static DescriptorRegistry instance = new DescriptorRegistry();
    private Map<Long, Descriptor> idMap = new HashMap<Long, Descriptor>();

    public static DescriptorRegistry getInstance() {
        return instance;
    }

    private DescriptorRegistry() {
        super(new ArrayList(), new ComparatorAdapter());
        this.loadFromConfig(Config.impaxee.jvision.descriptors.getKey());
    }

    public int addElementImpl(int n, Descriptor descriptor) {
        if (this.idMap.containsKey(descriptor.getId())) {
            log.warn("Discarding descriptor with already existing ID {}: {}", (Object)descriptor.getId(), (Object)descriptor);
            return -1;
        }
        int n2 = super.addElementImpl(n, (Object)descriptor);
        this.idMap.put(descriptor.getId(), descriptor);
        return n2;
    }

    public void removeAll() {
        super.removeAll();
        this.idMap.clear();
    }

    public boolean removeElement(Descriptor descriptor) {
        if (super.removeElement((Object)descriptor)) {
            this.idMap.remove(descriptor.getId());
            return true;
        }
        return false;
    }

    public Descriptor getDescriptorWithID(Long l) {
        return this.idMap.get(l);
    }

    public Descriptor getDescriptorByName(String string) {
        for (Descriptor descriptor : this.getAll()) {
            if (!descriptor.getName().equals(string)) continue;
            return descriptor;
        }
        return null;
    }

    public Long getFreeDescriptorID() {
        boolean bl;
        long l = -1L;
        do {
            bl = true;
            l = (long)(Math.random() * 9.223372036854776E18);
            if (this.idMap.get(l) == null) continue;
            bl = false;
        } while (!bl);
        return l;
    }

    public Long importDescriptor(Descriptor descriptor) {
        Descriptor descriptor2;
        boolean bl = false;
        int n = 1;
        do {
            if ((descriptor2 = DescriptorRegistry.getInstance().getDescriptorByName(descriptor.getName())) == null) {
                bl = true;
                continue;
            }
            if (descriptor2.hasSameConditions(descriptor)) {
                return descriptor2.getId();
            }
            if (descriptor.getName().contains(importString)) {
                try {
                    int n2 = descriptor.getName().lastIndexOf(importString);
                    int n3 = n2 + importString.length();
                    n = Integer.parseInt(descriptor.getName().substring(n3));
                    descriptor.setName(descriptor.getName().substring(0, n2));
                    ++n;
                }
                catch (Exception exception) {}
            }
            descriptor.setName(String.valueOf(descriptor.getName()) + importString + n);
            ++n;
        } while (!bl);
        descriptor2 = DescriptorRegistry.getInstance().getDescriptorWithID(descriptor.getId());
        if (descriptor2 == null) {
            DescriptorRegistry.getInstance().addElement(descriptor);
        } else {
            descriptor.setId(DescriptorRegistry.getInstance().getFreeDescriptorID());
            DescriptorRegistry.getInstance().addElement(descriptor);
        }
        return descriptor.getId();
    }

    public String returnDescriptorAsXML(Descriptor descriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string = new XmlSaver((XmlSaveable)descriptor).toXmlString();
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        catch (MarshalException marshalException) {
            log.error("MarshalException: Cannot convert conditionset to xml " + stringBuilder.toString(), (Throwable)marshalException);
            return null;
        }
        catch (IOException iOException) {
            log.error("IOException: Cannot convert conditionset to xml " + stringBuilder.toString(), (Throwable)iOException);
            return null;
        }
    }

    public String returnAllDescriptorsAsXML() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + string);
        stringBuilder.append("<!-- DO NOT MODIFY, FILE IS PROTECTED -->" + string);
        stringBuilder.append("<descriptors>" + string);
        for (Descriptor descriptor : this.getAll()) {
            try {
                String string2 = new XmlSaver((XmlSaveable)descriptor).toXmlString();
                stringBuilder.append(string2);
            }
            catch (MarshalException marshalException) {
                log.error("Cannot convert conditionset to xml " + stringBuilder.toString(), (Throwable)marshalException);
                return null;
            }
            catch (IOException iOException) {
                log.error("Cannot write conditionset to file " + stringBuilder.toString(), (Throwable)iOException);
                return null;
            }
        }
        stringBuilder.append("</descriptors>");
        return stringBuilder.toString();
    }

    public void save() {
        this.writeToConfig(Config.impaxee.jvision.descriptors.getKey());
    }

    @Override
    protected Descriptor parseXML(String string) {
        XmlLoader xmlLoader = new XmlLoader();
        try {
            return (Descriptor)xmlLoader.load(string, Descriptor.class);
        }
        catch (MarshalException marshalException) {
            log.error("Cannot parse descriptor XML: " + string, (Throwable)marshalException);
            return null;
        }
    }

    public Descriptor findAnalogDescriptor(Descriptor descriptor) {
        for (Descriptor descriptor2 : this.getAll()) {
            if (!descriptor2.hasSameConditions(descriptor)) continue;
            return descriptor2;
        }
        return null;
    }

    public boolean checkLoadingDelay(Condition condition) {
        ArrayList<DicomTag> arrayList = new ArrayList<DicomTag>();
        arrayList.addAll(ConfiguredAttributeFilter.getInstance().getPatientLevel().createDicomTagList(true));
        arrayList.addAll(ConfiguredAttributeFilter.getInstance().getInstanceLevel().createDicomTagList(true));
        arrayList.addAll(ConfiguredAttributeFilter.getInstance().getSeriesLevel().createDicomTagList(true));
        arrayList.addAll(ConfiguredAttributeFilter.getInstance().getStudyLevel().createDicomTagList(true));
        arrayList.addAll(TagDictionary.getInstance().getAllPrivateTagsAsList());
        boolean bl = true;
        for (DicomTag dicomTag : arrayList) {
            if (dicomTag.getNumber().compareTo(condition.getTag()) != 0) continue;
            bl = false;
        }
        return bl;
    }
}

