/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.demographics.model.AbstractDemographicsElement;
import com.agfa.pacs.impaxee.demographics.model.DemographicsLine;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsFontListener;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.SubstituteEvaluation;
import com.tiani.config.mappingfonts.model.Wordgroup;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.config.mappingfonts.model.enums.WordgroupRenderedAs;

public class DemographicsWordGroup
extends AbstractDemographicsElement
implements IDemographicsFontListener {
    private static final String EMPTY_NAME = "- " + Messages.getString("DemographicsWordGroup.Empty") + " -";
    private final Wordgroup wordgroup;
    private DemographicsLine parent;

    public DemographicsWordGroup(Wordgroup wordgroup, DemographicsLine demographicsLine) {
        super(wordgroup.getFont(), demographicsLine.getMergedFont(), demographicsLine.isQuadMapping());
        this.wordgroup = wordgroup;
        this.setParent(demographicsLine);
    }

    public Wordgroup getWordgroup() {
        return this.wordgroup;
    }

    public DemographicsLine getParent() {
        return this.parent;
    }

    @Override
    public void fontChanged(Object object) {
        if (object == this.parent) {
            this.remergeFonts();
        }
    }

    public String getDecimalFormat() {
        return this.wordgroup.getDecimalFormat();
    }

    public LevelOfDetail getLevelOfDetail() {
        return this.wordgroup.getLevelOfDetail();
    }

    public String getMaxlength() {
        return this.wordgroup.getMaxlength();
    }

    public String getPostfix() {
        return this.wordgroup.getPostfix();
    }

    public String getPrefix() {
        return this.wordgroup.getPrefix();
    }

    public WordgroupRenderedAs getRenderedAs() {
        return this.wordgroup.getRenderedAs();
    }

    public String getSubstitute() {
        return this.wordgroup.getSubstitute();
    }

    public SubstituteEvaluation getSubstituteEvaluation() {
        return this.wordgroup.getSubstituteEvaluation();
    }

    public void setDecimalFormat(String string) {
        String string2 = this.wordgroup.getDecimalFormat();
        if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
            this.wordgroup.setDecimalFormat(string);
            this.informListenersContentChanged();
        }
    }

    public void setLevelOfDetail(LevelOfDetail levelOfDetail) {
        LevelOfDetail levelOfDetail2 = this.wordgroup.getLevelOfDetail();
        if (levelOfDetail2 == null && levelOfDetail != null || levelOfDetail2 != null && levelOfDetail2 != levelOfDetail) {
            this.wordgroup.setLevelOfDetail(levelOfDetail);
            this.informListenersContentChanged();
        }
    }

    public void setMaxlength(String string) {
        String string2 = this.wordgroup.getMaxlength();
        if (string2 == null && string != null || string2 != null && !string2.equalsIgnoreCase(string)) {
            this.wordgroup.setMaxlength(string);
            this.informListenersContentChanged();
        }
    }

    public void setPostfix(String string) {
        String string2 = this.wordgroup.getPostfix();
        if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
            this.wordgroup.setPostfix(string);
            this.informListenersContentChanged();
        }
    }

    public void setPrefix(String string) {
        String string2 = this.wordgroup.getPrefix();
        if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
            this.wordgroup.setPrefix(string);
            this.informListenersContentChanged();
        }
    }

    public void setRenderedAs(WordgroupRenderedAs wordgroupRenderedAs) {
        WordgroupRenderedAs wordgroupRenderedAs2 = this.wordgroup.getRenderedAs();
        if (wordgroupRenderedAs2 == null && wordgroupRenderedAs != null || wordgroupRenderedAs2 != null && wordgroupRenderedAs2.getType() != wordgroupRenderedAs.getType()) {
            this.wordgroup.setRenderedAs(wordgroupRenderedAs);
            this.informListenersContentChanged();
        }
    }

    public void setSubstitute(String string) {
        String string2 = this.wordgroup.getSubstitute();
        if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
            this.wordgroup.setSubstitute(string);
            this.informListenersContentChanged();
        }
    }

    public void setSubstituteEvaluation(SubstituteEvaluation substituteEvaluation) {
        SubstituteEvaluation substituteEvaluation2 = this.wordgroup.getSubstituteEvaluation();
        if (substituteEvaluation2 == null && substituteEvaluation != null || substituteEvaluation2 != null && !substituteEvaluation2.equals((Object)substituteEvaluation)) {
            this.wordgroup.setSubstituteEvaluation(substituteEvaluation);
            this.informListenersContentChanged();
        }
    }

    public String toString() {
        String string = this.wordgroup.toString();
        if (string == null || string.isEmpty()) {
            return EMPTY_NAME;
        }
        return this.wordgroup.toString();
    }

    public boolean isFontStyleInherited() {
        return this.wordgroup.getFont() == null || this.wordgroup.getFont().getStyle() == null;
    }

    public boolean isFontSizeInherited() {
        return this.wordgroup.getFont() == null || this.wordgroup.getFont().getSize() == null;
    }

    public boolean isFontColorInherited() {
        return this.wordgroup.getFont() == null || this.wordgroup.getFont().getColor() == null;
    }

    public boolean isFontNameInherited() {
        return this.wordgroup.getFont() == null || this.wordgroup.getFont().getName() == null;
    }

    @Override
    protected Font createLevelFont() {
        this.wordgroup.setFont(new Font());
        return this.wordgroup.getFont();
    }

    public void setParent(DemographicsLine demographicsLine) {
        if (this.parent != null) {
            this.parent.removeMappingFontListener(this);
        }
        this.parent = demographicsLine;
        this.parent.registerMappingFontListener(this);
    }
}

