/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.base.swing.util.RestartNotifier;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.demographics.model.DemographicsDefinition;
import com.agfa.pacs.impaxee.demographics.model.DemographicsStoreError;
import com.agfa.pacs.impaxee.demographics.model.xml.Demographics;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.Line;
import com.tiani.config.mappingfonts.model.MappingConfiguration;
import com.tiani.config.mappingfonts.model.Paragraph;
import com.tiani.config.mappingfonts.model.Wordgroup;
import com.tiani.config.mappingfonts.model.enums.ParagraphLocation;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import java.io.IOException;

public class DemographicsConfigListEntry {
    public static final String DEFAULT_CONDITION_TEXT = "";
    private static final boolean DEFAULT_AUTO_SORT = false;
    private IConfigurationProvider configurationProvider;
    private String configListItemId;
    private String name;
    private DemographicsDefinition demographicsDefinition;
    private Boolean hasWarning = false;
    private final boolean isQuadMapping;
    private Font generalMappingFont;

    public DemographicsConfigListEntry(IConfigurationProvider iConfigurationProvider, String string, boolean bl, Font font) {
        this.isQuadMapping = bl;
        this.generalMappingFont = font;
        this.setConfigurationProvider(iConfigurationProvider, string);
    }

    DemographicsConfigListEntry(String string, boolean bl, Font font, IConfigurationProvider iConfigurationProvider, String string2) {
        this(iConfigurationProvider, string2, bl, font);
        this.setName(string);
    }

    DemographicsConfigListEntry(DemographicsConfigListEntry demographicsConfigListEntry, String string, IConfigurationProvider iConfigurationProvider, String string2) {
        this(string, demographicsConfigListEntry.isQuadMapping, demographicsConfigListEntry.generalMappingFont, iConfigurationProvider, string2);
        iConfigurationProvider.setBoolean("autosort", demographicsConfigListEntry.getAutoSort());
        iConfigurationProvider.setText("conditionText", demographicsConfigListEntry.getCondition());
        this.demographicsDefinition = new DemographicsDefinition(demographicsConfigListEntry.generalMappingFont, new MappingConfiguration(demographicsConfigListEntry.getMappingDefinition().getMappingConfiguration()), demographicsConfigListEntry.isQuadMapping);
        this.saveMappingConfiguration();
    }

    private void setConfigurationProvider(IConfigurationProvider iConfigurationProvider, String string) {
        MappingConfiguration mappingConfiguration;
        this.configurationProvider = iConfigurationProvider;
        this.configListItemId = string;
        this.ensureDefaultFields();
        String string2 = iConfigurationProvider.getText("definition");
        try {
            mappingConfiguration = (MappingConfiguration)((Object)new XmlLoader().load(string2, MappingConfiguration.class));
        }
        catch (MarshalException marshalException) {
            marshalException.printStackTrace();
            mappingConfiguration = new MappingConfiguration();
        }
        this.demographicsDefinition = new DemographicsDefinition(this.generalMappingFont, mappingConfiguration, this.isQuadMapping);
        if (iConfigurationProvider.exists("name")) {
            this.name = iConfigurationProvider.getString("name");
        }
    }

    public String getConfigListItemId() {
        return this.configListItemId;
    }

    public DemographicsStoreError saveMappingConfiguration() {
        MappingConfiguration mappingConfiguration = this.demographicsDefinition.getMappingConfiguration();
        if (!this.isQuadMapping || this.hasPatientName(mappingConfiguration)) {
            XmlSaver xmlSaver = new XmlSaver((XmlSaveable)mappingConfiguration);
            try {
                String string = xmlSaver.toXmlString();
                if (this.configurationProvider.exists("definition")) {
                    String string2 = this.configurationProvider.getText("definition");
                    if (string2 != null) {
                        if (!string2.equals(string)) {
                            this.configurationProvider.setText("definition", string);
                            RestartNotifier.setRestartRequired();
                            this.forceThisLevel();
                        }
                    } else if (string != null) {
                        this.configurationProvider.setText("definition", string);
                        RestartNotifier.setRestartRequired();
                        this.forceThisLevel();
                    }
                } else {
                    this.configurationProvider.setText("definition", string);
                    RestartNotifier.setRestartRequired();
                    this.forceThisLevel();
                }
                this.hasWarning = false;
                return DemographicsStoreError.NONE;
            }
            catch (MarshalException marshalException) {
                return DemographicsStoreError.CANNOT_CREATE_XML;
            }
            catch (IOException iOException) {
                return DemographicsStoreError.CANNOT_CREATE_XML;
            }
        }
        this.hasWarning = true;
        return DemographicsStoreError.MISSING_PATIENT_NAME;
    }

    private boolean hasPatientName(MappingConfiguration mappingConfiguration) {
        Paragraph[] paragraphArray = mappingConfiguration.getParagraphs();
        int n = paragraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            Paragraph paragraph = paragraphArray[n2];
            Line[] lineArray = paragraph.getLines();
            int n3 = lineArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Line line = lineArray[n4];
                Wordgroup[] wordgroupArray = line.getWordgroups();
                int n5 = wordgroupArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Wordgroup wordgroup = wordgroupArray[n6];
                    if (wordgroup.getSubstitute().toUpperCase().contains("PATIENTNAME")) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public void ensureDefaultFields() {
        if (!this.configurationProvider.exists("definition")) {
            String string = this.createDefaultMappingDefinition();
            this.configurationProvider.setText("definition", string == null ? "<mappingConfiguration></mappingConfiguration>" : string);
        }
        if (!this.configurationProvider.exists("conditionText") && !this.configurationProvider.exists("condition")) {
            this.configurationProvider.setText("conditionText", DEFAULT_CONDITION_TEXT);
        }
        if (!this.configurationProvider.exists("autosort")) {
            this.configurationProvider.setBoolean("autosort", false);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.configurationProvider.setString("name", string);
        this.forceThisLevel();
    }

    public boolean getAutoSort() {
        return this.configurationProvider.getBoolean("autosort");
    }

    public String getCondition() {
        return this.configurationProvider.getText("conditionText");
    }

    private String createDefaultMappingDefinition() {
        MappingConfiguration mappingConfiguration = new MappingConfiguration();
        Paragraph paragraph = new Paragraph();
        Line line = new Line();
        Wordgroup wordgroup = new Wordgroup();
        wordgroup.setSubstitute(TagDictionary.getInstance().getDicomTag(Integer.valueOf(0x100010)).getName());
        line.addWordgroup(wordgroup);
        paragraph.addLine(line);
        paragraph.setLocation(ParagraphLocation.TOPLEFT);
        mappingConfiguration.addParagraph(paragraph);
        XmlSaver xmlSaver = new XmlSaver((XmlSaveable)mappingConfiguration);
        try {
            return xmlSaver.toXmlString();
        }
        catch (MarshalException marshalException) {
            marshalException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void mappingFontChanged() {
        this.demographicsDefinition.mappingFontChanged();
    }

    public boolean hasWarning() {
        if (this.hasWarning == null) {
            this.hasWarning = !this.hasPatientName(this.demographicsDefinition.getMappingConfiguration());
        }
        return this.hasWarning;
    }

    public DemographicsDefinition getMappingDefinition() {
        return this.demographicsDefinition;
    }

    public void forceThisLevel() {
        String string;
        boolean bl = this.configurationProvider.getBoolean("autosort");
        this.configurationProvider.setBoolean("autosort", !bl);
        this.configurationProvider.setBoolean("autosort", bl);
        if (this.configurationProvider.exists("conditionText")) {
            string = this.configurationProvider.getText("conditionText");
            this.configurationProvider.setText("conditionText", String.valueOf(string) + "temp");
            this.configurationProvider.setText("conditionText", string);
        } else {
            string = this.configurationProvider.getText("condition");
            this.configurationProvider.removeValue("condition");
            this.configurationProvider.setText("conditionText", string);
        }
        string = this.configurationProvider.getText("definition");
        this.configurationProvider.setText("definition", String.valueOf(string) + "temp");
        this.configurationProvider.setText("definition", string);
        String string2 = this.configurationProvider.getString("name");
        this.configurationProvider.setString("name", String.valueOf(string2) + "temp");
        this.configurationProvider.setString("name", string2);
    }

    public void initFrom(Demographics demographics2) {
        this.configurationProvider.setString("name", demographics2.getName());
        this.configurationProvider.setText("conditionText", demographics2.getCondition() == null ? DEFAULT_CONDITION_TEXT : demographics2.getCondition());
        this.configurationProvider.setBoolean("autosort", demographics2.getAutoSort() == null ? false : demographics2.getAutoSort());
        this.demographicsDefinition = new DemographicsDefinition(this.generalMappingFont, demographics2.getMappingConfiguration(), this.isQuadMapping);
    }

    public String toString() {
        return this.name;
    }

    public String[] getKeyList() {
        return new String[]{"name", "definition", "condition", "conditionText", "autosort"};
    }
}

