/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.fetcher;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DownloadLosslessImagesDataAction
extends AbstractPDataAction {
    public static final String ID = "LOAD_LOSSLESS_IMAGES";
    static final PDataScope[] AVAILABLE_SCOPES = new PDataScope[]{PDataScope.CurrentStudy, PDataScope.CurrentDisplay, PDataScope.CurrentImage};

    @Override
    public PDataScope[] getAvailableScopes() {
        return AVAILABLE_SCOPES;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new DownloadLosslessImagesAction(pDataScope, pDataProvider);
    }

    private class DownloadLosslessImagesAction
    extends AbstractPDataAction.AbstractInnerPAction {
        DownloadLosslessImagesAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(DownloadLosslessImagesDataAction.this, pDataScope, pDataProvider);
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getString("DownloadLosslessImagesAction.Name"));
            if (this.scope != null) {
                stringBuilder.append(" - ");
                stringBuilder.append(this.scope.getName());
            }
            return stringBuilder.toString();
        }

        @Override
        public String getCaption() {
            if (this.scope == null) {
                return Messages.getString("DownloadLosslessImagesAction.Caption");
            }
            return this.scope.getName();
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        protected boolean isEnabledImpl() {
            Set<IImageObjectData> set = this.getImages().keySet();
            if (set == null || set.isEmpty()) {
                return false;
            }
            for (IImageObjectData iImageObjectData : set) {
                if (!iImageObjectData.isPrefetchingLossyImageEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            Map<IImageObjectData, Byte> map = this.getImages();
            if (map == null || map.isEmpty()) {
                return false;
            }
            for (Map.Entry<IImageObjectData, Byte> entry : map.entrySet()) {
                entry.getKey().requestDownloadOfLosslessImage(entry.getValue());
            }
            return true;
        }

        private Map<IImageObjectData, Byte> getImages() {
            VisData visData2;
            HashMap<IImageObjectData, Byte> hashMap = new HashMap<IImageObjectData, Byte>();
            List<VisData> list = this.scope == null ? this.provider.getVisDatas() : AbstractPDataAction.getVisDatas(this.scope);
            for (VisData visData2 : list) {
                IImageObjectData iImageObjectData = visData2.getFrameData().getMainFrame();
                Byte by = (Byte)hashMap.get(iImageObjectData);
                byte by2 = this.getPriority(visData2);
                if (by != null && by <= by2) continue;
                hashMap.put(iImageObjectData, by2);
            }
            if (this.scope == PDataScope.CurrentStudy && (visData2 = AbstractPDataAction.getCurrentImage()) != null) {
                for (ISeriesData iSeriesData : visData2.getFrameData().getParent().getParent().getSeries()) {
                    for (IImageObjectData iImageObjectData : iSeriesData.getObjects()) {
                        if (hashMap.containsKey(iImageObjectData)) continue;
                        hashMap.put(iImageObjectData, (byte)5);
                    }
                }
            }
            return hashMap;
        }

        private byte getPriority(VisData visData) {
            int n = visData.isInView() ? 0 : (visData.getParent().getVisDisplay().hasLastModified() ? 2 : 4);
            return (byte)n;
        }
    }
}

