/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cloneview;

import com.agfa.pacs.base.lic.ILicense;
import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.IUndoInformation;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;

public class CloneViewToggleAction
extends SelectablePAction
implements IEventListener {
    private static final String ID = "SCREEN_CAST";
    private static final ALogger log = ALogger.getLogger(CloneViewToggleAction.class);
    private static ScreenListener screenListener;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getGroupName() {
        return PAction.GENERAL_GROUP;
    }

    @Override
    public String getCaption() {
        return Messages.getString("CloneViewToggleAction.Caption");
    }

    @Override
    public String getToolTipText() {
        return Messages.getString("CloneViewToggleAction.ToolTip");
    }

    @Override
    public boolean perform(Component component) {
        block6: {
            this.notifyActionPerformed();
            if (screenListener != null) {
                screenListener.shutdown();
                return true;
            }
            ILicense iLicense = LicenseManager.getInstance().getLicense("CLONE_VIEW");
            if (iLicense != null) break block6;
            log.warn("No valid license for IMPAX CloneView found.");
            return false;
        }
        try {
            this.storeToTemp(this.getClass().getClassLoader().getResourceAsStream("/CloneView.class"), new File(String.valueOf(Platform.getConfigurationLocation().getURL().getFile()) + File.separator + "CloneView.class"));
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = Config.impaxee.workstation.MONITORS.CloneView.LastLocation1.get().split(",");
            String[] stringArray2 = Config.impaxee.workstation.MONITORS.CloneView.LastLocation2.get().split(",");
            arrayList.add(String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "javaw.exe");
            arrayList.add("-Xms128m");
            arrayList.add("-Xmx128m");
            arrayList.add("-cp");
            arrayList.add(".");
            arrayList.add("CloneView");
            arrayList.add(Long.toString(Config.impaxee.workstation.MONITORS.CloneView.Quality.get()));
            if (Config.impaxee.workstation.MONITORS.CloneView.Monitor1.get()) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
            if (Config.impaxee.workstation.MONITORS.CloneView.Monitor2.get()) {
                arrayList.addAll(Arrays.asList(stringArray2));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(new File(Platform.getConfigurationLocation().getURL().getFile()));
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            screenListener = new ScreenListener(process);
            screenListener.init();
        }
        catch (IOException iOException) {
            log.error("CloneView failed", (Throwable)iOException);
        }
        return true;
    }

    private void storeToTemp(InputStream inputStream, File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtil.copyStreamSimple((InputStream)inputStream, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        inputStream.close();
    }

    public boolean handleEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        if (iEvent.getEventID() == ApplicationManagement.APP_PREPARE_SHUTDOWN) {
            if (screenListener != null) {
                screenListener.shutdown();
                screenListener = null;
            }
            return true;
        }
        return false;
    }

    public boolean handleUndoEvent(IEvent iEvent, IUndoInformation iUndoInformation) {
        return false;
    }

    public IListenerSynchronization getSync() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        if (!Config.impaxee.workstation.MONITORS.CloneView.Monitor1.get() && !Config.impaxee.workstation.MONITORS.CloneView.Monitor2.get()) {
            return false;
        }
        return LicenseManager.getInstance().isLicenseIDSupported("CLONE_VIEW");
    }

    @Override
    public boolean isSelected() {
        return screenListener != null;
    }

    private class ScreenListener
    implements ComponentListener,
    Runnable {
        private Process subProgramm = null;
        private PrintStream outputStream = null;
        private BufferedReader reader = null;

        public ScreenListener(Process process) {
            this.subProgramm = process;
            this.outputStream = new PrintStream(this.subProgramm.getOutputStream());
            this.reader = new BufferedReader(new InputStreamReader(this.subProgramm.getInputStream()));
            this.notifySize();
        }

        public void init() {
            List<VisScreen2> list = JVision2.getMainFrame().getScreens();
            if (Config.impaxee.workstation.MONITORS.CloneView.Monitor1.get()) {
                list.get(0).addComponentListener(screenListener);
            }
            if (Config.impaxee.workstation.MONITORS.CloneView.Monitor2.get() && list.size() > 1) {
                list.get(1).addComponentListener(screenListener);
            }
            Thread thread = new Thread((Runnable)this, "CloneView");
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.start();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.notifySize();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.notifySize();
        }

        public void shutdown() {
            if (this.subProgramm != null) {
                try {
                    this.subProgramm.destroy();
                }
                catch (Exception exception) {
                    log.warn("Could not terminate copying process", (Throwable)exception);
                }
                this.subProgramm = null;
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        private void notifySize() {
            Serializable serializable;
            List<VisScreen2> list = JVision2.getMainFrame().getScreens();
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            if (Config.impaxee.workstation.MONITORS.CloneView.Monitor1.get()) {
                serializable = new Rectangle(list.get(0).getLocationOnScreen());
                arrayList.add(serializable);
                ((Rectangle)serializable).width = list.get(0).getWidth();
                ((Rectangle)serializable).height = list.get(0).getHeight();
            }
            if (list.size() > 1 && Config.impaxee.workstation.MONITORS.CloneView.Monitor2.get()) {
                serializable = new Rectangle(list.get(1).getLocationOnScreen());
                arrayList.add(serializable);
                ((Rectangle)serializable).width = list.get(1).getWidth();
                ((Rectangle)serializable).height = list.get(1).getHeight();
            }
            if (!arrayList.isEmpty()) {
                serializable = new StringBuilder();
                for (Rectangle rectangle : arrayList) {
                    ((StringBuilder)serializable).append(rectangle.x).append(',').append(rectangle.y).append(',').append(rectangle.width).append(',').append(rectangle.height);
                    if (arrayList.size() <= 1) continue;
                    ((StringBuilder)serializable).append(',');
                }
                this.outputStream.println(((StringBuilder)serializable).toString());
                this.outputStream.flush();
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    String string;
                    while ((string = this.reader.readLine()) != null) {
                        String[] stringArray = string.split(",");
                        if (stringArray.length >= 4) {
                            Config.impaxee.workstation.MONITORS.CloneView.LastLocation1.set(StringUtils.concatWith((String)",", (Object[])new Object[]{stringArray[0], stringArray[1], stringArray[2], stringArray[3]}));
                        }
                        if (stringArray.length != 8) continue;
                        Config.impaxee.workstation.MONITORS.CloneView.LastLocation2.set(StringUtils.concatWith((String)",", (Object[])new Object[]{stringArray[4], stringArray[5], stringArray[6], stringArray[7]}));
                    }
                }
                catch (IOException iOException) {
                    log.error("Reading/Parsing error", (Throwable)iOException);
                    continue;
                }
                break;
            }
            CloneViewToggleAction.screenListener = null;
            LicenseManager.getInstance().releaseLicense("CLONE_VIEW");
            CloneViewToggleAction.this.fireSelectionChanged();
        }
    }
}

