/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.cache.IImageHolder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class RGBBufferedImageHolder
extends BufferedImageHolder
implements IImageHolder {
    public final int[] data;

    public RGBBufferedImageHolder(int n, int n2) {
        super(n, n2, 1);
        this.data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public RGBBufferedImageHolder(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public RGBBufferedImageHolder(int n, int n2, int[] nArray) {
        this(n, n2);
        System.arraycopy(nArray, 0, this.data, 0, this.data.length);
    }

    public RGBBufferedImageHolder(int n, int n2, CacheID cacheID) {
        this(n, n2);
        try {
            int[] nArray = cache.referencePersistentInts(cacheID);
            System.arraycopy(nArray, 0, this.data, 0, this.data.length);
        }
        finally {
            cache.releaseReference(cacheID);
        }
    }

    @Override
    public RGBBufferedImageHolder getSubImage(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = this.image.getSubimage(n, n2, n3, n4);
        RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(bufferedImage);
        rGBBufferedImageHolder.iofs = n + n2 * this.width;
        rGBBufferedImageHolder.iline = this.width;
        return rGBBufferedImageHolder;
    }

    public int[] getImageArray() {
        return this.data;
    }

    @Override
    public void clear(int n) {
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = n;
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.clear(0);
    }

    @Override
    public boolean isGrayscale() {
        return false;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }
}

