/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cache;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.impaxee.cache.BufferedImageBuffer;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public abstract class BufferedImageHolder {
    protected static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    public static BasicStroke defaultStroke = new BasicStroke(1.0f);
    public final BufferedImage image;
    public final Graphics2D graphics;
    public final int width;
    public final int stride;
    public final int height;
    public final int numPixels;
    public boolean imgInvalid = true;
    public boolean locked = false;
    public int iofs;
    public int iline;
    private BufferedImageBuffer bib;

    protected BufferedImageHolder(int n, int n2, int n3) {
        this((BufferedImageBuffer)cache.allocObject(BufferedImageBuffer.class, BufferedImageBuffer.getParameterization(n, n2, n3)));
    }

    private BufferedImageHolder(BufferedImageBuffer bufferedImageBuffer) {
        this(bufferedImageBuffer.getImage());
        this.bib = bufferedImageBuffer;
    }

    protected BufferedImageHolder(BufferedImage bufferedImage) {
        SampleModel sampleModel;
        this.image = bufferedImage;
        this.graphics = bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.numPixels = this.width * this.height;
        SampleModel sampleModel2 = bufferedImage.getRaster().getSampleModel();
        int n = -1;
        if (sampleModel2 instanceof SinglePixelPackedSampleModel) {
            sampleModel = (SinglePixelPackedSampleModel)sampleModel2;
            n = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        }
        if (sampleModel2 instanceof PixelInterleavedSampleModel) {
            sampleModel = (PixelInterleavedSampleModel)sampleModel2;
            n = ((ComponentSampleModel)sampleModel).getScanlineStride();
        }
        this.iofs = 0;
        this.iline = n;
        this.stride = n;
    }

    public void clear() {
        this.graphics.clearRect(0, 0, this.width, this.height);
    }

    public abstract void clear(int var1);

    public void release() {
        this.graphics.dispose();
        this.image.flush();
        if (this.bib != null) {
            cache.free((Object)this.bib);
            this.bib = null;
        }
    }

    public abstract Object getImageArray();

    public abstract BufferedImageHolder getSubImage(int var1, int var2, int var3, int var4);

    public abstract boolean isGrayscale();
}

